/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class ServingUrlOptions {
    private BlobKey blobKey;
    private @Nullable Boolean secureUrl;
    private @Nullable Integer imageSize;
    private @Nullable Boolean crop;
    private String googleStorageFileName;

    private ServingUrlOptions() {
    }

    public ServingUrlOptions blobKey(BlobKey blobKey) {
        if (this.googleStorageFileName != null) {
            throw new IllegalArgumentException("Cannot specify both a blobKey and a googleStorageFileName.");
        }
        this.blobKey = blobKey;
        return this;
    }

    boolean hasBlobKey() {
        return this.blobKey != null;
    }

    BlobKey getBlobKey() {
        if (this.blobKey == null) {
            throw new IllegalStateException("blobKey has not been set.");
        }
        return this.blobKey;
    }

    public ServingUrlOptions googleStorageFileName(String fileName) {
        if (this.blobKey != null) {
            throw new IllegalArgumentException("Cannot specify both a blobKey and a googleStorageFileName.");
        }
        this.googleStorageFileName = fileName;
        return this;
    }

    boolean hasGoogleStorageFileName() {
        return this.googleStorageFileName != null;
    }

    String getGoogleStorageFileName() {
        if (this.googleStorageFileName == null) {
            throw new IllegalStateException("googleStorageFileName has not been set.");
        }
        return this.googleStorageFileName;
    }

    public ServingUrlOptions secureUrl(boolean secureUrl) {
        this.secureUrl = secureUrl;
        return this;
    }

    boolean hasSecureUrl() {
        return this.secureUrl != null;
    }

    boolean getSecureUrl() {
        if (this.secureUrl == null) {
            throw new IllegalStateException("secureUrl has not been set.");
        }
        return this.secureUrl;
    }

    public ServingUrlOptions crop(boolean crop) {
        this.crop = crop;
        return this;
    }

    boolean hasCrop() {
        return this.crop != null;
    }

    boolean getCrop() {
        if (this.crop == null) {
            throw new IllegalStateException("crop has not been set.");
        }
        return this.crop;
    }

    public ServingUrlOptions imageSize(int imageSize) {
        if (imageSize > 1600 || imageSize < 0) {
            throw new IllegalArgumentException("Unsupported size: " + imageSize + ". Valid sizes must be between 0 and  " + 1600);
        }
        this.imageSize = imageSize;
        return this;
    }

    boolean hasImageSize() {
        return this.imageSize != null;
    }

    int getImageSize() {
        if (this.imageSize == null) {
            throw new IllegalStateException("imageSize has not been set.");
        }
        return this.imageSize;
    }

    public int hashCode() {
        int hash = 17;
        if (this.blobKey != null) {
            hash = hash * 37 + this.blobKey.hashCode();
        }
        if (this.googleStorageFileName != null) {
            hash = hash * 37 + this.googleStorageFileName.hashCode();
        }
        if (this.secureUrl != null) {
            hash = hash * 37 + this.secureUrl.hashCode();
        }
        if (this.crop != null) {
            hash = hash * 37 + this.crop.hashCode();
        }
        if (this.imageSize != null) {
            hash = hash * 37 + this.imageSize.hashCode();
        }
        return hash;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof ServingUrlOptions) {
            ServingUrlOptions key = (ServingUrlOptions)object;
            return Objects.equals(this.blobKey, key.blobKey) && Objects.equals(this.googleStorageFileName, key.googleStorageFileName) && Objects.equals(this.secureUrl, key.secureUrl) && Objects.equals(this.crop, key.crop) && Objects.equals(this.imageSize, key.imageSize);
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("ServingUrlOptions: blobKey=");
        if (this.blobKey != null) {
            buffer.append(this.blobKey);
        } else {
            buffer.append("None");
        }
        buffer.append(", googleStorageFileName=");
        if (this.googleStorageFileName != null) {
            buffer.append(this.googleStorageFileName);
        } else {
            buffer.append("None");
        }
        buffer.append(", secureUrl=");
        if (this.secureUrl != null) {
            buffer.append(this.secureUrl);
        } else {
            buffer.append("false");
        }
        buffer.append(", hasCrop=");
        if (this.crop != null) {
            buffer.append(this.crop);
        } else {
            buffer.append("false");
        }
        buffer.append(", imageSize=");
        if (this.imageSize != null) {
            buffer.append(this.imageSize);
        } else {
            buffer.append("Not Set");
        }
        buffer.append(".");
        return buffer.toString();
    }

    public static final class Builder {
        public static ServingUrlOptions withBlobKey(BlobKey blobKey) {
            return Builder.withDefaults().blobKey(blobKey);
        }

        public static ServingUrlOptions withGoogleStorageFileName(String googleStorageFileName) {
            return Builder.withDefaults().googleStorageFileName(googleStorageFileName);
        }

        private static ServingUrlOptions withDefaults() {
            return new ServingUrlOptions();
        }

        private Builder() {
        }
    }
}

