/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.images.Image;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

final class ImageImpl
implements Image {
    static final long serialVersionUID = -7970719108027515279L;
    private byte[] imageData;
    private int width;
    private int height;
    private @Nullable Image.Format format;
    private @Nullable BlobKey blobKey;
    private static final int EOI_MARKER = 217;
    private static final int RST_MARKER_START = 208;
    private static final int RST_MARKER_END = 215;
    private static final int TEM_MARKER = 1;
    private static final int HUFFMAN_TABLE_MARKER = 196;
    private static final int ARITHMETIC_CODING_CONDITIONING_MARKER = 204;

    ImageImpl(byte[] imageData) {
        this.setImageData(imageData);
    }

    ImageImpl(BlobKey blobKey) {
        this.width = -1;
        this.height = -1;
        this.blobKey = blobKey;
    }

    @Override
    public int getWidth() {
        if (this.width < 0) {
            this.updateDimensions();
        }
        return this.width;
    }

    @Override
    public int getHeight() {
        if (this.height < 0) {
            this.updateDimensions();
        }
        return this.height;
    }

    @Override
    public @Nullable Image.Format getFormat() {
        if (this.format == null) {
            this.updateDimensions();
        }
        return this.format;
    }

    @Override
    public byte @Nullable [] getImageData() {
        return this.imageData != null ? (byte[])this.imageData.clone() : null;
    }

    @Override
    public void setImageData(byte[] imageData) {
        if (imageData == null) {
            throw new IllegalArgumentException("imageData must not be null");
        }
        if (imageData.length == 0) {
            throw new IllegalArgumentException("imageData must not be empty");
        }
        this.imageData = (byte[])imageData.clone();
        this.width = -1;
        this.height = -1;
        this.format = null;
        this.blobKey = null;
    }

    @Override
    public @Nullable BlobKey getBlobKey() {
        return this.blobKey;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof Image) {
            Image other = (Image)o;
            BlobKey otherBlobKey = other.getBlobKey();
            if (this.blobKey != null || otherBlobKey != null) {
                return Objects.equals(this.blobKey, otherBlobKey);
            }
            return Arrays.equals(this.imageData, other.getImageData());
        }
        return false;
    }

    public int hashCode() {
        if (this.blobKey != null) {
            return this.blobKey.hashCode();
        }
        return Arrays.hashCode(this.imageData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateDimensions() {
        if (this.imageData == null) {
            throw new UnsupportedOperationException("No image data is available.");
        }
        if (this.imageData.length < 8) {
            throw new IllegalArgumentException("imageData must be a valid image");
        }
        if (this.imageData[0] == 71 && this.imageData[1] == 73 && this.imageData[2] == 70) {
            this.updateGifDimensions();
            this.format = Image.Format.GIF;
            return;
        } else if (this.imageData[0] == -119 && this.imageData[1] == 80 && this.imageData[2] == 78 && this.imageData[3] == 71 && this.imageData[4] == 13 && this.imageData[5] == 10 && this.imageData[6] == 26 && this.imageData[7] == 10) {
            this.updatePngDimensions();
            this.format = Image.Format.PNG;
            return;
        } else if (this.imageData[0] == -1 && this.imageData[1] == -40) {
            this.updateJpegDimensions();
            this.format = Image.Format.JPEG;
            return;
        } else if (this.imageData[0] == 73 && this.imageData[1] == 73 && this.imageData[2] == 42 && this.imageData[3] == 0 || this.imageData[0] == 77 && this.imageData[1] == 77 && this.imageData[2] == 0 && this.imageData[3] == 42) {
            this.updateTiffDimensions();
            this.format = Image.Format.TIFF;
            return;
        } else if (this.imageData[0] == 66 && this.imageData[1] == 77) {
            this.updateBmpDimensions();
            this.format = Image.Format.BMP;
            return;
        } else if (this.imageData[0] == 0 && this.imageData[1] == 0 && this.imageData[2] == 1 && this.imageData[3] == 0) {
            this.updateIcoDimensions();
            this.format = Image.Format.ICO;
            return;
        } else {
            if (this.imageData.length <= 16 || this.imageData[0] != 82 || this.imageData[1] != 73 || this.imageData[2] != 70 || this.imageData[3] != 70 || this.imageData[8] != 87 || this.imageData[9] != 69 || this.imageData[10] != 66 || this.imageData[11] != 80) throw new IllegalArgumentException("imageData must be a valid image");
            if (this.imageData[12] == 86 && this.imageData[13] == 80 && this.imageData[14] == 56 && this.imageData[15] == 32) {
                this.updateWebpDimensions();
                this.format = Image.Format.WEBP;
                return;
            } else {
                if (this.imageData[12] != 86 || this.imageData[13] != 80 || this.imageData[14] != 56 || this.imageData[15] != 88) throw new IllegalArgumentException("imageData must be a valid image");
                this.updateWebpVp8xDimensions();
                this.format = Image.Format.WEBP;
            }
        }
    }

    private void updateGifDimensions() {
        if (this.imageData.length < 10) {
            throw new IllegalArgumentException("corrupt GIF format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.getChar(6) & 0xFFFF;
        this.height = buffer.getChar(8) & 0xFFFF;
    }

    private void updatePngDimensions() {
        if (this.imageData.length < 24) {
            throw new IllegalArgumentException("corrupt PNG format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.width = buffer.getInt(16);
        this.height = buffer.getInt(20);
    }

    private void updateJpegDimensions() {
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (ImageImpl.extend(buffer.get()) != 255 || ImageImpl.extend(buffer.get()) != 216) {
            throw new IllegalArgumentException("corrupt JPEG format: Expected SOI marker");
        }
        try {
            while (true) {
                int code;
                if ((code = ImageImpl.extend(buffer.get())) != 255) {
                    continue;
                }
                while (code == 255) {
                    code = ImageImpl.extend(buffer.get());
                }
                if (ImageImpl.isFrameMarker(code)) {
                    buffer.position(buffer.position() + 3);
                    this.height = ImageImpl.extend(buffer.getShort());
                    this.width = ImageImpl.extend(buffer.getShort());
                    return;
                }
                if (code == 217) {
                    throw new IllegalArgumentException("corrupt JPEG format: No frame sgements found.");
                }
                if (code >= 208 && code <= 215 || code == 1) continue;
                int length = ImageImpl.extend(buffer.getShort(buffer.position()));
                buffer.position(buffer.position() + length);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("corrupt JPEG format");
        }
        catch (BufferUnderflowException ex) {
            throw new IllegalArgumentException("corrupt JPEG format");
        }
    }

    private static boolean isFrameMarker(int code) {
        return (code & 0xF0) == 192 && code != 196 && code != 204;
    }

    private static int extend(byte b) {
        return b & 0xFF;
    }

    private static int extend(short s) {
        return s & 0xFFFF;
    }

    private void updateTiffDimensions() {
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        if (this.imageData[0] == 73) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int offset = buffer.getInt(4);
        int ifdSize = buffer.getChar(offset) & 0xFFFF;
        offset += 2;
        for (int i = 0; i < ifdSize && offset + 12 <= this.imageData.length; ++i) {
            int tag = buffer.getChar(offset) & 0xFFFF;
            if (tag == 256 || tag == 257) {
                int type = buffer.getChar(offset + 2) & 0xFFFF;
                int result = type == 3 ? buffer.getChar(offset + 8) & 0xFFFF : (type == 4 ? buffer.getInt(offset + 8) : this.imageData[offset + 8]);
                if (tag == 256) {
                    this.width = result;
                    if (this.height != -1) {
                        return;
                    }
                } else {
                    this.height = result;
                    if (this.width != -1) {
                        return;
                    }
                }
            }
            offset += 12;
        }
        if (this.width == -1 || this.height == -1) {
            throw new IllegalArgumentException("corrupt tiff format");
        }
    }

    private void updateBmpDimensions() {
        if (this.imageData.length < 18) {
            throw new IllegalArgumentException("corrupt BMP format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.get(6) & 0xFF;
        this.height = buffer.get(7) & 0xFF;
        int headerLength = buffer.getInt(14);
        if (headerLength == 12 && this.imageData.length >= 22) {
            this.width = buffer.getChar(18) & 0xFFFF;
            this.height = buffer.getChar(20) & 0xFFFF;
        } else if ((headerLength == 40 || headerLength == 108 || headerLength == 124 || headerLength == 64) && this.imageData.length >= 26) {
            this.width = buffer.getInt(18);
            this.height = buffer.getInt(22);
        } else {
            throw new IllegalArgumentException("corrupt BMP format");
        }
    }

    private void updateIcoDimensions() {
        if (this.imageData.length < 8) {
            throw new IllegalArgumentException("corrupt ICO format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.get(6) & 0xFF;
        this.height = buffer.get(7) & 0xFF;
        if (this.width == 0) {
            this.width = 256;
        }
        if (this.height == 0) {
            this.height = 256;
        }
    }

    private void updateWebpDimensions() {
        boolean keyFrame;
        if (this.imageData.length < 30) {
            throw new IllegalArgumentException("corrupt WEBP format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int bits = buffer.get(20) | buffer.get(21) << 8 | buffer.get(22) << 16;
        boolean bl = keyFrame = (bits & 1) == 0;
        if (!keyFrame) {
            throw new IllegalArgumentException("corrupt WEBP format: not a key frame");
        }
        int profile = bits >> 1 & 7;
        int showFrame = bits >> 4 & 1;
        if (profile > 3) {
            throw new IllegalArgumentException("corrupt WEBP format: invalid profile");
        }
        if (showFrame == 0) {
            throw new IllegalArgumentException("corrupt WEBP format: frame is not visible");
        }
        this.width = ImageImpl.extend(buffer.getShort(26));
        this.height = ImageImpl.extend(buffer.getShort(28));
    }

    private void updateWebpVp8xDimensions() {
        if (this.imageData.length < 32) {
            throw new IllegalArgumentException("corrupt WEBP format");
        }
        ByteBuffer buffer = ByteBuffer.wrap(this.imageData);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.width = buffer.getInt(24);
        this.height = buffer.getInt(28);
    }
}

