/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class Key
implements Serializable,
Comparable<Key> {
    static final long serialVersionUID = -448150158203091507L;
    static final long NOT_ASSIGNED = 0L;
    private final @Nullable Key parentKey;
    private final String kind;
    private @Nullable String appId;
    private long id;
    private final @Nullable String name;
    private transient AppIdNamespace appIdNamespace;

    private Key() {
        this.parentKey = null;
        this.kind = null;
        this.appIdNamespace = null;
        this.id = 0L;
        this.name = null;
    }

    Key(String kind) {
        this(kind, null, 0L);
    }

    Key(String kind, String name) {
        this(kind, null, name);
    }

    Key(String kind, @Nullable Key parentKey) {
        this(kind, parentKey, 0L);
    }

    Key(String kind, @Nullable Key parentKey, long id) {
        this(kind, parentKey, id, null);
    }

    Key(String kind, @Nullable Key parentKey, long id, @Nullable AppIdNamespace appIdNamespace) {
        this(kind, parentKey, id, null, appIdNamespace);
    }

    Key(String kind, @Nullable Key parentKey, String name) {
        this(kind, parentKey, name, null);
    }

    Key(String kind, @Nullable Key parentKey, String name, @Nullable AppIdNamespace appIdNamespace) {
        this(kind, parentKey, 0L, name, appIdNamespace);
    }

    Key(String kind, @Nullable Key parentKey, long id, @Nullable String name, @Nullable AppIdNamespace appIdNamespace) {
        if (kind == null || kind.length() == 0) {
            throw new IllegalArgumentException("No kind specified.");
        }
        if (appIdNamespace == null) {
            appIdNamespace = parentKey == null ? DatastoreApiHelper.getCurrentAppIdNamespace() : parentKey.getAppIdNamespace();
        }
        Key.validateAppIdNamespace(parentKey, appIdNamespace);
        if (name != null) {
            if (name.length() == 0) {
                throw new IllegalArgumentException("Name may not be empty.");
            }
            if (id != 0L) {
                throw new IllegalArgumentException("Id and name may not both be specified at once.");
            }
        }
        this.id = id;
        this.parentKey = parentKey;
        this.name = Key.getString(parentKey, name);
        this.kind = Objects.requireNonNull(Key.getString(parentKey, kind));
        this.appIdNamespace = appIdNamespace;
    }

    private static @Nullable String getString(@Nullable Key parentKey, @Nullable String value) {
        if (value == null || parentKey == null) {
            return value;
        }
        return new String(value);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.appIdNamespace != null) {
            this.appId = this.appIdNamespace.toEncodedString();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.appId != null) {
            this.appIdNamespace = AppIdNamespace.parseEncodedAppIdNamespace(this.appId);
            this.appId = null;
        } else {
            this.appIdNamespace = new AppIdNamespace(DatastoreApiHelper.getCurrentAppId(), "");
        }
        Key.validateAppIdNamespace(this.parentKey, this.appIdNamespace);
    }

    private static void validateAppIdNamespace(@Nullable Key parentKey, @Nullable AppIdNamespace appIdNamespace) {
        if (parentKey != null && appIdNamespace != null && parentKey.getAppIdNamespace() != null && !parentKey.getAppIdNamespace().equals(appIdNamespace)) {
            throw new IllegalArgumentException("Parent key must have same app id and namespace as child.");
        }
    }

    public String getKind() {
        return this.kind;
    }

    public @Nullable Key getParent() {
        return this.parentKey;
    }

    Key getRootKey() {
        Key curKey = this;
        while (curKey.getParent() != null) {
            curKey = curKey.getParent();
        }
        return curKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appIdNamespace == null ? 0 : this.appIdNamespace.hashCode());
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parentKey == null ? 0 : this.parentKey.hashCode());
        return result;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        this.appendToString(buffer);
        return buffer.toString();
    }

    private void appendToString(StringBuffer buffer) {
        String namespace;
        if (this.parentKey != null) {
            this.parentKey.appendToString(buffer);
            buffer.append("/");
        } else if (this.appIdNamespace != null && (namespace = this.appIdNamespace.getNamespace()).length() > 0) {
            buffer.append("!");
            buffer.append(namespace);
            buffer.append(":");
        }
        buffer.append(this.kind);
        buffer.append("(");
        if (this.name != null) {
            buffer.append("\"" + this.name + "\"");
        } else if (this.id == 0L) {
            buffer.append("no-id-yet");
        } else {
            buffer.append(String.valueOf(this.id));
        }
        buffer.append(")");
    }

    public boolean equals(@Nullable Object object) {
        return this.equals(object, true);
    }

    boolean equals(@Nullable Object object, boolean considerNotAssigned) {
        if (object instanceof Key) {
            Key key = (Key)object;
            if (this == key) {
                return true;
            }
            if (!this.appIdNamespace.equals(key.appIdNamespace)) {
                return false;
            }
            if (considerNotAssigned && this.name == null && this.id == 0L && key.id == 0L) {
                return false;
            }
            if (this.id != key.id || !this.kind.equals(key.kind) || !Objects.equals(this.name, key.name)) {
                return false;
            }
            return this.parentKey == key.parentKey || this.parentKey != null && this.parentKey.equals(key.parentKey, considerNotAssigned);
        }
        return false;
    }

    AppIdNamespace getAppIdNamespace() {
        return this.appIdNamespace;
    }

    public String getAppId() {
        return this.appIdNamespace.getAppId();
    }

    public String getNamespace() {
        return this.appIdNamespace.getNamespace();
    }

    public long getId() {
        return this.id;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public Key getChild(String kind, long id) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot get a child of an incomplete key.");
        }
        return new Key(kind, this, id);
    }

    public Key getChild(String kind, String name) {
        if (!this.isComplete()) {
            throw new IllegalStateException("Cannot get a child of an incomplete key.");
        }
        return new Key(kind, this, name);
    }

    public boolean isComplete() {
        return this.id != 0L || this.name != null;
    }

    void setId(long id) {
        if (this.name != null) {
            throw new IllegalArgumentException("Cannot set id; key already has a name.");
        }
        this.id = id;
    }

    void simulatePutForTesting(long testId) {
        this.id = testId;
    }

    private static Iterator<Key> getPathIterator(Key key) {
        LinkedList<Key> stack = new LinkedList<Key>();
        for (Key key2 = key; key2 != null; key2 = key2.getParent()) {
            stack.addFirst(key2);
        }
        return stack.iterator();
    }

    @Override
    public int compareTo(Key other) {
        if (this == other) {
            return 0;
        }
        Iterator<Key> thisPath = Key.getPathIterator(this);
        Iterator<Key> otherPath = Key.getPathIterator(other);
        while (thisPath.hasNext()) {
            Key thisKey = thisPath.next();
            if (otherPath.hasNext()) {
                Key otherKey = otherPath.next();
                int result = Key.compareToInternal(thisKey, otherKey);
                if (result == 0) continue;
                return result;
            }
            return 1;
        }
        return otherPath.hasNext() ? -1 : 0;
    }

    private static int compareToInternal(Key thisKey, Key otherKey) {
        if (thisKey == otherKey) {
            return 0;
        }
        int result = thisKey.getAppIdNamespace().compareTo(otherKey.getAppIdNamespace());
        if (result != 0) {
            return result;
        }
        result = thisKey.getKind().compareTo(otherKey.getKind());
        if (result != 0) {
            return result;
        }
        if (!thisKey.isComplete() && !otherKey.isComplete()) {
            return Key.compareToWithIdentityHash(thisKey, otherKey);
        }
        if (thisKey.getId() != 0L) {
            if (otherKey.getId() == 0L) {
                return -1;
            }
            return Long.compare(thisKey.getId(), otherKey.getId());
        }
        if (otherKey.getId() != 0L) {
            return 1;
        }
        if (thisKey.getName() == null) {
            return otherKey.getName() == null ? 0 : 1;
        }
        return thisKey.getName().compareTo(otherKey.getName());
    }

    static int compareToWithIdentityHash(Key k1, Key k2) {
        return Integer.compare(System.identityHashCode(k1), System.identityHashCode(k2));
    }
}

