/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.remoteapi;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthService;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.api.users.UserService;
import com.google.appengine.api.users.UserServiceFactory;
import com.google.appengine.repackaged.com.google.common.base.Verify;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.storage.onestore.v3.proto2api.OnestoreEntity;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.proto2api.DatastorePb;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RemoteApiServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(RemoteApiServlet.class.getName());
    private static final String[] OAUTH_SCOPES = new String[]{"https://www.googleapis.com/auth/appengine.apis", "https://www.googleapis.com/auth/cloud-platform"};
    private static final String INBOUND_APP_SYSTEM_PROPERTY = "HTTP_X_APPENGINE_INBOUND_APPID";
    private static final String INBOUND_APP_HEADER_NAME = "X-AppEngine-Inbound-AppId";
    private HashSet<String> allowedApps = null;
    private final OAuthService oauthService;

    public RemoteApiServlet() {
        this(OAuthServiceFactory.getOAuthService());
    }

    RemoteApiServlet(OAuthService oauthService) {
        this.oauthService = oauthService;
    }

    boolean checkIsValidRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsKnownInbound(req) && !this.checkIsAdmin(req, res)) {
            return false;
        }
        return this.checkIsValidHeader(req, res);
    }

    private synchronized boolean checkIsKnownInbound(HttpServletRequest req) {
        String inboundAppId;
        if (this.allowedApps == null) {
            this.allowedApps = new HashSet();
            String allowedAppsStr = System.getProperty(INBOUND_APP_SYSTEM_PROPERTY);
            if (allowedAppsStr != null) {
                String[] apps;
                for (String app : apps = allowedAppsStr.split(",")) {
                    this.allowedApps.add(app);
                }
            }
        }
        return (inboundAppId = req.getHeader(INBOUND_APP_HEADER_NAME)) != null && this.allowedApps.contains(inboundAppId);
    }

    private boolean checkIsValidHeader(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (req.getHeader("X-appcfg-api-version") == null) {
            res.setStatus(403);
            res.setContentType("text/plain");
            res.getWriter().println("This request did not contain a necessary header");
            return false;
        }
        return true;
    }

    private boolean checkIsAdmin(HttpServletRequest req, HttpServletResponse res) throws IOException {
        UserService userService = UserServiceFactory.getUserService();
        if (userService.getCurrentUser() != null) {
            if (userService.isUserAdmin()) {
                return true;
            }
            this.respondNotAdmin(res);
            return false;
        }
        try {
            if (this.oauthService.isUserAdmin(OAUTH_SCOPES)) {
                return true;
            }
            this.respondNotAdmin(res);
            return false;
        }
        catch (OAuthRequestException oAuthRequestException) {
            res.sendRedirect(userService.createLoginURL(req.getRequestURI()));
            return false;
        }
    }

    private void respondNotAdmin(HttpServletResponse res) throws IOException {
        res.setStatus(401);
        res.setContentType("text/plain");
        res.getWriter().println("You must be logged in as an administrator, or access from an approved application.");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!this.checkIsValidRequest(req, res)) {
            return;
        }
        res.setContentType("text/plain");
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        StringBuilder outYaml = new StringBuilder().append("{rtok: ").append(req.getParameter("rtok")).append(", app_id: ").append(appId).append("}");
        res.getWriter().println(outYaml);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        RemoteApiPb.Response.Builder response;
        block3: {
            if (!this.checkIsValidRequest(req, res)) {
                return;
            }
            res.setContentType("application/octet-stream");
            response = RemoteApiPb.Response.newBuilder();
            try {
                byte[] responseData = this.executeRequest(req);
                response.setResponse(ByteString.copyFrom(responseData));
                res.setStatus(200);
            }
            catch (Exception e) {
                log.warning("Caught exception while executing remote_api command:\n" + e);
                res.setStatus(200);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(byteStream);
                out.writeObject(e);
                out.close();
                byte[] serializedException = byteStream.toByteArray();
                response.setJavaException(ByteString.copyFrom(serializedException));
                if (!(e instanceof ApiProxy.ApplicationException)) break block3;
                ApiProxy.ApplicationException ae = (ApiProxy.ApplicationException)e;
                response.getApplicationErrorBuilder().setCode(ae.getApplicationError()).setDetail(ae.getErrorDetail());
            }
        }
        response.build().writeTo((OutputStream)res.getOutputStream());
    }

    private byte[] executeRunQuery(RemoteApiPb.Request.Builder request) {
        DatastorePb.Query.Builder queryRequest = DatastorePb.Query.newBuilder();
        RemoteApiServlet.parseFromBytes(queryRequest, request.getRequestIdBytes().toByteArray());
        int batchSize = Math.max(1000, queryRequest.getLimit());
        queryRequest.setCount(batchSize);
        DatastorePb.QueryResult.Builder runQueryResponse = DatastorePb.QueryResult.newBuilder();
        byte[] res = ApiProxy.makeSyncCall("datastore_v3", "RunQuery", request.getRequest().toByteArray());
        RemoteApiServlet.parseFromBytes(runQueryResponse, res);
        if (queryRequest.hasLimit()) {
            while (runQueryResponse.getMoreResults()) {
                DatastorePb.NextRequest.Builder nextRequest = DatastorePb.NextRequest.newBuilder();
                nextRequest.getCursorBuilder().mergeFrom(runQueryResponse.getCursor());
                nextRequest.setCount(batchSize);
                byte[] nextRes = ApiProxy.makeSyncCall("datastore_v3", "Next", nextRequest.build().toByteArray());
                RemoteApiServlet.parseFromBytes(runQueryResponse, nextRes);
            }
        }
        return runQueryResponse.build().toByteArray();
    }

    private byte[] executeTxQuery(RemoteApiPb.Request.Builder request) {
        RemoteApiPb.TransactionQueryResult.Builder result = RemoteApiPb.TransactionQueryResult.newBuilder();
        DatastorePb.Query.Builder query = DatastorePb.Query.newBuilder();
        RemoteApiServlet.parseFromBytes(query, request.getRequest().toByteArray());
        if (!query.hasAncestor()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getNumber(), "No ancestor in transactional query.");
        }
        OnestoreEntity.Reference.Builder egKey = result.getEntityGroupKeyBuilder().mergeFrom(query.getAncestor());
        OnestoreEntity.Path.Element root = egKey.getPath().getElement(0);
        egKey.getPathBuilder().clearElement().addElement(root);
        OnestoreEntity.Path.Element egElement = OnestoreEntity.Path.Element.newBuilder().setType("__entity_group__").setId(1L).build();
        egKey.getPathBuilder().addElement(egElement);
        byte[] tx = RemoteApiServlet.beginTransaction(false);
        RemoteApiServlet.parseFromBytes(query.getTransactionBuilder(), tx);
        byte[] queryBytes = ApiProxy.makeSyncCall("datastore_v3", "RunQuery", query.build().toByteArray());
        RemoteApiServlet.parseFromBytes(result.getResultBuilder(), queryBytes);
        DatastorePb.GetRequest.Builder egRequest = DatastorePb.GetRequest.newBuilder();
        egRequest.addKey(egKey);
        DatastorePb.GetResponse.Builder egResponse = RemoteApiServlet.txGet(tx, egRequest);
        if (egResponse.getEntity(0).hasEntity()) {
            result.setEntityGroup(egResponse.getEntity(0).getEntity());
        }
        RemoteApiServlet.rollback(tx);
        return result.build().toByteArray();
    }

    private void assertEntityResultMatchesPrecondition(DatastorePb.GetResponse.Entity entityResult, RemoteApiPb.TransactionRequest.Precondition precondition) {
        if (precondition.hasHash() != entityResult.hasEntity()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getNumber(), "Transaction precondition failed");
        }
        if (entityResult.hasEntity()) {
            OnestoreEntity.EntityProto entity = entityResult.getEntity();
            if (Arrays.equals(precondition.getHashBytes().toByteArray(), RemoteApiServlet.computeSha1(entity))) {
                return;
            }
            byte[] backwardsCompatibleHash = RemoteApiServlet.computeSha1OmittingLastByteForBackwardsCompatibility(entity);
            if (!Arrays.equals(precondition.getHashBytes().toByteArray(), backwardsCompatibleHash)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getNumber(), "Transaction precondition failed");
            }
        }
    }

    private byte[] executeTx(RemoteApiPb.Request.Builder request) {
        RemoteApiPb.TransactionRequest.Builder txRequest = RemoteApiPb.TransactionRequest.newBuilder();
        RemoteApiServlet.parseFromBytes(txRequest, request.getRequest().toByteArray());
        byte[] tx = RemoteApiServlet.beginTransaction(txRequest.getAllowMultipleEg());
        List<RemoteApiPb.TransactionRequest.Precondition> preconditions = txRequest.getPreconditionList();
        if (!preconditions.isEmpty()) {
            DatastorePb.GetRequest.Builder getRequest = DatastorePb.GetRequest.newBuilder();
            for (RemoteApiPb.TransactionRequest.Precondition precondition : preconditions) {
                OnestoreEntity.Reference key = precondition.getKey();
                getRequest.addKeyBuilder().mergeFrom(key);
            }
            DatastorePb.GetResponse.Builder getResponse = RemoteApiServlet.txGet(tx, getRequest);
            List<DatastorePb.GetResponse.Entity> entities = getResponse.getEntityList();
            assert (entities.size() == preconditions.size());
            for (int i = 0; i < entities.size(); ++i) {
                this.assertEntityResultMatchesPrecondition(entities.get(i), preconditions.get(i));
            }
        }
        byte[] res = new byte[]{};
        if (txRequest.hasPuts()) {
            DatastorePb.PutRequest.Builder putRequest = txRequest.getPutsBuilder();
            RemoteApiServlet.parseFromBytes(putRequest.getTransactionBuilder(), tx);
            res = ApiProxy.makeSyncCall("datastore_v3", "Put", putRequest.build().toByteArray());
        }
        if (txRequest.hasDeletes()) {
            DatastorePb.DeleteRequest.Builder deleteRequest = txRequest.getDeletesBuilder();
            RemoteApiServlet.parseFromBytes(deleteRequest.getTransactionBuilder(), tx);
            ApiProxy.makeSyncCall("datastore_v3", "Delete", deleteRequest.build().toByteArray());
        }
        ApiProxy.makeSyncCall("datastore_v3", "Commit", tx);
        return res;
    }

    private byte[] executeGetIDs(RemoteApiPb.Request.Builder request, boolean isXg) {
        DatastorePb.PutRequest.Builder putRequest = DatastorePb.PutRequest.newBuilder();
        RemoteApiServlet.parseFromBytes(putRequest, request.getRequest().toByteArray());
        for (OnestoreEntity.EntityProto entity : putRequest.getEntityList()) {
            Verify.verify(entity.getPropertyCount() == 0);
            Verify.verify(entity.getRawPropertyCount() == 0);
            Verify.verify(entity.getEntityGroup().getElementCount() == 0);
            List<OnestoreEntity.Path.Element> elementList = entity.getKey().getPath().getElementList();
            OnestoreEntity.Path.Element lastPart = elementList.get(elementList.size() - 1);
            Verify.verify(lastPart.getId() == 0L);
            Verify.verify(!lastPart.hasName());
        }
        byte[] tx = RemoteApiServlet.beginTransaction(isXg);
        RemoteApiServlet.parseFromBytes(putRequest.getTransactionBuilder(), tx);
        byte[] res = ApiProxy.makeSyncCall("datastore_v3", "Put", putRequest.build().toByteArray());
        RemoteApiServlet.rollback(tx);
        return res;
    }

    private byte[] executeRequest(HttpServletRequest req) throws IOException {
        RemoteApiPb.Request.Builder request = RemoteApiPb.Request.newBuilder();
        RemoteApiServlet.parseFromInputStream(request, (InputStream)req.getInputStream());
        String service = request.getServiceName();
        String method = request.getMethod();
        log.fine("remote API call: " + service + ", " + method);
        if (service.equals("remote_datastore")) {
            if (method.equals("RunQuery")) {
                return this.executeRunQuery(request);
            }
            if (method.equals("Transaction")) {
                return this.executeTx(request);
            }
            if (method.equals("TransactionQuery")) {
                return this.executeTxQuery(request);
            }
            if (method.equals("GetIDs")) {
                return this.executeGetIDs(request, false);
            }
            if (method.equals("GetIDsXG")) {
                return this.executeGetIDs(request, true);
            }
            throw new ApiProxy.CallNotFoundException(service, method);
        }
        return ApiProxy.makeSyncCall(service, method, request.getRequest().toByteArray());
    }

    private static byte[] beginTransaction(boolean allowMultipleEg) {
        String appId = ApiProxy.getCurrentEnvironment().getAppId();
        byte[] req = DatastorePb.BeginTransactionRequest.newBuilder().setApp(appId).setAllowMultipleEg(allowMultipleEg).build().toByteArray();
        return ApiProxy.makeSyncCall("datastore_v3", "BeginTransaction", req);
    }

    private static void rollback(byte[] tx) {
        ApiProxy.makeSyncCall("datastore_v3", "Rollback", tx);
    }

    private static DatastorePb.GetResponse.Builder txGet(byte[] tx, DatastorePb.GetRequest.Builder request) {
        RemoteApiServlet.parseFromBytes(request.getTransactionBuilder(), tx);
        DatastorePb.GetResponse.Builder response = DatastorePb.GetResponse.newBuilder();
        byte[] resultBytes = ApiProxy.makeSyncCall("datastore_v3", "Get", request.build().toByteArray());
        RemoteApiServlet.parseFromBytes(response, resultBytes);
        return response;
    }

    static byte[] computeSha1(OnestoreEntity.EntityProto entity) {
        byte[] entityBytes = entity.toByteArray();
        return RemoteApiServlet.computeSha1(entityBytes, entityBytes.length);
    }

    static byte[] computeSha1OmittingLastByteForBackwardsCompatibility(OnestoreEntity.EntityProto entity) {
        byte[] entityBytes = entity.toByteArray();
        return RemoteApiServlet.computeSha1(entityBytes, entityBytes.length - 1);
    }

    private static byte[] computeSha1(byte[] bytes, int length) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getNumber(), "Transaction precondition could not be computed");
        }
        md.update(bytes, 0, length);
        return md.digest();
    }

    private static void parseFromBytes(Message.Builder message, byte[] bytes) {
        boolean parsed = true;
        try {
            message.mergeFrom(bytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (IOException e) {
            parsed = false;
        }
        RemoteApiServlet.checkParse(message.build(), parsed);
    }

    private static void parseFromInputStream(Message.Builder message, InputStream inputStream) {
        boolean parsed = true;
        try {
            message.mergeFrom(inputStream, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        }
        catch (IOException e) {
            parsed = false;
        }
        RemoteApiServlet.checkParse(message.build(), parsed);
    }

    private static void checkParse(Message message, boolean parsed) {
        if (!parsed) {
            throw new ApiProxy.ApiProxyException("Could not parse protobuf");
        }
        List<String> errors = message.findInitializationErrors();
        if (errors != null && !errors.isEmpty()) {
            throw new ApiProxy.ApiProxyException("Could not parse protobuf: " + errors);
        }
    }

    public static class UnknownPythonServerException
    extends RuntimeException {
        public UnknownPythonServerException(String message) {
            super(message);
        }
    }
}

