/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.setup;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.org.apache.http.HttpResponse;
import com.google.appengine.repackaged.org.apache.http.client.HttpClient;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpPost;
import com.google.appengine.repackaged.org.apache.http.client.methods.HttpUriRequest;
import com.google.appengine.repackaged.org.apache.http.conn.ClientConnectionManager;
import com.google.appengine.repackaged.org.apache.http.entity.ByteArrayEntity;
import com.google.appengine.repackaged.org.apache.http.entity.ContentType;
import com.google.appengine.repackaged.org.apache.http.impl.client.DefaultHttpClient;
import com.google.appengine.repackaged.org.apache.http.impl.conn.PoolingClientConnectionManager;
import com.google.appengine.repackaged.org.apache.http.params.BasicHttpParams;
import com.google.appengine.repackaged.org.apache.http.protocol.BasicHttpContext;
import com.google.appengine.setup.ApiProxyEnvironment;
import com.google.appengine.setup.LazyApiProxyEnvironment;
import com.google.appengine.setup.RequestThreadFactory;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class ApiProxyDelegate
implements ApiProxy.Delegate<LazyApiProxyEnvironment> {
    private static final Logger logger = Logger.getLogger(ApiProxyDelegate.class.getName());
    public static final String RPC_DEADLINE_HEADER = "X-Google-RPC-Service-Deadline";
    public static final String RPC_STUB_ID_HEADER = "X-Google-RPC-Service-Endpoint";
    public static final String RPC_METHOD_HEADER = "X-Google-RPC-Service-Method";
    public static final String REQUEST_ENDPOINT = "/rpc_http";
    public static final String REQUEST_STUB_ID = "app-engine-apis";
    public static final String REQUEST_STUB_METHOD = "/VMRemoteAPI.CallRemoteAPI";
    protected static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    static final int ADDITIONAL_HTTP_TIMEOUT_BUFFER_MS = 1000;
    protected int defaultTimeoutMs = 300000;
    protected final ExecutorService executor = Executors.newCachedThreadPool();
    protected final HttpClient httpclient;
    final IdleConnectionMonitorThread monitorThread;

    private static ClientConnectionManager createConnectionManager() {
        PoolingClientConnectionManager connectionManager = new PoolingClientConnectionManager();
        connectionManager.setMaxTotal(100);
        connectionManager.setDefaultMaxPerRoute(100);
        return connectionManager;
    }

    public ApiProxyDelegate() {
        this(new DefaultHttpClient(ApiProxyDelegate.createConnectionManager()));
    }

    ApiProxyDelegate(HttpClient httpclient) {
        this.httpclient = httpclient;
        this.monitorThread = new IdleConnectionMonitorThread(httpclient.getConnectionManager());
        this.monitorThread.start();
    }

    @Override
    public byte[] makeSyncCall(LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData) throws ApiProxy.ApiProxyException {
        return this.makeSyncCallWithTimeout(environment, packageName, methodName, requestData, this.defaultTimeoutMs);
    }

    private byte[] makeSyncCallWithTimeout(LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) throws ApiProxy.ApiProxyException {
        return this.makeApiCall(environment, packageName, methodName, requestData, timeoutMs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] makeApiCall(LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs, boolean wasAsync) {
        environment.apiCallStarted(60000L, wasAsync);
        try {
            byte[] byArray = this.runSyncCall(environment, packageName, methodName, requestData, timeoutMs);
            return byArray;
        }
        finally {
            environment.apiCallCompleted();
        }
    }

    protected byte[] runSyncCall(LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) {
        HttpPost request = ApiProxyDelegate.createRequest(environment, packageName, methodName, requestData, timeoutMs);
        try {
            byte[] byArray;
            BasicHttpContext context = new BasicHttpContext();
            HttpResponse response = this.httpclient.execute((HttpUriRequest)request, context);
            if (response.getStatusLine().getStatusCode() != 200) {
                Scanner errorStreamScanner = new Scanner(new BufferedInputStream(response.getEntity().getContent()));
                try {
                    logger.info("Error body: " + errorStreamScanner.useDelimiter("\\Z").next());
                    throw new ApiProxy.RPCFailedException(packageName, methodName);
                }
                catch (Throwable throwable) {
                    try {
                        errorStreamScanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            BufferedInputStream bis = new BufferedInputStream(response.getEntity().getContent());
            try {
                RemoteApiPb.Response remoteResponse = RemoteApiPb.Response.getDefaultInstance();
                try {
                    remoteResponse.getParserForType().parseFrom(bis);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.info("HTTP ApiProxy unable to parse response for " + packageName + "." + methodName);
                    throw new ApiProxy.RPCFailedException(packageName, methodName);
                }
                if (remoteResponse.hasRpcError() || remoteResponse.hasApplicationError()) {
                    throw ApiProxyDelegate.convertRemoteError(remoteResponse, packageName, methodName, logger);
                }
                byArray = remoteResponse.getResponse().toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.info("HTTP ApiProxy I/O error for " + packageName + "." + methodName + ": " + e.getMessage());
                    throw new ApiProxy.RPCFailedException(packageName, methodName);
                }
            }
            bis.close();
            return byArray;
        }
        finally {
            request.releaseConnection();
        }
    }

    static HttpPost createRequest(LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) {
        RemoteApiPb.Request.Builder remoteRequest = RemoteApiPb.Request.newBuilder();
        remoteRequest.setServiceName(packageName);
        remoteRequest.setMethod(methodName);
        remoteRequest.setRequest(ByteString.copyFrom(requestData));
        HttpPost request = new HttpPost("http://" + environment.getServer() + REQUEST_ENDPOINT);
        request.setHeader(RPC_STUB_ID_HEADER, REQUEST_STUB_ID);
        request.setHeader(RPC_METHOD_HEADER, REQUEST_STUB_METHOD);
        BasicHttpParams params = new BasicHttpParams();
        params.setLongParameter("http.conn-manager.timeout", timeoutMs + 1000);
        params.setIntParameter("http.connection.timeout", timeoutMs + 1000);
        params.setIntParameter("http.socket.timeout", timeoutMs + 1000);
        params.setBooleanParameter("http.tcp.nodelay", Boolean.TRUE);
        params.setBooleanParameter("http.connection.stalecheck", Boolean.FALSE);
        request.setParams(params);
        Double deadline = (Double)environment.getAttributes().get(API_DEADLINE_KEY);
        if (deadline == null) {
            request.setHeader(RPC_DEADLINE_HEADER, Double.toString(TimeUnit.SECONDS.convert(timeoutMs, TimeUnit.MILLISECONDS)));
        } else {
            request.setHeader(RPC_DEADLINE_HEADER, Double.toString(deadline));
        }
        Object dapperHeader = environment.getAttributes().get(ApiProxyEnvironment.AttributeMapping.DAPPER_ID.attributeKey);
        if (dapperHeader instanceof String) {
            request.setHeader(ApiProxyEnvironment.AttributeMapping.DAPPER_ID.headerKey, (String)dapperHeader);
        }
        ByteArrayEntity postPayload = new ByteArrayEntity(remoteRequest.getRequest().toByteArray(), ContentType.APPLICATION_OCTET_STREAM);
        postPayload.setChunked(false);
        request.setEntity(postPayload);
        return request;
    }

    private static ApiProxy.ApiProxyException convertRemoteError(RemoteApiPb.Response remoteResponse, String packageName, String methodName, Logger logger) {
        if (remoteResponse.hasRpcError()) {
            return ApiProxyDelegate.convertApiResponseRpcErrorToException(remoteResponse.getRpcError(), packageName, methodName, logger);
        }
        RemoteApiPb.ApplicationError error = remoteResponse.getApplicationError();
        return new ApiProxy.ApplicationException(error.getCode(), error.getDetail());
    }

    private static ApiProxy.ApiProxyException convertApiResponseRpcErrorToException(RemoteApiPb.RpcError rpcError, String packageName, String methodName, Logger logger) {
        int rpcCode = rpcError.getCode();
        String errorDetail = rpcError.getDetail();
        if (rpcCode > RemoteApiPb.RpcError.ErrorCode.values().length) {
            logger.severe("Received unrecognized error code from server: " + rpcError.getCode() + " details: " + errorDetail);
            return new ApiProxy.UnknownException(packageName, methodName);
        }
        RemoteApiPb.RpcError.ErrorCode errorCode = RemoteApiPb.RpcError.ErrorCode.values()[rpcError.getCode()];
        logger.warning("RPC failed : " + errorCode + " : " + errorDetail);
        switch (errorCode) {
            case CALL_NOT_FOUND: {
                return new ApiProxy.CallNotFoundException(packageName, methodName);
            }
            case PARSE_ERROR: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case SECURITY_VIOLATION: {
                logger.severe("Security violation: invalid request id used!");
                return new ApiProxy.UnknownException(packageName, methodName);
            }
            case CAPABILITY_DISABLED: {
                return new ApiProxy.CapabilityDisabledException(errorDetail, packageName, methodName);
            }
            case OVER_QUOTA: {
                return new ApiProxy.OverQuotaException(packageName, methodName);
            }
            case REQUEST_TOO_LARGE: {
                return new ApiProxy.RequestTooLargeException(packageName, methodName);
            }
            case RESPONSE_TOO_LARGE: {
                return new ApiProxy.ResponseTooLargeException(packageName, methodName);
            }
            case BAD_REQUEST: {
                return new ApiProxy.ArgumentException(packageName, methodName);
            }
            case CANCELLED: {
                return new ApiProxy.CancelledException(packageName, methodName);
            }
            case FEATURE_DISABLED: {
                return new ApiProxy.FeatureNotEnabledException(errorDetail, packageName, methodName);
            }
            case DEADLINE_EXCEEDED: {
                return new ApiProxy.ApiDeadlineExceededException(packageName, methodName);
            }
        }
        return new ApiProxy.UnknownException(packageName, methodName);
    }

    @Override
    public Future<byte[]> makeAsyncCall(LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] request, ApiProxy.ApiConfig apiConfig) {
        int timeoutMs = this.defaultTimeoutMs;
        if (apiConfig != null && apiConfig.getDeadlineInSeconds() != null) {
            timeoutMs = (int)(apiConfig.getDeadlineInSeconds() * 1000.0);
        }
        environment.aSyncApiCallAdded(60000L);
        return this.executor.submit(new MakeSyncCall(this, environment, packageName, methodName, request, timeoutMs));
    }

    @Override
    public void log(LazyApiProxyEnvironment environment, ApiProxy.LogRecord record) {
        if (environment != null) {
            environment.addLogRecord(record);
        }
    }

    @Override
    public void flushLogs(LazyApiProxyEnvironment environment) {
        if (environment != null) {
            environment.flushLogs();
        }
    }

    @Override
    public List<Thread> getRequestThreads(LazyApiProxyEnvironment environment) {
        Object threadFactory = environment.getAttributes().get("com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY");
        if (threadFactory != null && threadFactory instanceof RequestThreadFactory) {
            return ((RequestThreadFactory)threadFactory).getRequestThreads();
        }
        logger.warning("Got a call to getRequestThreads() but no VmRequestThreadFactory is available");
        return Lists.newLinkedList();
    }

    class IdleConnectionMonitorThread
    extends Thread {
        private final ClientConnectionManager connectionManager;

        public IdleConnectionMonitorThread(ClientConnectionManager connectionManager) {
            super("IdleApiConnectionMontorThread");
            this.connectionManager = connectionManager;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this.connectionManager.closeExpiredConnections();
                    this.connectionManager.closeIdleConnections(60L, TimeUnit.SECONDS);
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    private class MakeSyncCall
    implements Callable<byte[]> {
        private final ApiProxyDelegate delegate;
        private final LazyApiProxyEnvironment environment;
        private final String packageName;
        private final String methodName;
        private final byte[] requestData;
        private final int timeoutMs;

        public MakeSyncCall(ApiProxyDelegate delegate, LazyApiProxyEnvironment environment, String packageName, String methodName, byte[] requestData, int timeoutMs) {
            this.delegate = delegate;
            this.environment = environment;
            this.packageName = packageName;
            this.methodName = methodName;
            this.requestData = requestData;
            this.timeoutMs = timeoutMs;
        }

        @Override
        public byte[] call() throws Exception {
            return this.delegate.makeApiCall(this.environment, this.packageName, this.methodName, this.requestData, this.timeoutMs, true);
        }
    }
}

