/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.api;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ApiProxy {
    static final int MAX_SAVED_LOG_RECORDS = 1000;
    private static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    private static final ThreadLocal<Environment> environmentThreadLocal = new ThreadLocal();
    private static EnvironmentFactory environmentFactory = null;
    private static Delegate<?> delegate;
    private static final List<LogRecord> outOfBandLogs;

    private ApiProxy() {
    }

    private static Delegate<Environment> delegate() {
        return delegate;
    }

    public static byte[] makeSyncCall(String packageName, String methodName, byte[] request) {
        return ApiProxy.makeSyncCall(packageName, methodName, request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] makeSyncCall(String packageName, String methodName, byte[] request, ApiConfig apiConfig) {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null || env == null) {
            throw CallNotFoundException.foreignThread(packageName, methodName);
        }
        if (apiConfig == null || apiConfig.getDeadlineInSeconds() == null) {
            return ApiProxy.delegate().makeSyncCall(env, packageName, methodName, request);
        }
        Object oldValue = env.getAttributes().put(API_DEADLINE_KEY, apiConfig.getDeadlineInSeconds());
        try {
            byte[] byArray = ApiProxy.delegate().makeSyncCall(env, packageName, methodName, request);
            return byArray;
        }
        finally {
            if (oldValue == null) {
                env.getAttributes().remove(API_DEADLINE_KEY);
            } else {
                env.getAttributes().put(API_DEADLINE_KEY, oldValue);
            }
        }
    }

    public static Future<byte[]> makeAsyncCall(String packageName, String methodName, byte[] request) {
        return ApiProxy.makeAsyncCall(packageName, methodName, request, new ApiConfig());
    }

    public static Future<byte[]> makeAsyncCall(final String packageName, final String methodName, byte[] request, ApiConfig apiConfig) {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null || env == null) {
            return new Future<byte[]>(){

                @Override
                public byte[] get() {
                    throw CallNotFoundException.foreignThread(packageName, methodName);
                }

                @Override
                public byte[] get(long deadline, TimeUnit unit) {
                    throw CallNotFoundException.foreignThread(packageName, methodName);
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean cancel(boolean shouldInterrupt) {
                    return false;
                }
            };
        }
        return ApiProxy.delegate().makeAsyncCall(env, packageName, methodName, request, apiConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(LogRecord record) {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate != null && env != null) {
            ApiProxy.delegate().log(env, record);
            return;
        }
        List<LogRecord> list = outOfBandLogs;
        synchronized (list) {
            outOfBandLogs.add(record);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void possiblyFlushOutOfBandLogs() {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate != null && env != null) {
            ArrayList<LogRecord> logsToWrite;
            List<LogRecord> list = outOfBandLogs;
            synchronized (list) {
                logsToWrite = new ArrayList<LogRecord>(outOfBandLogs);
                outOfBandLogs.clear();
            }
            for (LogRecord record : logsToWrite) {
                ApiProxy.delegate().log(env, record);
            }
        }
    }

    public static void flushLogs() {
        if (delegate != null) {
            ApiProxy.delegate().flushLogs(ApiProxy.getCurrentEnvironment());
        }
    }

    public static Environment getCurrentEnvironment() {
        Environment threadLocalEnvironment = environmentThreadLocal.get();
        if (threadLocalEnvironment != null) {
            return threadLocalEnvironment;
        }
        EnvironmentFactory envFactory = ApiProxy.getEnvironmentFactory();
        if (envFactory != null) {
            Environment environment = envFactory.newEnvironment();
            environmentThreadLocal.set(environment);
            return environment;
        }
        return null;
    }

    public static void setDelegate(@Nullable Delegate<?> aDelegate) {
        delegate = aDelegate;
        ApiProxy.possiblyFlushOutOfBandLogs();
    }

    public static Delegate getDelegate() {
        return delegate;
    }

    public static void setEnvironmentForCurrentThread(Environment environment) {
        environmentThreadLocal.set(environment);
        ApiProxy.possiblyFlushOutOfBandLogs();
    }

    public static void clearEnvironmentForCurrentThread() {
        environmentThreadLocal.set(null);
    }

    public static synchronized EnvironmentFactory getEnvironmentFactory() {
        return environmentFactory;
    }

    public static synchronized void setEnvironmentFactory(EnvironmentFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory cannot be null.");
        }
        if (environmentFactory != null) {
            throw new IllegalStateException("EnvironmentFactory has already been set.");
        }
        environmentFactory = factory;
    }

    static synchronized void clearEnvironmentFactory() {
        environmentFactory = null;
    }

    public static List<Thread> getRequestThreads() {
        Environment env = ApiProxy.getCurrentEnvironment();
        if (delegate == null) {
            return Collections.emptyList();
        }
        return ApiProxy.delegate().getRequestThreads(env);
    }

    static {
        outOfBandLogs = new DeferredLogRecords();
    }

    public static interface Delegate<E extends Environment> {
        public byte[] makeSyncCall(E var1, String var2, String var3, byte[] var4);

        public Future<byte[]> makeAsyncCall(E var1, String var2, String var3, byte[] var4, ApiConfig var5);

        public void log(E var1, LogRecord var2);

        public void flushLogs(E var1);

        public List<Thread> getRequestThreads(E var1);
    }

    public static final class ApiConfig {
        private Double deadlineInSeconds;

        public Double getDeadlineInSeconds() {
            return this.deadlineInSeconds;
        }

        public void setDeadlineInSeconds(Double deadlineInSeconds) {
            this.deadlineInSeconds = deadlineInSeconds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ApiConfig apiConfig = (ApiConfig)o;
            return !(this.deadlineInSeconds != null ? !this.deadlineInSeconds.equals(apiConfig.deadlineInSeconds) : apiConfig.deadlineInSeconds != null);
        }

        public int hashCode() {
            return this.deadlineInSeconds != null ? this.deadlineInSeconds.hashCode() : 0;
        }
    }

    public static interface Environment {
        public String getAppId();

        public String getModuleId();

        public String getVersionId();

        public String getEmail();

        public boolean isLoggedIn();

        public boolean isAdmin();

        public String getAuthDomain();

        @Deprecated
        public String getRequestNamespace();

        public Map<String, Object> getAttributes();

        public long getRemainingMillis();
    }

    public static class CallNotFoundException
    extends ApiProxyException {
        private static final long serialVersionUID = 7509604548069974905L;

        public CallNotFoundException(String packageName, String methodName) {
            super("The API package '%s' or call '%s()' was not found.", packageName, methodName);
        }

        private CallNotFoundException(String messageFormat, String packageName, String methodName) {
            super(messageFormat, packageName, methodName);
        }

        static CallNotFoundException foreignThread(String packageName, String methodName) {
            return new CallNotFoundException("Can't make API call %s.%s in a thread that is neither the original request thread nor a thread created by ThreadManager", packageName, methodName);
        }

        private CallNotFoundException(String message) {
            super(message);
        }

        @Override
        public CallNotFoundException cloneWithoutStackTrace() {
            return new CallNotFoundException(this.getMessage());
        }
    }

    public static final class LogRecord {
        private final Level level;
        private final long timestamp;
        private final String message;
        private final @Nullable Throwable sourceLocation;
        private final @Nullable StackTraceElement stackFrame;

        public LogRecord(Level level, long timestamp, String message) {
            this(level, timestamp, message, null, null);
        }

        @Deprecated
        public LogRecord(Level level, long timestamp, String message, Throwable sourceLocation) {
            this(level, timestamp, message, sourceLocation, null);
        }

        public LogRecord(Level level, long timestamp, String message, StackTraceElement stackFrame) {
            this(level, timestamp, message, null, LogRecord.checkNotNull("stackFrame", stackFrame));
        }

        private LogRecord(Level level, long timestamp, String message, @Nullable Throwable sourceLocation, @Nullable StackTraceElement stackFrame) {
            this.level = level;
            this.timestamp = timestamp;
            this.message = message;
            this.stackFrame = stackFrame;
            if (sourceLocation == null && stackFrame != null && (stackFrame.getFileName() == null || stackFrame.getLineNumber() <= 0)) {
                sourceLocation = new Throwable();
            }
            this.sourceLocation = sourceLocation;
        }

        private static <T> T checkNotNull(String what, T x) {
            if (x == null) {
                throw new NullPointerException(what);
            }
            return x;
        }

        public LogRecord(LogRecord other, String message) {
            this(other.level, other.timestamp, message);
        }

        public Level getLevel() {
            return this.level;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getMessage() {
            return this.message;
        }

        public @Nullable Throwable getSourceLocation() {
            return this.sourceLocation;
        }

        public @Nullable StackTraceElement getStackFrame() {
            return this.stackFrame;
        }

        public static enum Level {
            debug,
            info,
            warn,
            error,
            fatal;

        }
    }

    public static interface EnvironmentFactory {
        public Environment newEnvironment();
    }

    private static class DeferredLogRecords
    extends AbstractList<LogRecord> {
        private final List<LogRecord> earliest = new ArrayList<LogRecord>();
        private final List<LogRecord> latest = new ArrayList<LogRecord>();
        private int dropped = 0;

        private DeferredLogRecords() {
        }

        @Override
        public boolean add(LogRecord logRecord) {
            int earliestMax = 500;
            int latestMax = 1000 - earliestMax;
            if (this.earliest.size() < earliestMax) {
                this.earliest.add(logRecord);
                return true;
            }
            while (this.latest.size() >= latestMax) {
                this.latest.remove(0);
                ++this.dropped;
            }
            this.latest.add(logRecord);
            return true;
        }

        @Override
        public LogRecord get(int index) {
            if (index < this.earliest.size()) {
                return this.earliest.get(index);
            }
            if (this.dropped == 0) {
                return this.latest.get(index - this.earliest.size());
            }
            if (index == this.earliest.size()) {
                String message = "[" + this.dropped + " dropped records were logged between requests]";
                return new LogRecord(LogRecord.Level.warn, this.latest.get(0).timestamp, message);
            }
            return this.latest.get(index - this.earliest.size() - 1);
        }

        @Override
        public int size() {
            int droppedRecord = this.dropped == 0 ? 0 : 1;
            return this.earliest.size() + droppedRecord + this.latest.size();
        }

        @Override
        public void clear() {
            this.earliest.clear();
            this.latest.clear();
            this.dropped = 0;
        }
    }

    public static class UnknownException
    extends ApiProxyException {
        private static final long serialVersionUID = -5956196448628918508L;

        private Object writeReplace() {
            if (!this.getClass().equals(UnknownException.class)) {
                return this;
            }
            UnknownException replacement = new UnknownException(this.getMessage());
            replacement.setStackTrace(this.getStackTrace());
            return replacement;
        }

        public UnknownException(String packageName, String methodName, Throwable nestedException) {
            super("An error occurred for the API request %s.%s().", packageName, methodName, nestedException);
        }

        public UnknownException(String packageName, String methodName) {
            super("An error occurred for the API request %s.%s().", packageName, methodName);
        }

        public UnknownException(String message) {
            super(message);
        }

        @Override
        public UnknownException cloneWithoutStackTrace() {
            return new UnknownException(this.getMessage());
        }
    }

    public static class ResponseTooLargeException
    extends ApiProxyException {
        private static final long serialVersionUID = 2897764535255354449L;

        public ResponseTooLargeException(String packageName, String methodName) {
            super("The response from API call %s.%s() was too large.", packageName, methodName);
        }

        private ResponseTooLargeException(String message) {
            super(message);
        }

        @Override
        public ResponseTooLargeException cloneWithoutStackTrace() {
            return new ResponseTooLargeException(this.getMessage());
        }
    }

    public static class RequestTooLargeException
    extends ApiProxyException {
        private static final long serialVersionUID = -8120940444733330027L;

        public RequestTooLargeException(String packageName, String methodName) {
            super("The request to API call %s.%s() was too large.", packageName, methodName);
        }

        private RequestTooLargeException(String message) {
            super(message);
        }

        @Override
        public RequestTooLargeException cloneWithoutStackTrace() {
            return new RequestTooLargeException(this.getMessage());
        }
    }

    public static class OverQuotaException
    extends ApiProxyException {
        private static final long serialVersionUID = -1041380497236424921L;

        public OverQuotaException(String packageName, String methodName) {
            this(null, packageName, methodName);
        }

        public OverQuotaException(String message, String packageName, String methodName) {
            this(OverQuotaException.formatMessage(message, packageName, methodName));
        }

        private static String formatMessage(String coda, String packageName, String methodName) {
            String basicMessage = String.format("The API call %s.%s() required more quota than is available.", packageName, methodName);
            return coda != null && !coda.isEmpty() ? basicMessage + ' ' + coda : basicMessage;
        }

        private OverQuotaException(String message) {
            super(message);
        }

        public OverQuotaException(String message, Throwable cause) {
            super(message, cause);
        }

        @Override
        public OverQuotaException cloneWithoutStackTrace() {
            return new OverQuotaException(this.getMessage());
        }
    }

    public static class FeatureNotEnabledException
    extends ApiProxyException {
        private static final long serialVersionUID = -8612326236209075001L;

        public FeatureNotEnabledException(String message, String packageName, String methodName) {
            super(message, packageName, methodName);
        }

        public FeatureNotEnabledException(String message) {
            super(message);
        }

        @Override
        public FeatureNotEnabledException cloneWithoutStackTrace() {
            return new FeatureNotEnabledException(this.getMessage());
        }
    }

    public static class CapabilityDisabledException
    extends ApiProxyException {
        private static final long serialVersionUID = -3302799372322803580L;

        public CapabilityDisabledException(String message, String packageName, String methodName) {
            super("The API call %s.%s() is temporarily unavailable: " + message, packageName, methodName);
        }

        private CapabilityDisabledException(String message) {
            super(message);
        }

        @Override
        public CapabilityDisabledException cloneWithoutStackTrace() {
            return new CapabilityDisabledException(this.getMessage());
        }
    }

    public static class CancelledException
    extends ApiProxyException {
        private static final long serialVersionUID = -6001978533238308631L;

        public CancelledException(String packageName, String methodName) {
            super("The API call %s.%s() was explicitly cancelled.", packageName, methodName);
        }

        public CancelledException(String packageName, String methodName, String reason) {
            super(String.format("The API call %s.%s() was cancelled because %s.", packageName, methodName, reason));
        }

        private CancelledException(String message) {
            super(message);
        }

        @Override
        public CancelledException cloneWithoutStackTrace() {
            return new CancelledException(this.getMessage());
        }
    }

    public static class ApiDeadlineExceededException
    extends ApiProxyException {
        private static final long serialVersionUID = -4609858606653988949L;

        public ApiDeadlineExceededException(String packageName, String methodName) {
            super("The API call %s.%s() took too long to respond and was cancelled.", packageName, methodName);
        }

        private ApiDeadlineExceededException(String message) {
            super(message);
        }

        @Override
        public ApiDeadlineExceededException cloneWithoutStackTrace() {
            return new ApiDeadlineExceededException(this.getMessage());
        }
    }

    public static class ArgumentException
    extends ApiProxyException {
        private static final long serialVersionUID = -5659754301141352543L;

        public ArgumentException(String packageName, String methodName) {
            super("An error occurred parsing (locally or remotely) the arguments to %s.%s().", packageName, methodName);
        }

        private ArgumentException(String message) {
            super(message);
        }

        @Override
        public ArgumentException cloneWithoutStackTrace() {
            return new ArgumentException(this.getMessage());
        }
    }

    public static class RPCFailedException
    extends ApiProxyException {
        private static final long serialVersionUID = -2986651420214055269L;

        public RPCFailedException(String packageName, String methodName) {
            super("The remote RPC to the application server failed for the call %s.%s().", packageName, methodName);
        }

        public RPCFailedException(String message, Throwable cause) {
            super(message, cause);
        }

        private RPCFailedException(String message) {
            super(message);
        }

        @Override
        protected RPCFailedException cloneWithoutStackTrace() {
            return new RPCFailedException(this.getMessage());
        }
    }

    public static class ApplicationException
    extends ApiProxyException {
        private static final long serialVersionUID = 6842926107675100571L;
        private final int applicationError;
        private final String errorDetail;

        public ApplicationException(int applicationError) {
            this(applicationError, "");
        }

        public ApplicationException(int applicationError, String errorDetail) {
            super("ApplicationError: " + applicationError + ": " + errorDetail);
            this.applicationError = applicationError;
            this.errorDetail = errorDetail;
        }

        public int getApplicationError() {
            return this.applicationError;
        }

        public String getErrorDetail() {
            return this.errorDetail;
        }

        @Override
        protected ApplicationException cloneWithoutStackTrace() {
            return new ApplicationException(this.applicationError, this.errorDetail);
        }
    }

    public static class ApiProxyException
    extends RuntimeException {
        private static final long serialVersionUID = -8047817766181831916L;

        public ApiProxyException(String message, String packageName, String methodName) {
            this(String.format(message, packageName, methodName));
        }

        private ApiProxyException(String message, String packageName, String methodName, Throwable nestedException) {
            super(String.format(message, packageName, methodName), nestedException);
        }

        public ApiProxyException(String message) {
            super(message);
        }

        public ApiProxyException(String message, Throwable cause) {
            super(message, cause);
        }

        public ApiProxyException copy(StackTraceElement[] stackTrace) {
            ApiProxyException theCopy = this.cloneWithoutStackTrace();
            theCopy.setStackTrace(stackTrace);
            theCopy.initCause(this);
            return theCopy;
        }

        protected ApiProxyException cloneWithoutStackTrace() {
            return new ApiProxyException(this.getMessage());
        }
    }

    public static interface ApiResultFuture<T>
    extends Future<T> {
        public long getCpuTimeInMegaCycles();

        public long getWallclockTimeInMillis();
    }

    public static interface EnvironmentWithTrace
    extends Environment {
        public Optional<String> getTraceId();

        public Optional<String> getSpanId();
    }
}

