/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.io.opencensus.metrics.export;

import com.google.appengine.repackaged.io.opencensus.internal.Utils;
import com.google.appengine.repackaged.io.opencensus.metrics.LabelKey;
import com.google.appengine.repackaged.io.opencensus.metrics.export.AutoValue_MetricDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class MetricDescriptor {
    MetricDescriptor() {
    }

    public static MetricDescriptor create(String name, String description, String unit, Type type, List<LabelKey> labelKeys) {
        Utils.checkListElementNotNull(Utils.checkNotNull(labelKeys, "labelKeys"), "labelKey");
        return new AutoValue_MetricDescriptor(name, description, unit, type, Collections.unmodifiableList(new ArrayList<LabelKey>(labelKeys)));
    }

    public abstract String getName();

    public abstract String getDescription();

    public abstract String getUnit();

    public abstract Type getType();

    public abstract List<LabelKey> getLabelKeys();

    public static enum Type {
        GAUGE_INT64,
        GAUGE_DOUBLE,
        GAUGE_DISTRIBUTION,
        CUMULATIVE_INT64,
        CUMULATIVE_DOUBLE,
        CUMULATIVE_DISTRIBUTION,
        SUMMARY;

    }
}

