/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.api.core.BetaApi;
import com.google.appengine.repackaged.com.google.datastore.v1.EntityResult;
import com.google.appengine.repackaged.com.google.datastore.v1.Filter;
import com.google.appengine.repackaged.com.google.datastore.v1.Key;
import com.google.appengine.repackaged.com.google.datastore.v1.PartitionId;
import com.google.appengine.repackaged.com.google.datastore.v1.Projection;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyFilter;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyOrder;
import com.google.appengine.repackaged.com.google.datastore.v1.PropertyReference;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.appengine.repackaged.com.google.datastore.v1.ReadOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreHelper;
import com.google.appengine.repackaged.com.google.datastore.v1.client.QuerySplitter;
import com.google.appengine.repackaged.com.google.protobuf.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;

final class QuerySplitterImpl
implements QuerySplitter {
    private static final int KEYS_PER_SPLIT = 32;
    private static final EnumSet<PropertyFilter.Operator> UNSUPPORTED_OPERATORS = EnumSet.of(PropertyFilter.Operator.LESS_THAN, PropertyFilter.Operator.LESS_THAN_OR_EQUAL, PropertyFilter.Operator.GREATER_THAN, PropertyFilter.Operator.GREATER_THAN_OR_EQUAL);
    static final QuerySplitter INSTANCE = new QuerySplitterImpl();

    private QuerySplitterImpl() {
    }

    @Override
    public List<Query> getSplits(Query query, PartitionId partition, int numSplits, Datastore datastore) throws DatastoreException, IllegalArgumentException {
        return this.getSplitsInternal(query, partition, numSplits, datastore, null);
    }

    @Override
    @BetaApi
    public List<Query> getSplits(Query query, PartitionId partition, int numSplits, Datastore datastore, Timestamp readTime) throws DatastoreException, IllegalArgumentException {
        return this.getSplitsInternal(query, partition, numSplits, datastore, readTime);
    }

    private List<Query> getSplitsInternal(Query query, PartitionId partition, int numSplits, Datastore datastore, @Nullable Timestamp readTime) throws DatastoreException, IllegalArgumentException {
        ArrayList<Query> splits = new ArrayList<Query>(numSplits);
        if (numSplits == 1) {
            splits.add(query);
            return splits;
        }
        this.validateQuery(query);
        this.validateSplitSize(numSplits);
        List<Key> scatterKeys = this.getScatterKeys(numSplits, query, partition, datastore, readTime);
        Key lastKey = null;
        for (Key nextKey : this.getSplitKey(scatterKeys, numSplits)) {
            splits.add(this.createSplit(lastKey, nextKey, query));
            lastKey = nextKey;
        }
        splits.add(this.createSplit(lastKey, null, query));
        return splits;
    }

    private void validateSplitSize(int numSplits) throws IllegalArgumentException {
        if (numSplits < 1) {
            throw new IllegalArgumentException("The number of splits must be greater than 0.");
        }
    }

    private void validateFilter(Filter filter) throws IllegalArgumentException {
        switch (filter.getFilterTypeCase()) {
            case COMPOSITE_FILTER: {
                for (Filter subFilter : filter.getCompositeFilter().getFiltersList()) {
                    this.validateFilter(subFilter);
                }
                break;
            }
            case PROPERTY_FILTER: {
                if (!UNSUPPORTED_OPERATORS.contains(filter.getPropertyFilter().getOp())) break;
                throw new IllegalArgumentException("Query cannot have any inequality filters.");
            }
            default: {
                throw new IllegalArgumentException("Unsupported filter type: " + filter.getFilterTypeCase());
            }
        }
    }

    private void validateQuery(Query query) throws IllegalArgumentException {
        if (query.getKindCount() != 1) {
            throw new IllegalArgumentException("Query must have exactly one kind.");
        }
        if (query.getOrderCount() != 0) {
            throw new IllegalArgumentException("Query cannot have any sort orders.");
        }
        if (query.hasFilter()) {
            this.validateFilter(query.getFilter());
        }
    }

    private Query createSplit(Key lastKey, Key nextKey, Query query) {
        if (lastKey == null && nextKey == null) {
            return query;
        }
        ArrayList<Filter> keyFilters = new ArrayList<Filter>();
        if (query.hasFilter()) {
            keyFilters.add(query.getFilter());
        }
        if (lastKey != null) {
            Filter lowerBound = DatastoreHelper.makeFilter("__key__", PropertyFilter.Operator.GREATER_THAN_OR_EQUAL, DatastoreHelper.makeValue(lastKey)).build();
            keyFilters.add(lowerBound);
        }
        if (nextKey != null) {
            Filter upperBound = DatastoreHelper.makeFilter("__key__", PropertyFilter.Operator.LESS_THAN, DatastoreHelper.makeValue(nextKey)).build();
            keyFilters.add(upperBound);
        }
        return Query.newBuilder(query).setFilter(DatastoreHelper.makeAndFilter(keyFilters)).build();
    }

    private List<Key> getScatterKeys(int numSplits, Query query, PartitionId partition, Datastore datastore, @Nullable Timestamp readTime) throws DatastoreException {
        QueryResultBatch batch;
        Query.Builder scatterPointQuery = this.createScatterQuery(query, numSplits);
        ArrayList<Key> keySplits = new ArrayList<Key>();
        do {
            RunQueryRequest.Builder scatterRequest = RunQueryRequest.newBuilder().setPartitionId(partition).setQuery(scatterPointQuery);
            scatterRequest.setProjectId(partition.getProjectId());
            scatterRequest.setDatabaseId(partition.getDatabaseId());
            if (readTime != null) {
                scatterRequest.setReadOptions(ReadOptions.newBuilder().setReadTime(readTime).build());
            }
            batch = datastore.runQuery(scatterRequest.build()).getBatch();
            for (EntityResult result : batch.getEntityResultsList()) {
                keySplits.add(result.getEntity().getKey());
            }
            scatterPointQuery.setStartCursor(batch.getEndCursor());
            scatterPointQuery.getLimitBuilder().setValue(scatterPointQuery.getLimit().getValue() - batch.getEntityResultsCount());
        } while (batch.getMoreResults() == QueryResultBatch.MoreResultsType.NOT_FINISHED);
        Collections.sort(keySplits, DatastoreHelper.getKeyComparator());
        return keySplits;
    }

    private Query.Builder createScatterQuery(Query query, int numSplits) {
        Query.Builder scatterPointQuery = Query.newBuilder();
        scatterPointQuery.addAllKind(query.getKindList());
        scatterPointQuery.addOrder(DatastoreHelper.makeOrder("__scatter__", PropertyOrder.Direction.ASCENDING));
        scatterPointQuery.getLimitBuilder().setValue((numSplits - 1) * 32);
        scatterPointQuery.addProjection(Projection.newBuilder().setProperty(PropertyReference.newBuilder().setName("__key__")));
        return scatterPointQuery;
    }

    private Iterable<Key> getSplitKey(List<Key> keys, int numSplits) {
        if (keys.size() < numSplits - 1) {
            return keys;
        }
        double numKeysPerSplit = Math.max(1.0, (double)keys.size() / (double)(numSplits - 1));
        ArrayList<Key> keysList = new ArrayList<Key>(numSplits - 1);
        for (int i = 1; i < numSplits; ++i) {
            int splitIndex = (int)Math.round((double)i * numKeysPerSplit) - 1;
            keysList.add(keys.get(splitIndex));
        }
        return keysList;
    }
}

