/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Transaction;
import java.util.ArrayList;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TransactionOptions {
    private boolean xg = false;
    private @Nullable Transaction previousTransaction = null;
    private @Nullable Mode mode = null;

    private TransactionOptions() {
    }

    TransactionOptions(TransactionOptions original) {
        this.xg = original.xg;
    }

    public TransactionOptions setXG(boolean enable) {
        this.xg = enable;
        return this;
    }

    public TransactionOptions clearXG() {
        this.xg = false;
        return this;
    }

    public boolean isXG() {
        return this.xg;
    }

    public TransactionOptions setPreviousTransaction(Transaction previousTransaction) {
        this.previousTransaction = previousTransaction;
        return this;
    }

    public @Nullable Transaction previousTransaction() {
        return this.previousTransaction;
    }

    public TransactionOptions setTransactionMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public @Nullable Mode transactionMode() {
        return this.mode;
    }

    @Deprecated
    public TransactionOptions multipleEntityGroups(boolean enable) {
        return this.setXG(enable);
    }

    @Deprecated
    public TransactionOptions clearMultipleEntityGroups() {
        return this.clearXG();
    }

    @Deprecated
    public Boolean allowsMultipleEntityGroups() {
        return this.isXG();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionOptions that = (TransactionOptions)o;
        if (this.xg != that.xg) {
            return false;
        }
        if (this.previousTransaction != null ? !this.previousTransaction.equals(that.previousTransaction) : that.previousTransaction != null) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result = this.xg ? 1 : 0;
        result = 31 * result + (this.previousTransaction != null ? this.previousTransaction.hashCode() : 0);
        result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
        return result;
    }

    public String toString() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("XG=" + this.xg);
        result.add("mode=" + (Object)((Object)this.mode));
        result.add("previousTransaction=" + this.previousTransaction);
        return "TransactionOptions" + result;
    }

    public static enum Mode {
        READ_ONLY,
        READ_WRITE;

    }

    public static final class Builder {
        public static TransactionOptions withXG(boolean enable) {
            return Builder.withDefaults().setXG(enable);
        }

        public static TransactionOptions withTransactionMode(Mode mode) {
            return Builder.withDefaults().setTransactionMode(mode);
        }

        public static TransactionOptions withPreviousTransaction(Transaction previousTransaction) {
            return Builder.withTransactionMode(Mode.READ_WRITE).setPreviousTransaction(previousTransaction);
        }

        @Deprecated
        public static TransactionOptions allowMultipleEntityGroups(boolean enable) {
            return Builder.withDefaults().setXG(enable);
        }

        public static TransactionOptions withDefaults() {
            return new TransactionOptions();
        }

        private Builder() {
        }
    }
}

