/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class FilterMatcher {
    public static final FilterMatcher MATCH_ALL = new FilterMatcher(){

        @Override
        public void addFilter(DatastorePb.Query.Filter filter) {
            throw new UnsupportedOperationException("FilterMatcher.MATCH_ALL is immutable");
        }

        @Override
        public boolean matches(List<Comparable<Object>> values) {
            return true;
        }

        @Override
        boolean matchesRange(Comparable<Object> value) {
            return true;
        }
    };
    Comparable<Object> min = NoValue.INSTANCE;
    boolean minInclusive;
    Comparable<Object> max = NoValue.INSTANCE;
    boolean maxInclusive;
    List<Comparable<Object>> equalValues = new ArrayList<Comparable<Object>>();
    List<Query.GeoRegion> geoRegions = new ArrayList<Query.GeoRegion>();

    FilterMatcher() {
    }

    public boolean considerValueForOrder(Comparable<Object> value) {
        return this.matchesRange(value);
    }

    boolean matchesRange(Comparable<Object> value) {
        int cmp;
        if (this.min != NoValue.INSTANCE && ((cmp = EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value, this.min)) < 0 || cmp == 0 && !this.minInclusive)) {
            return false;
        }
        return this.max == NoValue.INSTANCE || (cmp = EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(value, this.max)) <= 0 && (cmp != 0 || this.maxInclusive);
    }

    public boolean matches(List<Comparable<Object>> values) {
        if (values.size() > 1) {
            Collections.sort(values, EntityProtoComparators.MULTI_TYPE_COMPARATOR);
        }
        for (Comparable<Object> comparable : this.equalValues) {
            if (Collections.binarySearch(values, comparable, EntityProtoComparators.MULTI_TYPE_COMPARATOR) >= 0) continue;
            return false;
        }
        for (Query.GeoRegion geoRegion : this.geoRegions) {
            boolean contained = false;
            for (Comparable<Object> value : values) {
                Comparable<Object> o = value;
                if (!(o instanceof GeoPt) || !geoRegion.contains((GeoPt)o)) continue;
                contained = true;
                break;
            }
            if (contained) continue;
            return false;
        }
        for (Comparable comparable : values) {
            if (!this.matchesRange(comparable)) continue;
            return true;
        }
        return false;
    }

    public void addFilter(DatastorePb.Query.Filter filter) {
        Comparable<Object> value = DataTypeTranslator.getComparablePropertyValue(filter.getProperty(0));
        switch (filter.getOpEnum()) {
            case EQUAL: {
                this.equalValues.add(value);
                break;
            }
            case GREATER_THAN: {
                if (this.min != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.min, value) > 0) break;
                this.min = value;
                this.minInclusive = false;
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                if (this.min != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.min, value) >= 0) break;
                this.min = value;
                this.minInclusive = true;
                break;
            }
            case LESS_THAN: {
                if (this.max != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.max, value) < 0) break;
                this.max = value;
                this.maxInclusive = false;
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                if (this.max != NoValue.INSTANCE && EntityProtoComparators.MULTI_TYPE_COMPARATOR.compare(this.max, value) <= 0) break;
                this.max = value;
                this.maxInclusive = true;
                break;
            }
            case EXISTS: {
                break;
            }
            case CONTAINED_IN_REGION: {
                this.geoRegions.add(FilterMatcher.fromProto(filter.getGeoRegion()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to perform filter using operator " + filter.getOp());
            }
        }
    }

    private static GeoPt fromProto(DatastorePb.RegionPoint point) {
        return new GeoPt((float)point.getLatitude(), (float)point.getLongitude());
    }

    private static Query.GeoRegion fromProto(DatastorePb.GeoRegion pb) {
        if (pb.hasCircle()) {
            return new Query.GeoRegion.Circle(FilterMatcher.fromProto(pb.getCircle().getCenter()), pb.getCircle().getRadiusMeters());
        }
        Preconditions.checkArgument(pb.hasRectangle());
        return new Query.GeoRegion.Rectangle(FilterMatcher.fromProto(pb.getRectangle().getSouthwest()), FilterMatcher.fromProto(pb.getRectangle().getNortheast()));
    }

    public String toString() {
        StringBuilder result = new StringBuilder("FilterMatcher [");
        if (this.min != NoValue.INSTANCE || this.max != NoValue.INSTANCE) {
            if (this.min != NoValue.INSTANCE) {
                result.append(this.min);
                result.append(this.minInclusive ? " <= " : " < ");
            }
            result.append("X");
            if (this.max != NoValue.INSTANCE) {
                result.append(this.maxInclusive ? " <= " : " < ");
                result.append(this.max);
            }
            if (!this.equalValues.isEmpty()) {
                result.append(" && ");
            }
        }
        if (!this.equalValues.isEmpty()) {
            result.append("X CONTAINS ");
            result.append(this.equalValues);
        }
        result.append("]");
        return result.toString();
    }

    static class NoValue
    implements Comparable<Object> {
        static final NoValue INSTANCE = new NoValue();

        private NoValue() {
        }

        @Override
        public int compareTo(Object o) {
            throw new UnsupportedOperationException();
        }
    }
}

