/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.BearerToken;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.util.Clock;
import com.google.appengine.repackaged.com.google.api.client.util.Lists;
import com.google.appengine.repackaged.com.google.api.client.util.Objects;
import com.google.appengine.repackaged.com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Credential
implements HttpExecuteInterceptor,
HttpRequestInitializer,
HttpUnsuccessfulResponseHandler {
    static final Logger LOGGER = Logger.getLogger(Credential.class.getName());
    private final Lock lock = new ReentrantLock();
    private final AccessMethod method;
    private final Clock clock;
    private String accessToken;
    private Long expirationTimeMilliseconds;
    private String refreshToken;
    private final HttpTransport transport;
    private final HttpExecuteInterceptor clientAuthentication;
    private final JsonFactory jsonFactory;
    private final String tokenServerEncodedUrl;
    private final Collection<CredentialRefreshListener> refreshListeners;
    private final HttpRequestInitializer requestInitializer;

    public Credential(AccessMethod method) {
        this(new Builder(method));
    }

    protected Credential(Builder builder) {
        this.method = Preconditions.checkNotNull(builder.method);
        this.transport = builder.transport;
        this.jsonFactory = builder.jsonFactory;
        this.tokenServerEncodedUrl = builder.tokenServerUrl == null ? null : builder.tokenServerUrl.build();
        this.clientAuthentication = builder.clientAuthentication;
        this.requestInitializer = builder.requestInitializer;
        this.refreshListeners = Collections.unmodifiableCollection(builder.refreshListeners);
        this.clock = Preconditions.checkNotNull(builder.clock);
    }

    @Override
    public void intercept(HttpRequest request) throws IOException {
        this.lock.lock();
        try {
            Long expiresIn = this.getExpiresInSeconds();
            if (this.accessToken == null || expiresIn != null && expiresIn <= 60L) {
                this.refreshToken();
                if (this.accessToken == null) {
                    return;
                }
            }
            this.method.intercept(request, this.accessToken);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleResponse(HttpRequest request, HttpResponse response, boolean supportsRetry) {
        boolean refreshToken = false;
        boolean bearer = false;
        List<String> authenticateList = response.getHeaders().getAuthenticateAsList();
        if (authenticateList != null) {
            for (String authenticate : authenticateList) {
                if (!authenticate.startsWith("Bearer ")) continue;
                bearer = true;
                refreshToken = BearerToken.INVALID_TOKEN_ERROR.matcher(authenticate).find();
                break;
            }
        }
        if (!bearer) {
            boolean bl = refreshToken = response.getStatusCode() == 401;
        }
        if (refreshToken) {
            this.lock.lock();
            try {
                boolean bl = !Objects.equal(this.accessToken, this.method.getAccessTokenFromRequest(request)) || this.refreshToken();
                this.lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.lock.unlock();
                    throw throwable;
                }
                catch (IOException exception) {
                    LOGGER.log(Level.SEVERE, "unable to refresh token", exception);
                }
            }
        }
        return false;
    }

    @Override
    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(this);
        request.setUnsuccessfulResponseHandler(this);
    }

    public final String getAccessToken() {
        this.lock.lock();
        try {
            String string = this.accessToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Credential setAccessToken(String accessToken) {
        this.lock.lock();
        try {
            this.accessToken = accessToken;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public final AccessMethod getMethod() {
        return this.method;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final HttpTransport getTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getTokenServerEncodedUrl() {
        return this.tokenServerEncodedUrl;
    }

    public final String getRefreshToken() {
        this.lock.lock();
        try {
            String string = this.refreshToken;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Credential setRefreshToken(String refreshToken) {
        this.lock.lock();
        try {
            if (refreshToken != null) {
                Preconditions.checkArgument(this.jsonFactory != null && this.transport != null && this.clientAuthentication != null && this.tokenServerEncodedUrl != null, "Please use the Builder and call setJsonFactory, setTransport, setClientAuthentication and setTokenServerUrl/setTokenServerEncodedUrl");
            }
            this.refreshToken = refreshToken;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public final Long getExpirationTimeMilliseconds() {
        this.lock.lock();
        try {
            Long l = this.expirationTimeMilliseconds;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Credential setExpirationTimeMilliseconds(Long expirationTimeMilliseconds) {
        this.lock.lock();
        try {
            this.expirationTimeMilliseconds = expirationTimeMilliseconds;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public final Long getExpiresInSeconds() {
        this.lock.lock();
        try {
            if (this.expirationTimeMilliseconds == null) {
                Long l = null;
                return l;
            }
            Long l = (this.expirationTimeMilliseconds - this.clock.currentTimeMillis()) / 1000L;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Credential setExpiresInSeconds(Long expiresIn) {
        return this.setExpirationTimeMilliseconds(expiresIn == null ? null : Long.valueOf(this.clock.currentTimeMillis() + expiresIn * 1000L));
    }

    public final HttpExecuteInterceptor getClientAuthentication() {
        return this.clientAuthentication;
    }

    public final HttpRequestInitializer getRequestInitializer() {
        return this.requestInitializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean refreshToken() throws IOException {
        this.lock.lock();
        try {
            TokenResponse tokenResponse = this.executeRefreshToken();
            if (tokenResponse == null) return false;
            this.setFromTokenResponse(tokenResponse);
            Iterator<CredentialRefreshListener> iterator2 = this.refreshListeners.iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    boolean bl = true;
                    this.lock.unlock();
                    return bl;
                }
                CredentialRefreshListener refreshListener = iterator2.next();
                refreshListener.onTokenResponse(this, tokenResponse);
            }
        }
        catch (TokenResponseException e) {
            boolean statusCode4xx;
            boolean bl = statusCode4xx = 400 <= e.getStatusCode() && e.getStatusCode() < 500;
            if (e.getDetails() != null && statusCode4xx) {
                this.setAccessToken(null);
                this.setExpiresInSeconds(null);
            }
            for (CredentialRefreshListener refreshListener : this.refreshListeners) {
                refreshListener.onTokenErrorResponse(this, e.getDetails());
            }
            if (!statusCode4xx) return false;
            throw e;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public Credential setFromTokenResponse(TokenResponse tokenResponse) {
        this.setAccessToken(tokenResponse.getAccessToken());
        if (tokenResponse.getRefreshToken() != null) {
            this.setRefreshToken(tokenResponse.getRefreshToken());
        }
        this.setExpiresInSeconds(tokenResponse.getExpiresInSeconds());
        return this;
    }

    protected TokenResponse executeRefreshToken() throws IOException {
        if (this.refreshToken == null) {
            return null;
        }
        return new RefreshTokenRequest(this.transport, this.jsonFactory, new GenericUrl(this.tokenServerEncodedUrl), this.refreshToken).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).execute();
    }

    public final Collection<CredentialRefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    public static class Builder {
        final AccessMethod method;
        HttpTransport transport;
        JsonFactory jsonFactory;
        GenericUrl tokenServerUrl;
        Clock clock = Clock.SYSTEM;
        HttpExecuteInterceptor clientAuthentication;
        HttpRequestInitializer requestInitializer;
        Collection<CredentialRefreshListener> refreshListeners = Lists.newArrayList();

        public Builder(AccessMethod method) {
            this.method = Preconditions.checkNotNull(method);
        }

        public Credential build() {
            return new Credential(this);
        }

        public final AccessMethod getMethod() {
            return this.method;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public Builder setTransport(HttpTransport transport) {
            this.transport = transport;
            return this;
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = Preconditions.checkNotNull(clock);
            return this;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = jsonFactory;
            return this;
        }

        public final GenericUrl getTokenServerUrl() {
            return this.tokenServerUrl;
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            this.tokenServerUrl = tokenServerUrl;
            return this;
        }

        public Builder setTokenServerEncodedUrl(String tokenServerEncodedUrl) {
            this.tokenServerUrl = tokenServerEncodedUrl == null ? null : new GenericUrl(tokenServerEncodedUrl);
            return this;
        }

        public final HttpExecuteInterceptor getClientAuthentication() {
            return this.clientAuthentication;
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final HttpRequestInitializer getRequestInitializer() {
            return this.requestInitializer;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            this.requestInitializer = requestInitializer;
            return this;
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            this.refreshListeners.add(Preconditions.checkNotNull(refreshListener));
            return this;
        }

        public final Collection<CredentialRefreshListener> getRefreshListeners() {
            return this.refreshListeners;
        }

        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            this.refreshListeners = Preconditions.checkNotNull(refreshListeners);
            return this;
        }
    }

    public static interface AccessMethod {
        public void intercept(HttpRequest var1, String var2) throws IOException;

        public String getAccessTokenFromRequest(HttpRequest var1);
    }
}

