/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.context;

import com.google.appengine.repackaged.com.google.common.flogger.LoggingScope;
import com.google.appengine.repackaged.com.google.common.flogger.annotations.AllowedContextReader;
import com.google.appengine.repackaged.com.google.common.flogger.annotations.LegacyContextReader;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Platform;
import com.google.appengine.repackaged.com.google.common.flogger.context.NoOpContextDataProvider;
import com.google.appengine.repackaged.com.google.common.flogger.context.ScopeType;
import com.google.appengine.repackaged.com.google.common.flogger.context.ScopedLoggingContext;
import com.google.appengine.repackaged.com.google.common.flogger.context.Tags;
import com.google.appengine.repackaged.com.google.errorprone.annotations.RestrictedApi;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public abstract class ContextDataProvider {
    @RestrictedApi(explanation="ContextDataProvider must never be used outside of logging backend code", link="go/flogger/scoped_logging_context#faq-dont-read-tags", allowedOnPath=".*/third_party/java_src/flogger/.*", allowlistAnnotations={LegacyContextReader.class, AllowedContextReader.class})
    public static ContextDataProvider getInstance() {
        return Platform.getContextDataProvider();
    }

    @RestrictedApi(explanation="No-op data provider should never need to be used outside of core Flogger libraries", link="go/flogger/scoped_logging_context", allowedOnPath=".*/(third_party/java_src/flogger|java(tests)?/com/google/common/flogger)/.*", allowlistAnnotations={AllowedContextReader.class})
    public static ContextDataProvider getNoOpProvider() {
        return NoOpContextDataProvider.getNoOpInstance();
    }

    public abstract ScopedLoggingContext getContextApiSingleton();

    public boolean shouldForceLogging(String loggerName, Level level, boolean isEnabledByLevel) {
        return false;
    }

    public Tags getTags() {
        return Tags.empty();
    }

    public Metadata getMetadata() {
        return Metadata.empty();
    }

    @NullableDecl
    public LoggingScope getScope(ScopeType type) {
        return null;
    }
}

