/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.SearchException;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.FacetChecker;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.search.DocumentPb;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Facet
implements Serializable {
    private static final long serialVersionUID = 3297968709406212335L;
    private final String name;
    private @Nullable String atom;
    private Double number;

    public static Facet withAtom(String name, String value) {
        return new Facet(name, value, null);
    }

    public static Facet withNumber(String name, Double value) {
        return new Facet(name, null, value);
    }

    private Facet(String name, String atom, Double number) {
        this.name = name;
        this.atom = atom;
        this.number = number;
        this.checkValid();
    }

    public String getName() {
        return this.name;
    }

    public String getAtom() {
        return this.atom;
    }

    public Double getNumber() {
        return this.number;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.atom, this.number);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Facet)) {
            return false;
        }
        Facet facet = (Facet)object;
        return Util.equalObjects(this.name, facet.name) && Util.equalObjects(this.atom, facet.atom) && Util.equalObjects(this.number, facet.number);
    }

    private void checkValid() {
        FacetChecker.checkFacetName(this.name);
        if (this.atom != null) {
            if (this.number != null) {
                throw new IllegalArgumentException(String.format("both atom and number are set for facet %s", this.name));
            }
            FacetChecker.checkAtom(this.atom);
        } else if (this.number != null) {
            FacetChecker.checkNumber(this.number);
        } else {
            throw new IllegalArgumentException(String.format("neither atom nor number is set for facet %s", this.name));
        }
    }

    static Facet withProtoMessage(DocumentPb.Facet facet) {
        DocumentPb.FacetValue value = facet.getValue();
        switch (value.getType()) {
            case ATOM: {
                try {
                    return Facet.withAtom(facet.getName(), value.getStringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SearchException(String.format("Failed to create facet %s from protocol message: %s", facet.getName(), e.getMessage()));
                }
            }
            case NUMBER: {
                try {
                    return Facet.withNumber(facet.getName(), Facet.stringToNumber(value.getStringValue()));
                }
                catch (NumberFormatException e) {
                    throw new SearchException("Failed to parse double: " + value.getStringValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SearchException(String.format("Failed to create facet %s from protocol message: %s", facet.getName(), e.getMessage()));
                }
            }
        }
        throw new SearchException(String.format("unknown facet type %s for facet %s", String.valueOf(value.getType()), facet.getName()));
    }

    DocumentPb.Facet copyToProtocolBuffer() {
        DocumentPb.FacetValue.Builder facetValueBuilder = DocumentPb.FacetValue.newBuilder();
        if (this.atom != null) {
            facetValueBuilder.setType(DocumentPb.FacetValue.ContentType.ATOM);
            facetValueBuilder.setStringValue(this.atom);
        } else if (this.number != null) {
            facetValueBuilder.setType(DocumentPb.FacetValue.ContentType.NUMBER);
            facetValueBuilder.setStringValue(Facet.numberToString(this.number));
        }
        DocumentPb.Facet.Builder builder = DocumentPb.Facet.newBuilder().setName(this.name).setValue(facetValueBuilder);
        return builder.build();
    }

    public String toString() {
        return new Util.ToStringHelper("Facet").addField("name", this.name).addField("atom", this.atom).addField("number", this.number).finish();
    }

    static String numberToString(double number) {
        Preconditions.checkArgument(!Double.isNaN(number), "should be a number.");
        return Double.toString(number);
    }

    static Double stringToNumber(String string) {
        return Double.parseDouble(string);
    }
}

