/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.List;

final class QueryTranslator {
    public static DatastorePb.Query convertToPb(Query query, FetchOptions fetchOptions) {
        Key ancestor = query.getAncestor();
        List<Query.SortPredicate> sortPredicates = query.getSortPredicates();
        DatastorePb.Query proto = new DatastorePb.Query();
        if (query.getKind() != null) {
            proto.setKind(query.getKind());
        }
        proto.setApp(query.getAppIdNamespace().getAppId());
        String nameSpace = query.getAppIdNamespace().getNamespace();
        if (nameSpace.length() != 0) {
            proto.setNameSpace(nameSpace);
        }
        if (fetchOptions.getOffset() != null) {
            proto.setOffset(fetchOptions.getOffset());
        }
        if (fetchOptions.getLimit() != null) {
            proto.setLimit(fetchOptions.getLimit());
        }
        if (fetchOptions.getPrefetchSize() != null) {
            proto.setCount(fetchOptions.getPrefetchSize());
        } else if (fetchOptions.getChunkSize() != null) {
            proto.setCount(fetchOptions.getChunkSize());
        }
        if (fetchOptions.getStartCursor() != null && !proto.getMutableCompiledCursor().parseFrom(fetchOptions.getStartCursor().toByteString())) {
            throw new IllegalArgumentException("Invalid cursor");
        }
        if (fetchOptions.getEndCursor() != null && !proto.getMutableEndCompiledCursor().parseFrom(fetchOptions.getEndCursor().toByteString())) {
            throw new IllegalArgumentException("Invalid cursor");
        }
        if (fetchOptions.getCompile() != null) {
            proto.setCompile(fetchOptions.getCompile());
        }
        if (ancestor != null) {
            OnestoreEntity.Reference ref = KeyTranslator.convertToPb(ancestor);
            if (!ref.getApp().equals(proto.getApp())) {
                throw new IllegalArgumentException("Query and ancestor appid/namespace mismatch");
            }
            proto.setAncestor(ref);
        }
        if (query.getDistinct()) {
            if (query.getProjections().isEmpty()) {
                throw new IllegalArgumentException("Projected properties must be set to allow for distinct projections");
            }
            for (Projection projection : query.getProjections()) {
                proto.addGroupByPropertyName(projection.getPropertyName());
            }
        }
        proto.setKeysOnly(query.isKeysOnly());
        Query.Filter filter = query.getFilter();
        if (filter != null) {
            QueryTranslator.copyGeoFilterToPb(filter, proto);
        } else {
            for (Query.FilterPredicate filterPredicate : query.getFilterPredicates()) {
                DatastorePb.Query.Filter filterPb = proto.addFilter();
                filterPb.copyFrom(QueryTranslator.convertFilterPredicateToPb(filterPredicate));
            }
        }
        for (Query.SortPredicate sortPredicate : sortPredicates) {
            DatastorePb.Query.Order order = proto.addOrder();
            order.copyFrom(QueryTranslator.convertSortPredicateToPb(sortPredicate));
        }
        for (Projection projection : query.getProjections()) {
            proto.addPropertyName(projection.getPropertyName());
        }
        return proto;
    }

    static DatastorePb.Query.Order convertSortPredicateToPb(Query.SortPredicate predicate) {
        DatastorePb.Query.Order order = new DatastorePb.Query.Order();
        order.setProperty(predicate.getPropertyName());
        order.setDirection(QueryTranslator.getSortOp(predicate.getDirection()));
        return order;
    }

    private static DatastorePb.Query.Order.Direction getSortOp(Query.SortDirection direction) {
        switch (direction) {
            case ASCENDING: {
                return DatastorePb.Query.Order.Direction.ASCENDING;
            }
            case DESCENDING: {
                return DatastorePb.Query.Order.Direction.DESCENDING;
            }
        }
        throw new UnsupportedOperationException("direction: " + (Object)((Object)direction));
    }

    private static void copyGeoFilterToPb(Query.Filter filter, DatastorePb.Query proto) {
        if (filter instanceof Query.CompositeFilter) {
            Query.CompositeFilter conjunction = (Query.CompositeFilter)filter;
            Preconditions.checkArgument(conjunction.getOperator() == Query.CompositeFilterOperator.AND, "Geo-spatial filters may only be composed with CompositeFilterOperator.AND");
            for (Query.Filter f : conjunction.getSubFilters()) {
                QueryTranslator.copyGeoFilterToPb(f, proto);
            }
        } else if (filter instanceof Query.StContainsFilter) {
            Query.StContainsFilter containmentFilter = (Query.StContainsFilter)filter;
            DatastorePb.Query.Filter f = proto.addFilter();
            f.setOp(DatastorePb.Query.Filter.Operator.CONTAINED_IN_REGION);
            f.setGeoRegion(QueryTranslator.convertGeoRegionToPb(containmentFilter.getRegion()));
            f.addProperty().setName(containmentFilter.getPropertyName()).setMultiple(false).setValue(new OnestoreEntity.PropertyValue());
        } else {
            Preconditions.checkArgument(filter instanceof Query.FilterPredicate);
            Query.FilterPredicate predicate = (Query.FilterPredicate)filter;
            Preconditions.checkArgument(predicate.getOperator() == Query.FilterOperator.EQUAL, "Geo-spatial filters may only be combined with equality comparisons");
            DatastorePb.Query.Filter f = proto.addFilter();
            f.copyFrom(QueryTranslator.convertFilterPredicateToPb(predicate));
        }
    }

    private static DatastorePb.Query.Filter convertFilterPredicateToPb(Query.FilterPredicate predicate) {
        DatastorePb.Query.Filter filterPb = new DatastorePb.Query.Filter();
        filterPb.setOp(QueryTranslator.getFilterOp(predicate.getOperator()));
        if (predicate.getValue() instanceof Iterable) {
            if (predicate.getOperator() != Query.FilterOperator.IN) {
                throw new IllegalArgumentException("Only the IN operator supports multiple values");
            }
            for (Object value : (Iterable)predicate.getValue()) {
                filterPb.addProperty().setName(predicate.getPropertyName()).setValue(DataTypeTranslator.toV3Value(value));
            }
        } else {
            filterPb.addProperty().setName(predicate.getPropertyName()).setValue(DataTypeTranslator.toV3Value(predicate.getValue()));
        }
        return filterPb;
    }

    private static DatastorePb.GeoRegion convertGeoRegionToPb(Query.GeoRegion region) {
        DatastorePb.GeoRegion geoRegion = new DatastorePb.GeoRegion();
        if (region instanceof Query.GeoRegion.Circle) {
            Query.GeoRegion.Circle circle = (Query.GeoRegion.Circle)region;
            DatastorePb.CircleRegion circlePb = new DatastorePb.CircleRegion();
            circlePb.setCenter(QueryTranslator.convertGeoPtToPb(circle.getCenter()));
            circlePb.setRadiusMeters(circle.getRadius());
            geoRegion.setCircle(circlePb);
        } else if (region instanceof Query.GeoRegion.Rectangle) {
            Query.GeoRegion.Rectangle rect = (Query.GeoRegion.Rectangle)region;
            DatastorePb.RectangleRegion rectPb = new DatastorePb.RectangleRegion();
            rectPb.setSouthwest(QueryTranslator.convertGeoPtToPb(rect.getSouthwest()));
            rectPb.setNortheast(QueryTranslator.convertGeoPtToPb(rect.getNortheast()));
            geoRegion.setRectangle(rectPb);
        } else {
            throw new IllegalArgumentException("missing or unknown-type region in StContainsFilter");
        }
        return geoRegion;
    }

    private static DatastorePb.RegionPoint convertGeoPtToPb(GeoPt point) {
        DatastorePb.RegionPoint pointPb = new DatastorePb.RegionPoint();
        pointPb.setLatitude(point.getLatitude());
        pointPb.setLongitude(point.getLongitude());
        return pointPb;
    }

    private static DatastorePb.Query.Filter.Operator getFilterOp(Query.FilterOperator operator) {
        switch (operator) {
            case LESS_THAN: {
                return DatastorePb.Query.Filter.Operator.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return DatastorePb.Query.Filter.Operator.LESS_THAN_OR_EQUAL;
            }
            case GREATER_THAN: {
                return DatastorePb.Query.Filter.Operator.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return DatastorePb.Query.Filter.Operator.GREATER_THAN_OR_EQUAL;
            }
            case EQUAL: {
                return DatastorePb.Query.Filter.Operator.EQUAL;
            }
            case IN: {
                return DatastorePb.Query.Filter.Operator.IN;
            }
        }
        throw new UnsupportedOperationException("operator: " + (Object)((Object)operator));
    }

    private QueryTranslator() {
    }
}

