/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AutoValue_DatastoreServiceGlobalConfig;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.EnvProxy;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.apphosting.api.ApiProxy;
import com.google.auto.value.AutoValue;
import java.lang.reflect.Field;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@AutoValue
abstract class DatastoreServiceGlobalConfig {
    private static final Logger logger = Logger.getLogger(DatastoreServiceGlobalConfig.class.getName());
    static final String ADDITIONAL_APP_IDS_VAR = "DATASTORE_ADDITIONAL_APP_IDS";
    static final String USE_PROJECT_ID_AS_APP_ID_VAR = "DATASTORE_USE_PROJECT_ID_AS_APP_ID";
    static final String APP_ID_VAR = "DATASTORE_APP_ID";
    static final int DEFAULT_MAX_RETRIES = 3;
    static final int DEFAULT_HTTP_CONNECT_TIMEOUT_MILLIS = 20000;
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private static DatastoreServiceGlobalConfig config;

    DatastoreServiceGlobalConfig() {
    }

    static synchronized DatastoreServiceGlobalConfig getConfig() {
        if (config == null) {
            DatastoreServiceGlobalConfig.setConfig(DatastoreServiceGlobalConfig.fromEnv());
        }
        return config;
    }

    static synchronized void setConfig(DatastoreServiceGlobalConfig config) {
        Preconditions.checkState(DatastoreServiceGlobalConfig.config == null, "DatastoreServiceGlobalConfig was already set.");
        if (!config.useApiProxy()) {
            if (SystemProperty.environment.value() == SystemProperty.Environment.Value.Development) {
                logger.warning("Using non-API proxy mode in the development server. This mode will not work on production App Engine Standard.");
            } else if (SystemProperty.environment.value() == SystemProperty.Environment.Value.Production) {
                if (DatastoreServiceGlobalConfig.isRunningOnAppEngineStandard()) {
                    throw new IllegalStateException("Cannot use non-API proxy mode on production App Engine Standard.");
                }
                logger.info("Allowing non-API proxy mode on production App Engine Flex.");
            }
        }
        DatastoreServiceGlobalConfig.config = config;
        DatastoreServiceGlobalConfig.maybeSetUpApiProxyEnvironment();
    }

    private static boolean isRunningOnAppEngineStandard() {
        String gaeEnv = EnvProxy.getenv("GAE_ENV");
        return "standard".equals(gaeEnv) || gaeEnv == null && EnvProxy.getenv("GAE_VM") == null && EnvProxy.getenv("GCLOUD_PROJECT") == null;
    }

    static synchronized void clearConfig() {
        config = null;
    }

    static synchronized void clear() {
        DatastoreServiceGlobalConfig.clearConfig();
        try {
            DatastoreServiceGlobalConfig.maybeClearApiProxyEnvironment();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static void maybeClearApiProxyEnvironment() throws ReflectiveOperationException {
        Field field = ApiProxy.class.getDeclaredField("environmentFactory");
        field.setAccessible(true);
        Object environmentFactory = field.get(null);
        if (!(environmentFactory instanceof StubApiProxyEnvironmentFactory)) {
            return;
        }
        field.set(null, null);
        ApiProxy.clearEnvironmentForCurrentThread();
    }

    private static synchronized void maybeSetUpApiProxyEnvironment() {
        if (DatastoreServiceGlobalConfig.getConfig().useApiProxy() || ApiProxy.getCurrentEnvironment() != null || !DatastoreServiceGlobalConfig.getConfig().installApiProxyEnvironment()) {
            return;
        }
        ApiProxy.setEnvironmentFactory(new StubApiProxyEnvironmentFactory(DatastoreServiceGlobalConfig.getConfig().configuredAppId()));
        ImmutableSet<String> additionalAppIds = DatastoreServiceGlobalConfig.getConfig().additionalAppIds();
        if (additionalAppIds != null) {
            ImmutableMap.Builder<String, String> projectIdToAppId = ImmutableMap.builder();
            for (String appId : additionalAppIds) {
                projectIdToAppId.put(DatastoreApiHelper.toProjectId(appId), appId.toString());
            }
            ApiProxy.Environment env = Objects.requireNonNull(ApiProxy.getCurrentEnvironment());
            env.getAttributes().put("com.google.appengine.datastore.DataTypeTranslator.AdditionalAppIdsMap", projectIdToAppId.buildOrThrow());
        }
    }

    static ApiProxy.Environment getCurrentApiProxyEnvironment() {
        DatastoreServiceGlobalConfig.maybeSetUpApiProxyEnvironment();
        return ApiProxy.getCurrentEnvironment();
    }

    abstract boolean useApiProxy();

    @Nullable
    abstract String hostOverride();

    @Nullable
    abstract ImmutableSet<String> additionalAppIds();

    abstract boolean installApiProxyEnvironment();

    @Nullable
    abstract String appId();

    @Nullable
    abstract String projectId();

    abstract boolean useProjectIdAsAppId();

    @Nullable
    abstract String emulatorHost();

    @Nullable
    abstract String serviceAccount();

    @Nullable
    abstract PrivateKey privateKey();

    @Nullable
    abstract String privateKeyFile();

    abstract boolean useComputeEngineCredential();

    abstract int maxRetries();

    abstract int httpConnectTimeoutMillis();

    abstract boolean asyncStackTraceCaptureEnabled();

    String configuredAppId() {
        if (this.appId() != null) {
            return this.appId().toString();
        }
        Preconditions.checkState(this.useProjectIdAsAppId());
        return this.projectId();
    }

    static Builder builder() {
        return new AutoValue_DatastoreServiceGlobalConfig.Builder().useApiProxy(false).useProjectIdAsAppId(false).installApiProxyEnvironment(true).useComputeEngineCredential(false).maxRetries(3).httpConnectTimeoutMillis(20000).asyncStackTraceCaptureEnabled(true);
    }

    private static DatastoreServiceGlobalConfig fromEnv() {
        Builder builder = DatastoreServiceGlobalConfig.builder();
        boolean useCloudDatastoreApi = Boolean.parseBoolean(EnvProxy.getenv("DATASTORE_USE_CLOUD_DATASTORE")) || EnvProxy.getenv(APP_ID_VAR) != null || EnvProxy.getenv("DATASTORE_PROJECT_ID") != null;
        builder.useApiProxy(!useCloudDatastoreApi);
        if (EnvProxy.getenv(ADDITIONAL_APP_IDS_VAR) != null) {
            HashSet<String> additionalAppIds = new HashSet<String>();
            for (String appId : COMMA_SPLITTER.split(EnvProxy.getenv(ADDITIONAL_APP_IDS_VAR))) {
                if ((appId = appId.trim()).isEmpty()) continue;
                additionalAppIds.add(appId);
            }
            builder.additionalAppIds(additionalAppIds);
        }
        if (EnvProxy.getenv(APP_ID_VAR) != null) {
            builder.appId(EnvProxy.getenv(APP_ID_VAR));
        }
        if (EnvProxy.getenv("DATASTORE_PROJECT_ID") != null) {
            builder.projectId(EnvProxy.getenv("DATASTORE_PROJECT_ID"));
        }
        builder.useProjectIdAsAppId(Boolean.parseBoolean(EnvProxy.getenv(USE_PROJECT_ID_AS_APP_ID_VAR)));
        if (EnvProxy.getenv("DATASTORE_EMULATOR_HOST") != null) {
            builder.emulatorHost(EnvProxy.getenv("DATASTORE_EMULATOR_HOST"));
        }
        if (EnvProxy.getenv("DATASTORE_SERVICE_ACCOUNT") != null) {
            builder.serviceAccount(EnvProxy.getenv("DATASTORE_SERVICE_ACCOUNT"));
        }
        if (EnvProxy.getenv("DATASTORE_PRIVATE_KEY_FILE") != null) {
            builder.privateKeyFile(EnvProxy.getenv("DATASTORE_PRIVATE_KEY_FILE"));
        }
        return builder.build();
    }

    static class StubApiProxyEnvironment
    implements ApiProxy.Environment {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private final String appId;

        public StubApiProxyEnvironment(String appId) {
            this.appId = appId;
        }

        @Override
        public boolean isLoggedIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isAdmin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public String getRequestNamespace() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getRemainingMillis() {
            return 1L;
        }

        @Override
        public String getModuleId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEmail() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAuthDomain() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        @Override
        public String getAppId() {
            return this.appId;
        }
    }

    static class StubApiProxyEnvironmentFactory
    implements ApiProxy.EnvironmentFactory {
        private final String appId;

        public StubApiProxyEnvironmentFactory(String appId) {
            this.appId = appId;
        }

        @Override
        public ApiProxy.Environment newEnvironment() {
            return new StubApiProxyEnvironment(this.appId);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder appId(String var1);

        abstract Builder emulatorHost(String var1);

        abstract Builder hostOverride(String var1);

        abstract Builder additionalAppIds(Set<String> var1);

        abstract Builder installApiProxyEnvironment(boolean var1);

        abstract Builder useApiProxy(boolean var1);

        abstract Builder serviceAccount(String var1);

        abstract Builder privateKey(PrivateKey var1);

        abstract Builder privateKeyFile(String var1);

        abstract Builder useComputeEngineCredential(boolean var1);

        abstract Builder maxRetries(int var1);

        abstract Builder httpConnectTimeoutMillis(int var1);

        abstract Builder projectId(String var1);

        abstract Builder useProjectIdAsAppId(boolean var1);

        abstract Builder asyncStackTraceCaptureEnabled(boolean var1);

        abstract DatastoreServiceGlobalConfig autoBuild();

        DatastoreServiceGlobalConfig build() {
            DatastoreServiceGlobalConfig config = this.autoBuild();
            if (config.useApiProxy()) {
                Preconditions.checkState(config.appId() == null, "Cannot specify app ID when using API proxy.");
                Preconditions.checkState(config.hostOverride() == null, "Cannot specify host override when using API proxy.");
                Preconditions.checkState(config.additionalAppIds() == null, "Cannot specify additional app IDs when using API proxy.");
                Preconditions.checkState(config.serviceAccount() == null, "Cannot specify service account when using API proxy.");
                Preconditions.checkState(config.privateKey() == null, "Cannot specify private key when using API proxy.");
                Preconditions.checkState(config.privateKeyFile() == null, "Cannot specify private key file when using API proxy.");
                Preconditions.checkState(config.projectId() == null, "Cannot specify project ID when using API proxy.");
                Preconditions.checkState(!config.useProjectIdAsAppId(), "Cannot use project ID as app ID when using API proxy.");
                return config;
            }
            Preconditions.checkState(config.appId() == null || config.projectId() == null, "Cannot provide both app ID and project ID.");
            if (config.appId() != null) {
                Preconditions.checkState(!config.useProjectIdAsAppId(), "Cannot use project ID as app ID if app ID was provided.");
            } else if (config.projectId() != null) {
                Preconditions.checkState(config.useProjectIdAsAppId(), "Must use project ID as app ID if project ID is provided.");
            }
            if (config.emulatorHost() != null) {
                Preconditions.checkState(config.hostOverride() == null, "Cannot provide both host override and emulator host.");
            }
            Preconditions.checkState(config.privateKey() == null || config.privateKeyFile() == null, "Must not provide both a private key and a private key file.");
            boolean providedPrivateKey = config.privateKey() != null || config.privateKeyFile() != null;
            Preconditions.checkState(config.serviceAccount() != null == providedPrivateKey, "Service account must be provided if and only if private key or private key file is provided.");
            Preconditions.checkState(config.serviceAccount() == null || !config.useComputeEngineCredential(), "Must not provide a service account and at the same time require the use of Compute Engine credentials.");
            return config;
        }
    }
}

