/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseCallbackContext;
import com.google.appengine.api.datastore.CallbackContext;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.DeleteContext;
import com.google.appengine.api.datastore.PostLoadContext;
import com.google.appengine.api.datastore.PreGetContext;
import com.google.appengine.api.datastore.PreQueryContext;
import com.google.appengine.api.datastore.PutContext;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.common.collect.LinkedHashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

class DatastoreCallbacksImpl
implements DatastoreCallbacks {
    static final String FORMAT_VERSION_PROPERTY = "DatastoreCallbacksFormatVersion";
    private final Map<CallbackType, Multimap<String, Callback>> callbacksByTypeAndKind = Maps.newHashMap();
    private final Multimap<CallbackType, Callback> noKindCallbacksByType = LinkedHashMultimap.create();

    DatastoreCallbacksImpl(InputStream inputStream, boolean ignoreMissingMethods) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream must not be null");
        }
        Properties props = this.loadProperties(inputStream);
        if (!"1".equals(props.get(FORMAT_VERSION_PROPERTY))) {
            throw new IllegalArgumentException("Unsupported version for datastore callbacks config: " + props.get(FORMAT_VERSION_PROPERTY));
        }
        for (CallbackType callbackType : CallbackType.values()) {
            this.callbacksByTypeAndKind.put(callbackType, LinkedHashMultimap.create());
        }
        for (String key : props.stringPropertyNames()) {
            if (key.equals(FORMAT_VERSION_PROPERTY)) continue;
            this.processCallbackWithKey(key, props, ignoreMissingMethods);
        }
    }

    private Properties loadProperties(InputStream inputStream) {
        Properties props = new Properties();
        try {
            props.loadFromXML(inputStream);
        }
        catch (IOException e) {
            throw new InvalidCallbacksConfigException("Unable to read datastore callbacks config file.", e);
        }
        return props;
    }

    private void processCallbackWithKey(String key, Properties props, boolean ignoreMissingMethods) {
        CallbackType callbackType;
        String[] kindCallbackTypePair = key.split("\\.(?!.*\\.)");
        if (kindCallbackTypePair.length != 2) {
            throw new InvalidCallbacksConfigException(String.format("Could not extract kind and callback type from '%s'", key));
        }
        String kind = kindCallbackTypePair[0];
        try {
            callbackType = CallbackType.valueOf(kindCallbackTypePair[1]);
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidCallbacksConfigException(String.format("Received unknown callback type %s", kindCallbackTypePair[1]));
        }
        String value = props.getProperty(key);
        for (String method : Splitter.on(',').trimResults().split(value)) {
            String[] classMethodPair = method.split(":");
            if (classMethodPair.length != 2) {
                throw new InvalidCallbacksConfigException(String.format("Could not extract fully-qualified classname and method from '%s'", method));
            }
            this.addCallback(callbackType, kind, classMethodPair[0], classMethodPair[1], ignoreMissingMethods);
        }
    }

    private void addCallback(CallbackType callbackType, String kind, String className, String methodName, boolean ignoreMissingMethods) {
        Callback callback = this.newCallback(callbackType, className, methodName, callbackType.contextClass, ignoreMissingMethods);
        if (callback == null) {
            return;
        }
        if (kind.isEmpty()) {
            this.noKindCallbacksByType.put(callbackType, callback);
        } else {
            Objects.requireNonNull(this.callbacksByTypeAndKind.get((Object)callbackType)).put(kind, callback);
        }
    }

    @Override
    public void executePrePutCallbacks(PutContext context) {
        this.executeCallbacks(CallbackType.PrePut, context);
    }

    @Override
    public void executePostPutCallbacks(PutContext context) {
        this.executeCallbacks(CallbackType.PostPut, context);
    }

    @Override
    public void executePreDeleteCallbacks(DeleteContext context) {
        this.executeCallbacks(CallbackType.PreDelete, context);
    }

    @Override
    public void executePostDeleteCallbacks(DeleteContext context) {
        this.executeCallbacks(CallbackType.PostDelete, context);
    }

    @Override
    public void executePreGetCallbacks(PreGetContext context) {
        this.executeCallbacks(CallbackType.PreGet, context);
    }

    @Override
    public void executePostLoadCallbacks(PostLoadContext context) {
        this.executeCallbacks(CallbackType.PostLoad, context);
    }

    @Override
    public void executePreQueryCallbacks(PreQueryContext context) {
        this.executeCallbacks(CallbackType.PreQuery, context);
    }

    private <T> void executeCallbacks(CallbackType callbackType, BaseCallbackContext<T> context) {
        context.executeCallbacks(this.callbacksByTypeAndKind.get((Object)callbackType), this.noKindCallbacksByType.get(callbackType));
    }

    private Callback newCallback(CallbackType callbackType, String className, String methodName, Class<? extends CallbackContext<?>> contextClass, boolean ignoreMissingMethods) {
        block5: {
            try {
                Class<?> cls = DatastoreCallbacksImpl.loadClass(className);
                Method m = cls.getDeclaredMethod(methodName, contextClass);
                m.setAccessible(true);
                if (!m.isAnnotationPresent(callbackType.annotationType)) {
                    throw new InvalidCallbacksConfigException(String.format("Unable to initialize datastore callbacks because method %s.%s(%s) is missing annotation %s.", new Object[]{cls.getName(), methodName, contextClass.getName(), callbackType}));
                }
                Object callbackImplementor = DatastoreCallbacksImpl.newInstance(cls);
                return this.allocateCallback(callbackImplementor, m);
            }
            catch (ClassNotFoundException e) {
                if (!ignoreMissingMethods) {
                    throw new InvalidCallbacksConfigException("Unable to initialize datastore callbacks due to missing class.", e);
                }
            }
            catch (NoSuchMethodException e) {
                if (ignoreMissingMethods) break block5;
                throw new InvalidCallbacksConfigException("Unable to initialize datastore callbacks because of reference to missing method.", e);
            }
        }
        return null;
    }

    private static Class<?> loadClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    private static Object newInstance(Class<?> cls) {
        Constructor<?> ctor;
        try {
            ctor = cls.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidCallbacksConfigException(String.format("Unable to initialize datastore callbacks because class %s does not have a no-arg constructor.", cls.getName()), e);
        }
        ctor.setAccessible(true);
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidCallbacksConfigException(String.format("Unable to initialize datastore callbacks due to exception received while constructing an instance of %s", cls.getName()), e);
        }
    }

    private Callback allocateCallback(final Object callbackImplementor, final Method callbackMethod) {
        return new Callback(this){

            @Override
            public void run(CallbackContext<?> context) {
                try {
                    callbackMethod.invoke(callbackImplementor, context);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() != null) {
                        Throwables.throwIfUnchecked(e.getCause());
                    }
                    throw new RuntimeException("Callback method threw a checked exception.", e.getCause());
                }
            }
        };
    }

    static class InvalidCallbacksConfigException
    extends RuntimeException {
        private static final long serialVersionUID = 7167516026957233487L;

        InvalidCallbacksConfigException(String msg, Throwable throwable) {
            super(msg, throwable);
        }

        InvalidCallbacksConfigException(String msg) {
            super(msg);
        }
    }

    static interface Callback {
        public void run(CallbackContext<?> var1);
    }

    static enum CallbackType {
        PrePut(PutContext.class),
        PostPut(PutContext.class),
        PreDelete(DeleteContext.class),
        PostDelete(DeleteContext.class),
        PreGet(PreGetContext.class),
        PostLoad(PostLoadContext.class),
        PreQuery(PreQueryContext.class);

        final Class<? extends CallbackContext<?>> contextClass;
        final Class<? extends Annotation> annotationType;

        private CallbackType(Class<? extends CallbackContext<?>> contextClass) {
            this.contextClass = contextClass;
            try {
                this.annotationType = Class.forName(((Object)((Object)this)).getClass().getPackage().getName() + "." + this.name());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

