/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.gson.internal.bind;

import com.google.appengine.repackaged.com.google.gson.Gson;
import com.google.appengine.repackaged.com.google.gson.JsonSyntaxException;
import com.google.appengine.repackaged.com.google.gson.ToNumberPolicy;
import com.google.appengine.repackaged.com.google.gson.ToNumberStrategy;
import com.google.appengine.repackaged.com.google.gson.TypeAdapter;
import com.google.appengine.repackaged.com.google.gson.TypeAdapterFactory;
import com.google.appengine.repackaged.com.google.gson.reflect.TypeToken;
import com.google.appengine.repackaged.com.google.gson.stream.JsonReader;
import com.google.appengine.repackaged.com.google.gson.stream.JsonToken;
import com.google.appengine.repackaged.com.google.gson.stream.JsonWriter;
import java.io.IOException;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        final NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == Number.class ? adapter : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        String string = String.valueOf((Object)jsonToken);
        String string2 = in.getPath();
        throw new JsonSyntaxException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Expecting number, got: ").append(string).append("; at path ").append(string2).toString());
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

