/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.gson;

import com.google.appengine.repackaged.com.google.gson.JsonParseException;
import com.google.appengine.repackaged.com.google.gson.ToNumberStrategy;
import com.google.appengine.repackaged.com.google.gson.internal.LazilyParsedNumber;
import com.google.appengine.repackaged.com.google.gson.stream.JsonReader;
import com.google.appengine.repackaged.com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader in) throws IOException {
            return in.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader in) throws IOException {
            return new LazilyParsedNumber(in.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader in) throws IOException, JsonParseException {
            String value = in.nextString();
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException longE) {
                try {
                    Double d = Double.valueOf(value);
                    if ((d.isInfinite() || d.isNaN()) && !in.isLenient()) {
                        String string = String.valueOf(d);
                        String string2 = in.getPreviousPath();
                        throw new MalformedJsonException(new StringBuilder(43 + String.valueOf(string).length() + String.valueOf(string2).length()).append("JSON forbids NaN and infinities: ").append(string).append("; at path ").append(string2).toString());
                    }
                    return d;
                }
                catch (NumberFormatException doubleE) {
                    String string = in.getPreviousPath();
                    throw new JsonParseException(new StringBuilder(23 + String.valueOf(value).length() + String.valueOf(string).length()).append("Cannot parse ").append(value).append("; at path ").append(string).toString(), doubleE);
                }
            }
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader in) throws IOException {
            String value = in.nextString();
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                String string = in.getPreviousPath();
                throw new JsonParseException(new StringBuilder(23 + String.valueOf(value).length() + String.valueOf(string).length()).append("Cannot parse ").append(value).append("; at path ").append(string).toString(), e);
            }
        }
    };

}

