/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyle;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyles;
import com.google.appengine.repackaged.com.google.common.html.types.SafeUrls;
import com.google.appengine.repackaged.com.google.common.net.PercentEscaper;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@GwtCompatible
public final class SafeStyleBuilder {
    private static final String INNOCUOUS_PROPERTY_STRING = "zJSafeHtmlzinvalid";
    private final LinkedHashMap<String, String> properties = new LinkedHashMap();
    private static final String UNRESERVED_CHARACTERS = "-._~";
    private static final String RESERVED_CHARACTERS_BACKGROUND_IMAGE = "/:?#[]@!$&*+=";
    private static final String OTHER_CHARACTERS = "%";
    private static final PercentEscaper ESCAPER_BACKGROUND_IMAGE = new PercentEscaper("-._~/:?#[]@!$&*+=%", false);
    private static final Joiner.MapJoiner JOINER = Joiner.on(";").withKeyValueSeparator(":");

    public SafeStyleBuilder backgroundAttachmentAppend(String value, String ... otherValues) {
        this.appendToProperty("background-attachment", SafeStyleBuilder.sanitizeAndJoinEnumValues(value, otherValues));
        return this;
    }

    public SafeStyleBuilder backgroundColorFromConstant(@CompileTimeConstant String constant) {
        this.properties.put("background-color", SafeStyleBuilder.checkConstantValue(constant));
        return this;
    }

    public SafeStyleBuilder backgroundColor(String value) {
        this.properties.put("background-color", SafeStyleBuilder.sanitizeWhitelistedFunctionCallOrRegularValue(value));
        return this;
    }

    public SafeStyleBuilder backgroundImageAppendConstant(@CompileTimeConstant String constant) {
        this.appendToProperty("background-image", SafeStyleBuilder.checkConstantValue(constant));
        return this;
    }

    public SafeStyleBuilder backgroundImageAppendUrl(String url) {
        url = SafeUrls.sanitize(url).getSafeUrlString();
        try {
            url = ESCAPER_BACKGROUND_IMAGE.escape(url);
        }
        catch (IllegalArgumentException e) {
            url = INNOCUOUS_PROPERTY_STRING;
        }
        String string = url;
        String urlValue = new StringBuilder(5 + String.valueOf(string).length()).append("url(").append(string).append(")").toString();
        this.appendToProperty("background-image", urlValue);
        return this;
    }

    public SafeStyleBuilder backgroundLinearGradient(String value, String ... otherValues) {
        String string = SafeStyleBuilder.sanitizeAndJoinLinearGradient(value, otherValues);
        this.properties.put("background", new StringBuilder(17 + String.valueOf(string).length()).append("linear-gradient(").append(string).append(")").toString());
        return this;
    }

    public SafeStyleBuilder backgroundSizeAppend(String value, String ... otherValues) {
        this.appendToProperty("background-size", SafeStyleBuilder.sanitizeAndJoinRegularValues(value, otherValues));
        return this;
    }

    public SafeStyleBuilder border(String value) {
        this.properties.put("border", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderTop(String value) {
        this.properties.put("border-top", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderBottom(String value) {
        this.properties.put("border-bottom", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderRight(String value) {
        this.properties.put("border-right", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderLeft(String value) {
        this.properties.put("border-left", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder bottom(String value) {
        this.properties.put("bottom", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder padding(String value) {
        this.properties.put("padding", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder margin(String value) {
        this.properties.put("margin", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder setFloat(String value) {
        this.properties.put("float", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder display(String value) {
        this.properties.put("display", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder backgroundRepeat(String value) {
        this.properties.put("background-repeat", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderColorFromConstant(@CompileTimeConstant String constant) {
        this.properties.put("border-color", SafeStyleBuilder.checkConstantValue(constant));
        return this;
    }

    public SafeStyleBuilder borderColor(String value) {
        this.properties.put("border-color", SafeStyleBuilder.sanitizeWhitelistedFunctionCallOrRegularValue(value));
        return this;
    }

    public SafeStyleBuilder borderCollapse(String value) {
        this.properties.put("border-collapse", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder color(String value) {
        this.properties.put("color", SafeStyleBuilder.sanitizeWhitelistedFunctionCallOrRegularValue(value));
        return this;
    }

    public SafeStyleBuilder fontSize(String value) {
        this.properties.put("font-size", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder fontWeight(String value) {
        this.properties.put("font-weight", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder fontStyle(String value) {
        this.properties.put("font-style", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder fontFamilyAppend(String value, String ... otherValues) {
        this.sanitizeAndAppendToFontFamily(value);
        for (String otherValue : otherValues) {
            this.sanitizeAndAppendToFontFamily(otherValue);
        }
        return this;
    }

    private void sanitizeAndAppendToFontFamily(String value) {
        if (SafeStyleBuilder.isEnumValue(value)) {
            this.appendToProperty("font-family", value);
        } else if (SafeStyleBuilder.isRegularValue(value)) {
            this.appendToProperty("font-family", new StringBuilder(2 + String.valueOf(value).length()).append("\"").append(value).append("\"").toString());
        } else {
            this.appendToProperty("font-family", INNOCUOUS_PROPERTY_STRING);
        }
    }

    public SafeStyleBuilder height(String value) {
        this.properties.put("height", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder maxHeight(String value) {
        this.properties.put("max-height", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder minHeight(String value) {
        this.properties.put("min-height", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder backgroundPosition(String value) {
        this.properties.put("background-position", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder left(String value) {
        this.properties.put("left", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder lineHeight(String value) {
        this.properties.put("line-height", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder overflow(String value) {
        this.properties.put("overflow", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder overflowX(String value) {
        this.properties.put("overflow-x", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder overflowY(String value) {
        this.properties.put("overflow-y", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder overflowWrap(String value) {
        this.properties.put("overflow-wrap", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder textAlign(String value) {
        this.properties.put("text-align", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder textDecoration(String value) {
        this.properties.put("text-decoration", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder textDecorationSkipInk(String value, boolean setWebkitVendorPrefix) {
        String sanitizedValue = SafeStyleBuilder.sanitizeEnumValue(value);
        this.properties.put("text-decoration-skip-ink", sanitizedValue);
        if (setWebkitVendorPrefix) {
            this.properties.put("-webkit-text-decoration-skip", sanitizedValue);
        }
        return this;
    }

    public SafeStyleBuilder right(String value) {
        this.properties.put("right", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder top(String value) {
        this.properties.put("top", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder verticalAlign(String value) {
        this.properties.put("vertical-align", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder width(String value) {
        this.properties.put("width", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    public SafeStyleBuilder objectFit(String value) {
        this.properties.put("object-fit", SafeStyleBuilder.sanitizeEnumValue(value));
        return this;
    }

    public SafeStyleBuilder objectPosition(String value) {
        this.properties.put("object-position", SafeStyleBuilder.sanitizeRegularValue(value));
        return this;
    }

    @CheckReturnValue
    public SafeStyle build() {
        StringBuilder sb = new StringBuilder();
        if (!this.properties.isEmpty()) {
            JOINER.appendTo(sb, (Map<?, ?>)this.properties).append(";");
        }
        return SafeStyles.create(sb.toString());
    }

    private void appendToProperty(String property, String safeValue) {
        if (this.properties.containsKey(property)) {
            String string = this.properties.get(property);
            this.properties.put(property, new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(safeValue).length()).append(string).append(",").append(safeValue).toString());
        } else {
            this.properties.put(property, safeValue);
        }
    }

    private static String checkConstantValue(@CompileTimeConstant String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '<' || c == '>' || c == '\"' || c == '\'' || c == ';') {
                String string = String.valueOf(value);
                throw new IllegalArgumentException(string.length() != 0 ? "Value contains HTML/CSS meta-characters ([<>\"';]): ".concat(string) : new String("Value contains HTML/CSS meta-characters ([<>\"';]): "));
            }
            if (!value.startsWith("/*", i) && !value.startsWith("*/", i) && !value.startsWith("//", i)) continue;
            String string = String.valueOf(value);
            throw new IllegalArgumentException(string.length() != 0 ? "Value contains CSS comment marker (/*, */ or //): ".concat(string) : new String("Value contains CSS comment marker (/*, */ or //): "));
        }
        return value;
    }

    private static String sanitizeAndJoinEnumValues(String value, String[] otherValues) {
        StringBuilder sb = new StringBuilder(SafeStyleBuilder.sanitizeEnumValue(value));
        for (int i = 0; i < otherValues.length; ++i) {
            sb.append(',').append(SafeStyleBuilder.sanitizeEnumValue(otherValues[i]));
        }
        return sb.toString();
    }

    private static String sanitizeAndJoinLinearGradient(String value, String[] otherValues) {
        StringBuilder sb = new StringBuilder(SafeStyleBuilder.sanitizeRegularValue(value));
        for (String otherVal : otherValues) {
            sb.append(',');
            if (SafeStyleBuilder.isRegularValue(otherVal)) {
                sb.append(otherVal);
                continue;
            }
            if (SafeStyleBuilder.isWhitelistedFunctionCallValue(otherVal)) {
                sb.append(otherVal);
                continue;
            }
            int closeParenIndex = otherVal.lastIndexOf(41);
            if (closeParenIndex > 0 && closeParenIndex < otherVal.length() && SafeStyleBuilder.isWhitelistedFunctionCallValue(otherVal.substring(0, closeParenIndex + 1)) && SafeStyleBuilder.isRegularValue(otherVal.substring(closeParenIndex + 1))) {
                sb.append(otherVal);
                continue;
            }
            sb.append(INNOCUOUS_PROPERTY_STRING);
        }
        return sb.toString();
    }

    private static String sanitizeAndJoinRegularValues(String value, String[] otherValues) {
        StringBuilder sb = new StringBuilder(SafeStyleBuilder.sanitizeRegularValue(value));
        for (int i = 0; i < otherValues.length; ++i) {
            sb.append(',').append(SafeStyleBuilder.sanitizeRegularValue(otherValues[i]));
        }
        return sb.toString();
    }

    private static String sanitizeEnumValue(String value) {
        if (SafeStyleBuilder.isEnumValue(value)) {
            return value;
        }
        return INNOCUOUS_PROPERTY_STRING;
    }

    private static boolean isEnumValue(String value) {
        if (value.isEmpty()) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static String sanitizeWhitelistedFunctionCallOrRegularValue(String value) {
        if (SafeStyleBuilder.isWhitelistedFunctionCallValue(value)) {
            return value;
        }
        return SafeStyleBuilder.sanitizeRegularValue(value);
    }

    private static boolean isWhitelistedFunctionCallValue(String untrimmedValue) {
        String canonName;
        String value = untrimmedValue.trim();
        int openParenIndex = value.indexOf(40);
        if (openParenIndex < 0) {
            return false;
        }
        if (value.charAt(value.length() - 1) != ')') {
            return false;
        }
        switch (canonName = value.substring(0, openParenIndex).toLowerCase(Locale.ROOT)) {
            case "hsl": 
            case "hsla": 
            case "rgb": 
            case "rgba": {
                break;
            }
            default: {
                return false;
            }
        }
        String parenTerms = value.substring(openParenIndex + 1, value.length() - 1);
        return SafeStyleBuilder.isRegularValueOrComma(parenTerms);
    }

    private static String sanitizeRegularValue(String value) {
        if (SafeStyleBuilder.isRegularValue(value)) {
            return value;
        }
        return INNOCUOUS_PROPERTY_STRING;
    }

    private static boolean isRegularValueInternal(String value, boolean allowComma) {
        boolean hasNonWhitespace = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (value.startsWith("/*", i) || value.startsWith("*/", i) || value.startsWith("//", i)) {
                return false;
            }
            if (c == ' ' || c == '\t') continue;
            if (allowComma && c == ',') {
                hasNonWhitespace = true;
                continue;
            }
            if (c == '/' || c == '*' || c == '+' || c == '-' || c == '.' || c == '!' || c == '#' || c == '%' || c == '_') {
                hasNonWhitespace = true;
                continue;
            }
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                hasNonWhitespace = true;
                continue;
            }
            return false;
        }
        return hasNonWhitespace;
    }

    private static boolean isRegularValueOrComma(String value) {
        return SafeStyleBuilder.isRegularValueInternal(value, true);
    }

    private static boolean isRegularValue(String value) {
        return SafeStyleBuilder.isRegularValueInternal(value, false);
    }
}

