/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.util;

import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import com.google.appengine.repackaged.com.google.common.flogger.util.StackGetter;

final class ThrowableStackGetter
implements StackGetter {
    ThrowableStackGetter() {
    }

    @Override
    public StackTraceElement callerOf(Class<?> target, int skipFrames) {
        Checks.checkArgument(skipFrames >= 0, "skipFrames must be >= 0");
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int callerIndex = this.findCallerIndex(stack, target, skipFrames + 1);
        if (callerIndex != -1) {
            return stack[callerIndex];
        }
        return null;
    }

    @Override
    public StackTraceElement[] getStackForCaller(Class<?> target, int maxDepth, int skipFrames) {
        Checks.checkArgument(maxDepth == -1 || maxDepth > 0, "maxDepth must be > 0 or -1");
        Checks.checkArgument(skipFrames >= 0, "skipFrames must be >= 0");
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int callerIndex = this.findCallerIndex(stack, target, skipFrames + 1);
        if (callerIndex == -1) {
            return new StackTraceElement[0];
        }
        int elementsToAdd = stack.length - callerIndex;
        if (maxDepth > 0 && maxDepth < elementsToAdd) {
            elementsToAdd = maxDepth;
        }
        StackTraceElement[] stackTrace = new StackTraceElement[elementsToAdd];
        System.arraycopy(stack, callerIndex, stackTrace, 0, elementsToAdd);
        return stackTrace;
    }

    private int findCallerIndex(StackTraceElement[] stack, Class<?> target, int skipFrames) {
        boolean foundCaller = false;
        String targetClassName = target.getName();
        for (int frameIndex = skipFrames; frameIndex < stack.length; ++frameIndex) {
            if (stack[frameIndex].getClassName().equals(targetClassName)) {
                foundCaller = true;
                continue;
            }
            if (!foundCaller) continue;
            return frameIndex;
        }
        return -1;
    }
}

