/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.SearchServiceException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.appengine.api.search.proto.SearchServicePb;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Functions;
import com.google.appengine.repackaged.com.google.protobuf.AbstractMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.Nullable;

class SearchApiHelper {
    private static final String PACKAGE = "search";
    private final ByteString appIdOverride;

    SearchApiHelper() {
        this.appIdOverride = null;
    }

    SearchApiHelper(String appIdOverride) {
        this.appIdOverride = ByteString.copyFromUtf8(appIdOverride);
    }

    Future<SearchServicePb.DeleteDocumentResponse.Builder> makeAsyncDeleteDocumentCall(SearchServicePb.DeleteDocumentParams.Builder params, @Nullable Double deadline) {
        SearchServicePb.DeleteDocumentRequest.Builder requestBuilder = SearchServicePb.DeleteDocumentRequest.newBuilder().setParams(params);
        if (this.appIdOverride != null) {
            requestBuilder.setAppId(this.appIdOverride);
        }
        SearchServicePb.DeleteDocumentResponse.Builder responseBuilder = SearchServicePb.DeleteDocumentResponse.newBuilder();
        return this.makeAsyncCall("DeleteDocument", requestBuilder.build(), responseBuilder, deadline);
    }

    Future<SearchServicePb.DeleteSchemaResponse.Builder> makeAsyncDeleteSchemaCall(SearchServicePb.DeleteSchemaParams.Builder params, @Nullable Double deadline) {
        SearchServicePb.DeleteSchemaRequest.Builder requestBuilder = SearchServicePb.DeleteSchemaRequest.newBuilder().setParams(params);
        if (this.appIdOverride != null) {
            requestBuilder.setAppId(this.appIdOverride);
        }
        SearchServicePb.DeleteSchemaResponse.Builder responseBuilder = SearchServicePb.DeleteSchemaResponse.newBuilder();
        return this.makeAsyncCall("DeleteSchema", requestBuilder.build(), responseBuilder, deadline);
    }

    Future<SearchServicePb.IndexDocumentResponse.Builder> makeAsyncIndexDocumentCall(SearchServicePb.IndexDocumentParams.Builder params, @Nullable Double deadline) {
        SearchServicePb.IndexDocumentRequest.Builder requestBuilder = SearchServicePb.IndexDocumentRequest.newBuilder().setParams(params);
        if (this.appIdOverride != null) {
            requestBuilder.setAppId(this.appIdOverride);
        }
        SearchServicePb.IndexDocumentRequest request = requestBuilder.build();
        SearchServicePb.IndexDocumentResponse.Builder responseBuilder = SearchServicePb.IndexDocumentResponse.newBuilder();
        return this.makeAsyncCall("IndexDocument", request, responseBuilder, deadline, new IndexExceptionConverter(request));
    }

    Future<SearchServicePb.ListDocumentsResponse.Builder> makeAsyncListDocumentsCall(SearchServicePb.ListDocumentsParams.Builder params, @Nullable Double deadline) {
        SearchServicePb.ListDocumentsRequest.Builder requestBuilder = SearchServicePb.ListDocumentsRequest.newBuilder().setParams(params);
        if (this.appIdOverride != null) {
            requestBuilder.setAppId(this.appIdOverride);
        }
        SearchServicePb.ListDocumentsResponse.Builder responseBuilder = SearchServicePb.ListDocumentsResponse.newBuilder();
        return this.makeAsyncCall("ListDocuments", requestBuilder.build(), responseBuilder, deadline);
    }

    Future<SearchServicePb.ListIndexesResponse.Builder> makeAsyncListIndexesCall(SearchServicePb.ListIndexesParams params, @Nullable Double deadline) {
        SearchServicePb.ListIndexesRequest.Builder requestBuilder = SearchServicePb.ListIndexesRequest.newBuilder().setParams(params);
        if (this.appIdOverride != null) {
            requestBuilder.setAppId(this.appIdOverride);
        }
        SearchServicePb.ListIndexesResponse.Builder responseBuilder = SearchServicePb.ListIndexesResponse.newBuilder();
        return this.makeAsyncCall("ListIndexes", requestBuilder.build(), responseBuilder, deadline);
    }

    Future<SearchServicePb.SearchResponse.Builder> makeAsyncSearchCall(SearchServicePb.SearchParams.Builder params, @Nullable Double deadline) {
        SearchServicePb.SearchRequest.Builder requestBuilder = SearchServicePb.SearchRequest.newBuilder().setParams(params);
        if (this.appIdOverride != null) {
            requestBuilder.setAppId(this.appIdOverride);
        }
        SearchServicePb.SearchResponse.Builder responseBuilder = SearchServicePb.SearchResponse.newBuilder();
        return this.makeAsyncCall("Search", requestBuilder.build(), responseBuilder, deadline);
    }

    private <T extends AbstractMessage.Builder<T>> Future<T> makeAsyncCall(String method, AbstractMessage request, T responseBuilder, @Nullable Double deadline) {
        return this.makeAsyncCall(method, request, responseBuilder, deadline, Functions.identity());
    }

    private <T extends AbstractMessage.Builder<T>> Future<T> makeAsyncCall(String method, AbstractMessage request, final T responseBuilder, @Nullable Double deadline, final Function<Throwable, Throwable> exceptionConverter) {
        Future<byte[]> response;
        if (deadline == null) {
            response = ApiProxy.makeAsyncCall(PACKAGE, method, request.toByteArray());
        } else {
            ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
            apiConfig.setDeadlineInSeconds(deadline);
            response = ApiProxy.makeAsyncCall(PACKAGE, method, request.toByteArray(), apiConfig);
        }
        return new FutureWrapper<byte[], T>(this, response){

            @Override
            protected T wrap(byte[] responseBytes) {
                if (responseBytes != null) {
                    try {
                        responseBuilder.mergeFrom(responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new SearchServiceException(e.toString());
                    }
                }
                return responseBuilder;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return (Throwable)exceptionConverter.apply(cause);
            }
        };
    }

    static class IndexExceptionConverter
    implements Function<Throwable, Throwable> {
        private final SearchServicePb.IndexDocumentRequest request;

        IndexExceptionConverter(SearchServicePb.IndexDocumentRequest request) {
            this.request = request;
        }

        @Override
        public Throwable apply(Throwable input) {
            if (input instanceof ApiProxy.OverQuotaException) {
                SearchServicePb.IndexSpec spec = this.request.getParams().getIndexSpec();
                StringBuilder message = new StringBuilder(input.getMessage()).append("; index = ").append(spec.getName());
                if (!spec.getNamespace().isEmpty()) {
                    message.append(" in namespace ").append(spec.getNamespace());
                }
                return new ApiProxy.OverQuotaException(message.toString(), input);
            }
            return input;
        }
    }
}

