/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PropertyContainer;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Entity
extends PropertyContainer
implements Cloneable {
    static final long serialVersionUID = -836647825120453511L;
    public static final String KEY_RESERVED_PROPERTY = "__key__";
    public static final String SCATTER_RESERVED_PROPERTY = "__scatter__";
    public static final String VERSION_RESERVED_PROPERTY = "__version__";
    private final Key key;
    final Map<String, @Nullable Object> propertyMap;

    public Entity(String kind) {
        this(kind, (Key)null);
    }

    public Entity(String kind, @Nullable Key parent) {
        this(new Key(kind, parent));
    }

    public Entity(String kind, String keyName) {
        this(KeyFactory.createKey(kind, keyName));
    }

    public Entity(String kind, long id) {
        this(KeyFactory.createKey(kind, id));
    }

    public Entity(String kind, String keyName, Key parent) {
        this(KeyFactory.createKey(parent, kind, keyName));
    }

    public Entity(String kind, long id, Key parent) {
        this(KeyFactory.createKey(parent, kind, id));
    }

    public Entity(Key key) {
        this.key = key;
        this.propertyMap = new HashMap<String, Object>();
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof Entity) {
            Entity otherEntity = (Entity)object;
            return this.key.equals(otherEntity.key);
        }
        return false;
    }

    public Key getKey() {
        return this.key;
    }

    public String getKind() {
        return this.key.getKind();
    }

    public @Nullable Key getParent() {
        return this.key.getParent();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<Entity [");
        builder.append(this.key).append("]:\n");
        this.appendPropertiesTo(builder);
        builder.append(">\n");
        return builder.toString();
    }

    public String getAppId() {
        return this.key.getAppId();
    }

    AppIdNamespace getAppIdNamespace() {
        return this.key.getAppIdNamespace();
    }

    public String getNamespace() {
        return this.key.getNamespace();
    }

    @Override
    public Entity clone() {
        Entity entity = new Entity(this.key);
        entity.setPropertiesFrom(this);
        return entity;
    }

    public void setPropertiesFrom(Entity src) {
        super.setPropertiesFrom(src);
    }

    @Override
    Map<String, @Nullable Object> getPropertyMap() {
        return this.propertyMap;
    }

    static final class UnindexedValue
    implements Serializable,
    WrappedValue {
        private static final long serialVersionUID = 293279595114451718L;
        private final @Nullable Object value;

        UnindexedValue(@Nullable Object value) {
            this.value = value;
        }

        @Override
        public @Nullable Object getValue() {
            return this.value;
        }

        @Override
        public boolean isIndexed() {
            return false;
        }

        @Override
        public boolean getForceIndexedEmbeddedEntity() {
            return false;
        }

        public boolean equals(@Nullable Object that) {
            if (that instanceof UnindexedValue) {
                UnindexedValue uv = (UnindexedValue)that;
                return this.value == null ? uv.value == null : this.value.equals(uv.value);
            }
            return false;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public String toString() {
            String string = String.valueOf(this.value);
            return new StringBuilder(12 + String.valueOf(string).length()).append(string).append(" (unindexed)").toString();
        }
    }

    static final class WrappedValueImpl
    implements Serializable,
    WrappedValue {
        private static final long serialVersionUID = 47618472263544528L;
        private final @Nullable Object value;
        private final boolean indexed;
        private final boolean forceIndexedEmbeddedEntity;

        WrappedValueImpl(@Nullable Object value, boolean indexed, boolean forceIndexedEmbeddedEntity) {
            Preconditions.checkArgument(indexed || !forceIndexedEmbeddedEntity);
            this.value = value;
            this.indexed = indexed;
            this.forceIndexedEmbeddedEntity = forceIndexedEmbeddedEntity;
        }

        @Override
        public @Nullable Object getValue() {
            return this.value;
        }

        @Override
        public boolean isIndexed() {
            return this.indexed;
        }

        @Override
        public boolean getForceIndexedEmbeddedEntity() {
            return this.forceIndexedEmbeddedEntity;
        }

        public boolean equals(@Nullable Object that) {
            if (that instanceof WrappedValueImpl) {
                WrappedValueImpl wv = (WrappedValueImpl)that;
                return (this.value == null ? wv.value == null : this.value.equals(wv.value)) && this.indexed == wv.indexed && this.forceIndexedEmbeddedEntity == wv.forceIndexedEmbeddedEntity;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.value, this.indexed, this.forceIndexedEmbeddedEntity);
        }

        public String toString() {
            String string = String.valueOf(this.value);
            boolean bl = this.indexed;
            boolean bl2 = this.forceIndexedEmbeddedEntity;
            return new StringBuilder(21 + String.valueOf(string).length()).append(string).append("(wrapped:").append(bl).append(":").append(bl2).append(")").toString();
        }
    }

    static interface WrappedValue {
        public @Nullable Object getValue();

        public boolean isIndexed();

        public boolean getForceIndexedEmbeddedEntity();
    }
}

