/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.time;

import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.collect.DiscreteDomain;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import org.jspecify.nullness.Nullable;

@GwtIncompatible
public final class LocalTimes {
    private LocalTimes() {
    }

    public static DiscreteDomain<LocalTime> domain() {
        return LocalTimeDomain.INSTANCE;
    }

    private static final class LocalTimeDomain
    extends DiscreteDomain<LocalTime> {
        private static final LocalTimeDomain INSTANCE = new LocalTimeDomain();

        private LocalTimeDomain() {
        }

        @Override
        public LocalTime minValue() {
            return LocalTime.MIN;
        }

        @Override
        public LocalTime maxValue() {
            return LocalTime.MAX;
        }

        @Override
        public @Nullable LocalTime next(LocalTime value) {
            return value.equals(this.maxValue()) ? null : value.plusNanos(1L);
        }

        @Override
        public @Nullable LocalTime previous(LocalTime value) {
            return value.equals(this.minValue()) ? null : value.minusNanos(1L);
        }

        @Override
        public long distance(LocalTime start, LocalTime end) {
            return start.until(end, ChronoUnit.NANOS);
        }

        public String toString() {
            return "LocalTimes.domain()";
        }
    }
}

