/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrl;
import com.google.appengine.repackaged.com.google.common.html.types.TrustedResourceUrls;
import com.google.appengine.repackaged.com.google.common.net.UrlEscapers;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;
import com.google.security.types.common.TrustedString;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@GwtCompatible(emulated=true)
public final class TrustedResourceUrlBuilder {
    private final StringBuilder url = new StringBuilder();
    private static final String BASE_URL_REGEX = "^((https:)?//[0-9A-Za-z.:\\[\\]-]+/|/[^/\\\\]|[^:/\\\\]+/|[^:/\\\\]*[?#]|about:blank#).*";

    public TrustedResourceUrlBuilder(@CompileTimeConstant String string) {
        TrustedResourceUrlBuilder.checkBaseUrl(string);
        this.url.append(string);
    }

    public TrustedResourceUrlBuilder(TrustedResourceUrl trustedResourceUrl) {
        String urlString = trustedResourceUrl.getTrustedResourceUrlString();
        TrustedResourceUrlBuilder.checkBaseUrl(urlString);
        this.url.append(urlString);
    }

    private TrustedResourceUrlBuilder() {
    }

    @Deprecated
    @GoogleInternal
    @GwtIncompatible(value="Flag")
    public TrustedResourceUrlBuilder(Flag<String> flag) {
        this.url.append(flag.get());
    }

    @GoogleInternal
    @GwtIncompatible(value="Flag")
    public static TrustedResourceUrlBuilder fromFlag(Flag<?> flag) {
        TrustedResourceUrlBuilder builder = new TrustedResourceUrlBuilder();
        String value = flag.parsableStringValue();
        TrustedResourceUrlBuilder.checkBaseUrl(value);
        builder.url.append(value);
        return builder;
    }

    public TrustedResourceUrlBuilder append(@CompileTimeConstant String string) {
        this.url.append(string);
        return this;
    }

    @GwtIncompatible(value="TrustedString")
    public static TrustedResourceUrlBuilder fromTrustedString(TrustedString string) {
        TrustedResourceUrlBuilder.checkBaseUrl(string.toString());
        return new TrustedResourceUrlBuilder().append(string);
    }

    @GwtIncompatible(value="TrustedString")
    public TrustedResourceUrlBuilder append(TrustedString string) {
        this.url.append(string.toString());
        return this;
    }

    public TrustedResourceUrlBuilder appendEncoded(String string) {
        TrustedResourceUrlBuilder.checkBaseUrl(this.url.toString());
        this.url.append(UrlEscapers.urlFormParameterEscaper().escape(string));
        return this;
    }

    public TrustedResourceUrlBuilder appendQueryParam(String name, String value) {
        if (this.url.indexOf("#") >= 0) {
            String string = String.valueOf(this.url.toString());
            throw new IllegalStateException(string.length() != 0 ? "Cannot add query parameters after a fragment was added, URL: ".concat(string) : new String("Cannot add query parameters after a fragment was added, URL: "));
        }
        int qmark = this.url.indexOf("?");
        if (qmark < 0) {
            this.url.append('?');
        } else if (qmark + 1 != this.url.length()) {
            this.url.append('&');
        }
        this.url.append(UrlEscapers.urlFormParameterEscaper().escape(name));
        this.url.append('=');
        this.url.append(UrlEscapers.urlFormParameterEscaper().escape(value));
        return this;
    }

    private static void checkBaseUrl(String baseUrl) {
        if (!baseUrl.matches(BASE_URL_REGEX)) {
            String string = String.valueOf(baseUrl);
            throw new IllegalArgumentException(string.length() != 0 ? "TrustedResourceUrls must have a prefix that sets the scheme and origin, e.g. \"//google.com/\" or \"/path\", got:".concat(string) : new String("TrustedResourceUrls must have a prefix that sets the scheme and origin, e.g. \"//google.com/\" or \"/path\", got:"));
        }
    }

    @CheckReturnValue
    public TrustedResourceUrl build() {
        return TrustedResourceUrls.create(this.url.toString());
    }
}

