/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.util;

import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import com.google.appengine.repackaged.com.google.common.flogger.util.StackGetter;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

final class JavaLangAccessStackGetter
implements StackGetter {
    private static final JavaLangAccess access = SharedSecrets.getJavaLangAccess();

    JavaLangAccessStackGetter() {
    }

    @Override
    public StackTraceElement callerOf(Class<?> target, int skipFrames) {
        Checks.checkArgument(skipFrames >= 0, "skipFrames must be >= 0");
        Throwable throwable = new Throwable();
        int index = this.findCallerIndex(throwable, target, skipFrames + 1);
        return index == -1 ? null : access.getStackTraceElement(throwable, index);
    }

    @Override
    public StackTraceElement[] getStackForCaller(Class<?> target, int maxDepth, int skipFrames) {
        Checks.checkArgument(maxDepth == -1 || maxDepth > 0, "maxDepth must be > 0 or -1");
        Checks.checkArgument(skipFrames >= 0, "skipFrames must be >= 0");
        Throwable throwable = new Throwable();
        int callerIndex = this.findCallerIndex(throwable, target, skipFrames + 1);
        if (callerIndex == -1) {
            return new StackTraceElement[0];
        }
        int elementsToAdd = access.getStackTraceDepth(throwable) - callerIndex;
        if (maxDepth > 0 && maxDepth < elementsToAdd) {
            elementsToAdd = maxDepth;
        }
        StackTraceElement[] stackTrace = new StackTraceElement[elementsToAdd];
        for (int i = 0; i < elementsToAdd; ++i) {
            stackTrace[i] = access.getStackTraceElement(throwable, callerIndex + i);
        }
        return stackTrace;
    }

    private int findCallerIndex(Throwable throwable, Class<?> target, int skipFrames) {
        int depth = access.getStackTraceDepth(throwable);
        boolean foundCaller = false;
        String targetClassName = target.getName();
        for (int index = skipFrames; index < depth; ++index) {
            if (access.getStackTraceElement(throwable, index).getClassName().equals(targetClassName)) {
                foundCaller = true;
                continue;
            }
            if (!foundCaller) continue;
            return index;
        }
        return -1;
    }
}

