/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.backend;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.flogger.LogContext;
import com.google.appengine.repackaged.com.google.common.flogger.MetadataKey;
import com.google.appengine.repackaged.com.google.common.flogger.backend.BaseMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.KeyValueFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogData;
import com.google.appengine.repackaged.com.google.common.flogger.backend.LogMessageFormatter;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MessageUtils;
import com.google.appengine.repackaged.com.google.common.flogger.backend.Metadata;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataHandler;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataKeyValueHandlers;
import com.google.appengine.repackaged.com.google.common.flogger.backend.MetadataProcessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public final class SimpleMessageFormatter {
    private static final Set<MetadataKey<?>> DEFAULT_KEYS_TO_IGNORE = Collections.singleton(LogContext.Key.LOG_CAUSE);
    private static final LogMessageFormatter DEFAULT_FORMATTER = SimpleMessageFormatter.newFormatter(DEFAULT_KEYS_TO_IGNORE);

    public static LogMessageFormatter getDefaultFormatter() {
        return DEFAULT_FORMATTER;
    }

    public static LogMessageFormatter getSimpleFormatterIgnoring(MetadataKey<?> ... extraIgnoredKeys) {
        if (extraIgnoredKeys.length == 0) {
            return SimpleMessageFormatter.getDefaultFormatter();
        }
        HashSet ignored = new HashSet(DEFAULT_KEYS_TO_IGNORE);
        Collections.addAll(ignored, extraIgnoredKeys);
        return SimpleMessageFormatter.newFormatter(ignored);
    }

    public static StringBuilder appendContext(MetadataProcessor metadataProcessor, MetadataHandler<MetadataKey.KeyValueHandler> metadataHandler, StringBuilder buffer) {
        KeyValueFormatter kvf = new KeyValueFormatter("[CONTEXT ", " ]", buffer);
        metadataProcessor.process(metadataHandler, kvf);
        kvf.done();
        return buffer;
    }

    public static String getLiteralLogMessage(LogData logData) {
        return MessageUtils.safeToString(logData.getLiteralArgument());
    }

    public static boolean mustBeFormatted(LogData logData, MetadataProcessor metadata, Set<MetadataKey<?>> keysToIgnore) {
        return logData.getTemplateContext() != null || metadata.keyCount() > keysToIgnore.size() || !keysToIgnore.containsAll(metadata.keySet());
    }

    private static LogMessageFormatter newFormatter(final Set<MetadataKey<?>> keysToIgnore) {
        return new LogMessageFormatter(){
            private final MetadataHandler<MetadataKey.KeyValueHandler> handler;
            {
                this.handler = MetadataKeyValueHandlers.getDefaultHandler(keysToIgnore);
            }

            @Override
            public StringBuilder append(LogData logData, MetadataProcessor metadata, StringBuilder buffer) {
                BaseMessageFormatter.appendFormattedMessage(logData, buffer);
                return SimpleMessageFormatter.appendContext(metadata, this.handler, buffer);
            }

            @Override
            public String format(LogData logData, MetadataProcessor metadata) {
                if (SimpleMessageFormatter.mustBeFormatted(logData, metadata, keysToIgnore)) {
                    return this.append(logData, metadata, new StringBuilder()).toString();
                }
                return SimpleMessageFormatter.getLiteralLogMessage(logData);
            }
        };
    }

    @Deprecated
    public static void format(LogData logData, SimpleLogHandler receiver) {
        MetadataProcessor metadata = MetadataProcessor.forScopeAndLogSite(Metadata.empty(), logData.getMetadata());
        receiver.handleFormattedLogMessage(logData.getLevel(), SimpleMessageFormatter.getDefaultFormatter().format(logData, metadata), metadata.getSingleValue(LogContext.Key.LOG_CAUSE));
    }

    @Deprecated
    @GoogleInternal
    public static StringBuilder formatMessageOnly(LogData logData) {
        if (logData.getTemplateContext() == null) {
            return new StringBuilder(SimpleMessageFormatter.getLiteralLogMessage(logData));
        }
        return BaseMessageFormatter.appendFormattedMessage(logData, new StringBuilder());
    }

    private SimpleMessageFormatter() {
    }

    @Deprecated
    public static interface SimpleLogHandler {
        public void handleFormattedLogMessage(Level var1, String var2, @NullableDecl Throwable var3);
    }
}

