/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.Entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PropertyContainer
implements Serializable,
Cloneable {
    static final Pattern RESERVED_NAME = Pattern.compile("^__.*__$");
    static final long serialVersionUID = 1148481935223438329L;

    PropertyContainer() {
    }

    public @Nullable Object getProperty(String propertyName) {
        return PropertyContainer.unwrapValue(this.getPropertyMap().get(propertyName));
    }

    public Map<String, @Nullable Object> getProperties() {
        HashMap<String, @Nullable Object> properties = new HashMap<String, Object>(this.getPropertyMap().size());
        for (Map.Entry<String, Object> entry : this.getPropertyMap().entrySet()) {
            properties.put(entry.getKey(), PropertyContainer.unwrapValue(entry.getValue()));
        }
        return Collections.unmodifiableMap(properties);
    }

    public boolean hasProperty(String propertyName) {
        return this.getPropertyMap().containsKey(propertyName);
    }

    public void removeProperty(String propertyName) {
        this.getPropertyMap().remove(propertyName);
    }

    public void setProperty(String propertyName, @Nullable Object value) {
        DataTypeUtils.checkSupportedValue(propertyName, value);
        this.getPropertyMap().put(propertyName, value);
    }

    public void setIndexedProperty(String propertyName, Object value) {
        DataTypeUtils.checkSupportedValue(propertyName, value, true, false, true);
        this.getPropertyMap().put(propertyName, new Entity.WrappedValueImpl(value, true, true));
    }

    public void setUnindexedProperty(String propertyName, Object value) {
        DataTypeUtils.checkSupportedValue(propertyName, value);
        this.getPropertyMap().put(propertyName, new Entity.UnindexedValue(value));
    }

    public boolean isUnindexedProperty(String propertyName) {
        Object value = this.getPropertyMap().get(propertyName);
        return value instanceof Entity.WrappedValue && !((Entity.WrappedValue)value).isIndexed() || value instanceof EmbeddedEntity || value != null && DataTypeUtils.isUnindexableType(value.getClass());
    }

    public void setPropertiesFrom(PropertyContainer src) {
        for (Map.Entry<String, Object> entry : src.getPropertyMap().entrySet()) {
            String name = entry.getKey();
            ArrayList<Object> entryValue = entry.getValue();
            boolean isUnindexedValue = false;
            boolean isWrappedValue = false;
            boolean indexed = true;
            boolean forceIndexedEntityValue = false;
            Serializable valueToAdd = entryValue;
            if (entryValue instanceof Entity.UnindexedValue) {
                isUnindexedValue = true;
                indexed = false;
                valueToAdd = ((Entity.UnindexedValue)((Object)entryValue)).getValue();
            } else if (entryValue instanceof Entity.WrappedValue) {
                Entity.WrappedValue wrappedValue = (Entity.WrappedValue)((Object)entryValue);
                isWrappedValue = true;
                indexed = wrappedValue.isIndexed();
                forceIndexedEntityValue = wrappedValue.getForceIndexedEmbeddedEntity();
                valueToAdd = wrappedValue.getValue();
            }
            if (valueToAdd instanceof Collection) {
                ArrayList<Object> destColl;
                Collection srcColl = valueToAdd;
                valueToAdd = destColl = new ArrayList<Object>(srcColl.size());
                for (Object element : srcColl) {
                    destColl.add(PropertyContainer.cloneIfMutable(element));
                }
            } else {
                valueToAdd = PropertyContainer.cloneIfMutable(valueToAdd);
            }
            if (isUnindexedValue) {
                valueToAdd = new Entity.UnindexedValue(valueToAdd);
            } else if (isWrappedValue) {
                valueToAdd = new Entity.WrappedValueImpl(valueToAdd, indexed, forceIndexedEntityValue);
            }
            this.getPropertyMap().put(name, valueToAdd);
        }
    }

    abstract Map<String, @Nullable Object> getPropertyMap();

    static @Nullable Object unwrapValue(@Nullable Object obj) {
        if (obj instanceof Entity.WrappedValue) {
            return ((Entity.WrappedValue)obj).getValue();
        }
        return obj;
    }

    protected Object clone() {
        throw new UnsupportedOperationException();
    }

    private static @Nullable Object cloneIfMutable(@Nullable Object obj) {
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof PropertyContainer) {
            return ((PropertyContainer)obj).clone();
        }
        return obj;
    }

    protected void appendPropertiesTo(StringBuilder builder) {
        for (Map.Entry<String, Object> entry : this.getPropertyMap().entrySet()) {
            builder.append('\t').append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
    }
}

