/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.math.LongMath;
import com.google.appengine.repackaged.com.google.common.primitives.Ints;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.appengine.repackaged.com.google.common.util.concurrent.RateLimiter;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;
import org.jspecify.nullness.NullMarked;

@NullMarked
@ElementTypesAreNonnullByDefault
@GoogleInternal
@GwtIncompatible
final class RequestAlignedBucketsRateLimiter
extends RateLimiter {
    private static final int NO_BUCKETS_CREATED_YET = -1;
    private long potentiallyAvailableBucketStartMicros;
    private int permitsAcquiredInBucket = -1;
    private int permitsPerBucket;
    private long periodInMicros;

    RequestAlignedBucketsRateLimiter(RateLimiter.SleepingStopwatch stopwatch, int permitsPerBucket, int periodInMillis) {
        super(stopwatch);
        this.permitsPerBucket = permitsPerBucket;
        this.periodInMicros = TimeUnit.MILLISECONDS.toMicros(periodInMillis);
    }

    @Override
    void doSetRate(double permitsPerSecond, long nowMicros) {
        double periodInSec = (double)this.periodInMicros / 1000000.0;
        this.permitsPerBucket = RequestAlignedBucketsRateLimiter.roundedPermitsPerTime(permitsPerSecond, periodInSec);
    }

    @Override
    double doGetRate() {
        double periodInSec = (double)this.periodInMicros / 1000000.0;
        return (double)this.permitsPerBucket / periodInSec;
    }

    @Override
    long queryEarliestAvailable(long nowMicros) {
        return this.actuallyAvailableBucketStartMicros(nowMicros);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    long reserveEarliestAvailable(int requiredPermits, long nowMicros) {
        try {
            this.updatePotentialBucketToActual(nowMicros);
            long l = this.potentiallyAvailableBucketStartMicros;
            return l;
        }
        finally {
            this.consumePermitsAndBuckets(requiredPermits);
        }
    }

    private void updatePotentialBucketToActual(long nowMicros) {
        long actuallyAvailableBucketStartMicros = this.actuallyAvailableBucketStartMicros(nowMicros);
        if (actuallyAvailableBucketStartMicros != this.potentiallyAvailableBucketStartMicros || this.permitsAcquiredInBucket == -1) {
            this.potentiallyAvailableBucketStartMicros = actuallyAvailableBucketStartMicros;
            this.permitsAcquiredInBucket = 0;
        }
    }

    private long actuallyAvailableBucketStartMicros(long nowMicros) {
        if (nowMicros - this.potentiallyAvailableBucketStartMicros > this.periodInMicros || this.permitsAcquiredInBucket == -1) {
            return nowMicros;
        }
        if (this.permitsAcquiredInBucket + 1 > this.permitsPerBucket) {
            return this.potentiallyAvailableBucketStartMicros + this.periodInMicros;
        }
        return this.potentiallyAvailableBucketStartMicros;
    }

    private void consumePermitsAndBuckets(int requiredPermits) {
        this.permitsAcquiredInBucket += requiredPermits;
        long extraBucketsContaining = LongMath.divide(this.permitsAcquiredInBucket, this.permitsPerBucket, RoundingMode.CEILING) - 1L;
        this.potentiallyAvailableBucketStartMicros += extraBucketsContaining * this.periodInMicros;
        this.permitsAcquiredInBucket -= Ints.checkedCast(extraBucketsContaining * (long)this.permitsPerBucket);
    }
}

