/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flogger.util;

import com.google.appengine.repackaged.com.google.common.flogger.util.Checks;
import com.google.appengine.repackaged.com.google.common.flogger.util.StackGetter;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;

final class JavaLangAccessStackGetter
implements StackGetter {
    private static final JavaLangAccess access = SharedSecrets.getJavaLangAccess();

    JavaLangAccessStackGetter() {
    }

    @Override
    public StackTraceElement callerOf(Class<?> clazz, int n) {
        Checks.checkArgument(n >= 0, "skipFrames must be >= 0");
        Throwable throwable = new Throwable();
        int n2 = this.findCallerIndex(throwable, clazz, n + 1);
        return n2 == -1 ? null : access.getStackTraceElement(throwable, n2);
    }

    @Override
    public StackTraceElement[] getStackForCaller(Class<?> clazz, int n, int n2) {
        Checks.checkArgument(n == -1 || n > 0, "maxDepth must be > 0 or -1");
        Checks.checkArgument(n2 >= 0, "skipFrames must be >= 0");
        Throwable throwable = new Throwable();
        int n3 = this.findCallerIndex(throwable, clazz, n2 + 1);
        if (n3 == -1) {
            return new StackTraceElement[0];
        }
        int n4 = access.getStackTraceDepth(throwable) - n3;
        if (n > 0 && n < n4) {
            n4 = n;
        }
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[n4];
        for (int i = 0; i < n4; ++i) {
            stackTraceElementArray[i] = access.getStackTraceElement(throwable, n3 + i);
        }
        return stackTraceElementArray;
    }

    private int findCallerIndex(Throwable throwable, Class<?> clazz, int n) {
        int n2 = access.getStackTraceDepth(throwable);
        boolean bl = false;
        String string = clazz.getName();
        for (int i = n; i < n2; ++i) {
            if (access.getStackTraceElement(throwable, i).getClassName().equals(string)) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            return i;
        }
        return -1;
    }
}

