/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.nullness.Nullable;

public abstract class BaseEnumFlag<E extends Enum<E>, T>
extends Flag<T> {
    private static final Logger logger = Logger.getLogger(BaseEnumFlag.class.getName());
    private static final String IGNORE_UNKNOWN_PREFIX = "?";
    protected final Class<E> enumType;
    private final boolean autoUpperCase;

    protected BaseEnumFlag(@Nullable T defaultValue, Class<E> enumType, boolean autoUpperCase) {
        super(defaultValue);
        this.enumType = enumType;
        this.autoUpperCase = autoUpperCase;
    }

    protected final E parseEnum(String enumString) throws InvalidFlagValueException {
        try {
            return BaseEnumFlag.parseEnum(this.maybeUpperCase(enumString), this.enumType);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagValueException(e.getMessage());
        }
    }

    protected static final <E extends Enum<E>> E parseEnum(String enumString, Class<E> enumType) {
        try {
            return Enum.valueOf(enumType, enumString);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid enum %s constant. Valid values are: %s", enumString, enumType.getName(), BaseEnumFlag.validValues(enumType)));
        }
    }

    protected final @Nullable E maybeParseEnum(String enumString) throws InvalidFlagValueException {
        try {
            return BaseEnumFlag.maybeParseEnum(this.maybeUpperCase(enumString), this.enumType);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFlagValueException(e.getMessage());
        }
    }

    protected static final <E extends Enum<E>> @Nullable E maybeParseEnum(String enumString, Class<E> enumType) {
        if (enumString.startsWith(IGNORE_UNKNOWN_PREFIX)) {
            String enumSubstring = enumString.substring(IGNORE_UNKNOWN_PREFIX.length());
            try {
                return BaseEnumFlag.parseEnum(enumSubstring, enumType);
            }
            catch (IllegalArgumentException e) {
                logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.flags.BaseEnumFlag", "maybeParseEnum", String.format("Ignoring unknown enum value '%s'", enumSubstring));
                return null;
            }
        }
        return BaseEnumFlag.parseEnum(enumString, enumType);
    }

    protected final String maybeUpperCase(String value) {
        return this.autoUpperCase ? value.toUpperCase(Locale.ENGLISH) : value;
    }

    @Override
    String getDetails() {
        String string = String.valueOf(BaseEnumFlag.validValues(this.enumType));
        return string.length() != 0 ? "valid values: ".concat(string) : new String("valid values: ");
    }

    protected static List<String> enumNames(Enum<?> ... values) {
        return BaseEnumFlag.enumNames(Arrays.asList(values));
    }

    protected static List<String> enumNames(Iterable<? extends Enum<?>> values) {
        ArrayList<String> enumNames = new ArrayList<String>();
        for (Enum<?> enumValue : values) {
            enumNames.add(enumValue.name());
        }
        return Collections.unmodifiableList(enumNames);
    }

    private static String validValues(Class<? extends Enum<?>> enumType) {
        ArrayList<String> validValues = new ArrayList<String>();
        for (Enum<?> validValue : enumType.getEnumConstants()) {
            validValues.add(validValue.name());
        }
        return ((Object)validValues).toString();
    }
}

