/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServiceFactory;
import com.google.appengine.api.images.Composite;
import com.google.appengine.api.images.Image;
import com.google.appengine.api.images.ImagesService;
import com.google.appengine.api.images.ImagesServiceFactory;
import com.google.appengine.api.images.ImagesServiceFailureException;
import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.api.images.InputSettings;
import com.google.appengine.api.images.OutputSettings;
import com.google.appengine.api.images.ServingUrlOptions;
import com.google.appengine.api.images.Transform;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ImagesServiceImpl
implements ImagesService {
    static final String PACKAGE = "images";

    ImagesServiceImpl() {
    }

    @Override
    public Image applyTransform(Transform transform, Image image) {
        return this.applyTransform(transform, image, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, Image image) {
        return this.applyTransformAsync(transform, image, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Image applyTransform(Transform transform, Image image, ImagesService.OutputEncoding encoding) {
        return this.applyTransform(transform, image, new OutputSettings(encoding));
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, Image image, ImagesService.OutputEncoding encoding) {
        return this.applyTransformAsync(transform, image, new OutputSettings(encoding));
    }

    @Override
    public Image applyTransform(Transform transform, Image image, OutputSettings settings) {
        return this.applyTransform(transform, image, new InputSettings(), settings);
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, Image image, OutputSettings settings) {
        return this.applyTransformAsync(transform, image, new InputSettings(), settings);
    }

    @Override
    public Image applyTransform(Transform transform, Image image, InputSettings inputSettings, OutputSettings outputSettings) {
        ImagesServicePb.ImagesTransformRequest.Builder request = this.generateImagesTransformRequest(transform, image, inputSettings, outputSettings);
        ImagesServicePb.ImagesTransformResponse.Builder response = ImagesServicePb.ImagesTransformResponse.newBuilder();
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Transform", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            throw this.convertApplicationException(request, ex);
        }
        image.setImageData(response.getImage().getContent().toByteArray());
        return image;
    }

    @Override
    public Future<Image> applyTransformAsync(Transform transform, final Image image, InputSettings inputSettings, OutputSettings outputSettings) {
        final ImagesServicePb.ImagesTransformRequest.Builder request = this.generateImagesTransformRequest(transform, image, inputSettings, outputSettings);
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(PACKAGE, "Transform", request.build().toByteArray());
        return new FutureWrapper<byte[], Image>(responseBytes){

            @Override
            protected Image wrap(byte @Nullable [] responseBytes) throws IOException {
                ImagesServicePb.ImagesTransformResponse.Builder response = (ImagesServicePb.ImagesTransformResponse.Builder)ImagesServicePb.ImagesTransformResponse.newBuilder().mergeFrom(responseBytes);
                image.setImageData(response.getImage().getContent().toByteArray());
                return image;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return ImagesServiceImpl.this.convertApplicationException(request, (ApiProxy.ApplicationException)cause);
                }
                return cause;
            }
        };
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color) {
        return this.composite(composites, width, height, color, ImagesService.OutputEncoding.PNG);
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color, ImagesService.OutputEncoding encoding) {
        return this.composite(composites, width, height, color, new OutputSettings(encoding));
    }

    @Override
    public Image composite(Collection<Composite> composites, int width, int height, long color, OutputSettings settings) {
        ImagesServicePb.ImagesCompositeRequest.Builder request = ImagesServicePb.ImagesCompositeRequest.newBuilder();
        ImagesServicePb.ImagesCompositeResponse.Builder response = ImagesServicePb.ImagesCompositeResponse.newBuilder();
        if (composites.size() > 16) {
            throw new IllegalArgumentException("A maximum of 16 composites can be applied in a single request");
        }
        if (width > 4000 || width <= 0 || height > 4000 || height <= 0) {
            throw new IllegalArgumentException("Width and height must <= 4000 and > 0");
        }
        if (color > 0xFFFFFFFFL || color < 0L) {
            throw new IllegalArgumentException("Color must be in the range [0, 0xffffffff]");
        }
        if (color >= Integer.MIN_VALUE) {
            color -= 0x100000000L;
        }
        int fixedColor = (int)color;
        ImagesServicePb.ImagesCanvas.Builder canvas = ImagesServicePb.ImagesCanvas.newBuilder();
        canvas.setWidth(width);
        canvas.setHeight(height);
        canvas.setColor(fixedColor);
        canvas.setOutput(this.convertOutputSettings(settings));
        request.setCanvas(canvas);
        HashMap<Image, Integer> imageIdMap = new HashMap<Image, Integer>();
        for (Composite composite : composites) {
            composite.apply(request, imageIdMap);
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Composite", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.forNumber(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        return ImagesServiceFactory.makeImage(response.getImage().getContent().toByteArray());
    }

    @Override
    public int[][] histogram(Image image) {
        int i;
        ImagesServicePb.ImagesHistogramRequest.Builder request = ImagesServicePb.ImagesHistogramRequest.newBuilder();
        ImagesServicePb.ImagesHistogramResponse.Builder response = ImagesServicePb.ImagesHistogramResponse.newBuilder();
        request.setImage(ImagesServiceImpl.convertImageData(image));
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Histogram", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.forNumber(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        ImagesServicePb.ImagesHistogram histogram = response.getHistogram();
        int[][] result = new int[3][];
        for (i = 0; i < 3; ++i) {
            result[i] = new int[256];
        }
        for (i = 0; i < 256; ++i) {
            result[0][i] = histogram.getRed(i);
            result[1][i] = histogram.getGreen(i);
            result[2][i] = histogram.getBlue(i);
        }
        return result;
    }

    @Override
    public String getServingUrl(BlobKey blobKey) {
        return this.getServingUrl(blobKey, false);
    }

    @Override
    public String getServingUrl(BlobKey blobKey, boolean secureUrl) {
        if (blobKey == null) {
            throw new NullPointerException("blobKey cannot be null");
        }
        ServingUrlOptions options = ServingUrlOptions.Builder.withBlobKey(blobKey).secureUrl(secureUrl);
        return this.getServingUrl(options);
    }

    @Override
    public String getServingUrl(BlobKey blobKey, int imageSize, boolean crop) {
        return this.getServingUrl(blobKey, imageSize, crop, false);
    }

    @Override
    public String getServingUrl(BlobKey blobKey, int imageSize, boolean crop, boolean secureUrl) {
        if (blobKey == null) {
            throw new NullPointerException("blobKey cannot be null");
        }
        ServingUrlOptions options = ServingUrlOptions.Builder.withBlobKey(blobKey).imageSize(imageSize).crop(crop).secureUrl(secureUrl);
        return this.getServingUrl(options);
    }

    @Override
    public String getServingUrl(ServingUrlOptions options) {
        ImagesServicePb.ImagesGetUrlBaseRequest.Builder request = ImagesServicePb.ImagesGetUrlBaseRequest.newBuilder();
        ImagesServicePb.ImagesGetUrlBaseResponse.Builder response = ImagesServicePb.ImagesGetUrlBaseResponse.newBuilder();
        if (!options.hasBlobKey() && !options.hasGoogleStorageFileName()) {
            throw new IllegalArgumentException("Must specify either a BlobKey or a Google Storage file name.");
        }
        if (options.hasBlobKey()) {
            request.setBlobKey(options.getBlobKey().getKeyString());
        }
        if (options.hasGoogleStorageFileName()) {
            BlobKey blobKey = BlobstoreServiceFactory.getBlobstoreService().createGsBlobKey(options.getGoogleStorageFileName());
            request.setBlobKey(blobKey.getKeyString());
        }
        if (options.hasSecureUrl()) {
            request.setCreateSecureUrl(options.getSecureUrl());
        }
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "GetUrlBase", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.forNumber(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                String string = String.valueOf(code);
                String string2 = ex.getErrorDetail();
                throw new IllegalArgumentException(new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(": ").append(string2).toString());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
        StringBuilder url = new StringBuilder(response.getUrl());
        if (options.hasImageSize()) {
            url.append("=s");
            url.append(options.getImageSize());
            if (options.hasCrop() && options.getCrop()) {
                url.append("-c");
            }
        }
        return url.toString();
    }

    @Override
    public void deleteServingUrl(BlobKey blobKey) {
        ImagesServicePb.ImagesDeleteUrlBaseRequest.Builder request = ImagesServicePb.ImagesDeleteUrlBaseRequest.newBuilder();
        ImagesServicePb.ImagesDeleteUrlBaseResponse.Builder response = ImagesServicePb.ImagesDeleteUrlBaseResponse.newBuilder();
        if (blobKey == null) {
            throw new NullPointerException();
        }
        request.setBlobKey(blobKey.getKeyString());
        try {
            byte[] responseBytes = ApiProxy.makeSyncCall(PACKAGE, "DeleteUrlBase", request.build().toByteArray());
            response.mergeFrom(responseBytes);
        }
        catch (InvalidProtocolBufferException ex) {
            throw new ImagesServiceFailureException("Invalid protocol buffer:", ex);
        }
        catch (ApiProxy.ApplicationException ex) {
            ImagesServicePb.ImagesServiceError.ErrorCode code = ImagesServicePb.ImagesServiceError.ErrorCode.forNumber(ex.getApplicationError());
            if (code != null && code != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
                throw new IllegalArgumentException(ex.getErrorDetail());
            }
            throw new ImagesServiceFailureException(ex.getErrorDetail());
        }
    }

    static ImagesServicePb.ImageData convertImageData(Image image) {
        ImagesServicePb.ImageData.Builder builder = ImagesServicePb.ImageData.newBuilder();
        BlobKey blobKey = image.getBlobKey();
        if (blobKey != null) {
            builder.setBlobKey(blobKey.getKeyString());
            builder.setContent(ByteString.EMPTY);
        } else {
            byte[] data = Objects.requireNonNull(image.getImageData());
            builder.setContent(ByteString.copyFrom(data));
        }
        return builder.build();
    }

    private ImagesServicePb.ImagesTransformRequest.Builder generateImagesTransformRequest(Transform transform, Image image, InputSettings inputSettings, OutputSettings outputSettings) {
        ImagesServicePb.ImagesTransformRequest.Builder request = ImagesServicePb.ImagesTransformRequest.newBuilder().setImage(ImagesServiceImpl.convertImageData(image)).setOutput(this.convertOutputSettings(outputSettings)).setInput(this.convertInputSettings(inputSettings));
        transform.apply(request);
        if (request.getTransformCount() > 10) {
            throw new IllegalArgumentException("A maximum of 10 basic transforms can be requested in a single transform request");
        }
        return request;
    }

    private ImagesServicePb.OutputSettings convertOutputSettings(OutputSettings settings) {
        ImagesServicePb.OutputSettings.Builder pbSettings = ImagesServicePb.OutputSettings.newBuilder();
        switch (settings.getOutputEncoding()) {
            case PNG: {
                pbSettings.setMimeType(ImagesServicePb.OutputSettings.MIME_TYPE.PNG);
                break;
            }
            case JPEG: {
                pbSettings.setMimeType(ImagesServicePb.OutputSettings.MIME_TYPE.JPEG);
                if (!settings.hasQuality()) break;
                pbSettings.setQuality(settings.getQuality());
                break;
            }
            case WEBP: {
                pbSettings.setMimeType(ImagesServicePb.OutputSettings.MIME_TYPE.WEBP);
                if (!settings.hasQuality()) break;
                pbSettings.setQuality(settings.getQuality());
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid output encoding requested");
            }
        }
        return pbSettings.build();
    }

    private ImagesServicePb.InputSettings convertInputSettings(InputSettings settings) {
        ImagesServicePb.InputSettings.Builder pbSettings = ImagesServicePb.InputSettings.newBuilder();
        switch (settings.getOrientationCorrection()) {
            case UNCHANGED_ORIENTATION: {
                pbSettings.setCorrectExifOrientation(ImagesServicePb.InputSettings.ORIENTATION_CORRECTION_TYPE.UNCHANGED_ORIENTATION);
                break;
            }
            case CORRECT_ORIENTATION: {
                pbSettings.setCorrectExifOrientation(ImagesServicePb.InputSettings.ORIENTATION_CORRECTION_TYPE.CORRECT_ORIENTATION);
            }
        }
        return pbSettings.build();
    }

    private RuntimeException convertApplicationException(ImagesServicePb.ImagesTransformRequest.Builder request, ApiProxy.ApplicationException ex) {
        ImagesServicePb.ImagesServiceError.ErrorCode errorCode = ImagesServicePb.ImagesServiceError.ErrorCode.forNumber(ex.getApplicationError());
        if (errorCode != null && errorCode != ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR) {
            return new IllegalArgumentException(ex.getErrorDetail());
        }
        return new ImagesServiceFailureException(ex.getErrorDetail());
    }
}

