/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KeyRange
implements Iterable<Key>,
Serializable {
    static final long serialVersionUID = 962890261927141064L;
    private final @Nullable Key parent;
    private final String kind;
    private final Key start;
    private final Key end;
    private final AppIdNamespace appIdNamespace;

    public KeyRange(Key parent, String kind, long start, long end) {
        this(parent, kind, start, end, DatastoreApiHelper.getCurrentAppIdNamespace());
    }

    KeyRange(Key parent, String kind, long start, long end, AppIdNamespace appIdNamespace) {
        if (parent != null && !parent.isComplete()) {
            throw new IllegalArgumentException("Invalid parent: not a complete key");
        }
        if (kind == null || kind.isEmpty()) {
            throw new IllegalArgumentException("Invalid kind: cannot be null or empty");
        }
        if (start < 1L) {
            throw new IllegalArgumentException(new StringBuilder(47).append("Illegal start ").append(start).append(": less than 1").toString());
        }
        if (end < start) {
            throw new IllegalArgumentException(new StringBuilder(70).append("Illegal end ").append(end).append(": less than start ").append(start).toString());
        }
        this.parent = parent;
        this.kind = kind;
        this.appIdNamespace = appIdNamespace;
        this.start = KeyFactory.createKey(parent, kind, start, appIdNamespace);
        this.end = KeyFactory.createKey(parent, kind, end, appIdNamespace);
    }

    private KeyRange() {
        this.parent = null;
        this.kind = null;
        this.start = null;
        this.end = null;
        this.appIdNamespace = null;
    }

    AppIdNamespace getAppIdNamespace() {
        return this.appIdNamespace;
    }

    @Nullable Key getParent() {
        return this.parent;
    }

    String getKind() {
        return this.kind;
    }

    public Key getStart() {
        return this.start;
    }

    public Key getEnd() {
        return this.end;
    }

    public long getSize() {
        return this.end.getId() - this.start.getId() + 1L;
    }

    @Override
    public Iterator<Key> iterator() {
        return new IdRangeIterator();
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof KeyRange)) {
            return false;
        }
        KeyRange that = (KeyRange)obj;
        return this.start.equals(that.start) && this.end.equals(that.end);
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    private final class IdRangeIterator
    implements Iterator<Key> {
        private long next;

        private IdRangeIterator() {
            this.next = KeyRange.this.start.getId();
        }

        @Override
        public boolean hasNext() {
            return this.next <= KeyRange.this.end.getId();
        }

        @Override
        public Key next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return KeyFactory.createKey(KeyRange.this.parent, KeyRange.this.kind, this.next++, KeyRange.this.appIdNamespace);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

