/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.gson.internal.bind;

import com.google.appengine.repackaged.com.google.gson.Gson;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializer;
import com.google.appengine.repackaged.com.google.gson.JsonSerializer;
import com.google.appengine.repackaged.com.google.gson.TypeAdapter;
import com.google.appengine.repackaged.com.google.gson.TypeAdapterFactory;
import com.google.appengine.repackaged.com.google.gson.annotations.JsonAdapter;
import com.google.appengine.repackaged.com.google.gson.internal.ConstructorConstructor;
import com.google.appengine.repackaged.com.google.gson.internal.bind.TreeTypeAdapter;
import com.google.appengine.repackaged.com.google.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation = rawType.getAnnotation(JsonAdapter.class);
        if (annotation == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type, JsonAdapter annotation) {
        TypeAdapter<?> typeAdapter;
        Object instance = constructorConstructor.get(TypeToken.get(annotation.value())).construct();
        if (instance instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter<?>)instance;
        } else if (instance instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance).create(gson, type);
        } else if (instance instanceof JsonSerializer || instance instanceof JsonDeserializer) {
            JsonSerializer serializer = instance instanceof JsonSerializer ? (JsonSerializer)instance : null;
            JsonDeserializer deserializer = instance instanceof JsonDeserializer ? (JsonDeserializer)instance : null;
            typeAdapter = new TreeTypeAdapter(serializer, deserializer, gson, type, null);
        } else {
            String string = instance.getClass().getName();
            String string2 = type.toString();
            throw new IllegalArgumentException(new StringBuilder(161 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Invalid attempt to bind an instance of ").append(string).append(" as a @JsonAdapter for ").append(string2).append(". @JsonAdapter value must be a TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer.").toString());
        }
        if (typeAdapter != null && annotation.nullSafe()) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

