/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ElementTypesAreNonnullByDefault;
import com.google.appengine.repackaged.com.google.common.util.concurrent.Internal;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jspecify.nullness.NullMarked;

@NullMarked
@ElementTypesAreNonnullByDefault
@GoogleInternal
@GwtIncompatible
public final class IncrementableCountDownLatch {
    private final Sync sync;

    public IncrementableCountDownLatch(int count) {
        Preconditions.checkArgument(count >= 0, "count (%s) must be >= 0", count);
        this.sync = new Sync(count);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public boolean await(Duration timeout) throws InterruptedException {
        return this.await(Internal.toNanosSaturated(timeout), TimeUnit.NANOSECONDS);
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.sync.tryAcquireSharedNanos(1, unit.toNanos(timeout));
    }

    public void countDown() {
        this.sync.releaseShared(1);
    }

    public void increment() {
        this.sync.increaseCount(1);
    }

    public void increment(int delta) {
        Preconditions.checkArgument(delta >= 0, "delta (%s) must be >= 0", delta);
        this.sync.increaseCount(delta);
    }

    public long getCount() {
        return this.sync.getCount();
    }

    public String toString() {
        String string = super.toString();
        int n = this.sync.getCount();
        return new StringBuilder(21 + String.valueOf(string).length()).append(string).append("[Count = ").append(n).append("]").toString();
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 0L;

        Sync(int count) {
            this.setState(count);
        }

        int getCount() {
            return this.getState();
        }

        @Override
        public int tryAcquireShared(int acquires) {
            return this.getState() == 0 ? 1 : -1;
        }

        @Override
        public boolean tryReleaseShared(int releases) {
            int nextc;
            int c;
            do {
                if ((c = this.getState()) == 0) {
                    return false;
                }
                if (releases <= c) continue;
                return false;
            } while (!this.compareAndSetState(c, nextc = c - releases));
            return nextc == 0;
        }

        void increaseCount(int delta) {
            int next;
            int current;
            do {
                current = this.getState();
                next = current + delta;
                if (current == 0) {
                    throw new IllegalStateException("already counted down to zero");
                }
                if (next >= current) continue;
                throw new IllegalArgumentException("count overflow");
            } while (!this.compareAndSetState(current, next));
        }
    }
}

