/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.urlfetch;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.InternalTransientException;
import com.google.appengine.api.urlfetch.RequestPayloadTooLargeException;
import com.google.appengine.api.urlfetch.ResponseTooLargeException;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import org.checkerframework.checker.nullness.qual.Nullable;

class URLFetchServiceImpl
implements URLFetchService {
    static final String PACKAGE = "urlfetch";
    private static final Logger logger = Logger.getLogger(URLFetchServiceImpl.class.getName());

    URLFetchServiceImpl() {
    }

    @Override
    public HTTPResponse fetch(URL url) throws IOException {
        return this.fetch(new HTTPRequest(url));
    }

    @Override
    public HTTPResponse fetch(HTTPRequest request) throws IOException {
        byte[] responseBytes;
        try {
            responseBytes = ApiProxy.makeSyncCall(PACKAGE, "Fetch", this.convertToPb(request).toByteArray(), this.createApiConfig(request.getFetchOptions()));
        }
        catch (ApiProxy.RequestTooLargeException ex) {
            throw new IOException("The request exceeded the maximum permissible size");
        }
        catch (ApiProxy.ApplicationException ex) {
            Throwable cause = this.convertApplicationException(request.getURL(), ex);
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
        catch (ApiProxy.ApiDeadlineExceededException ex) {
            String string = String.valueOf(request.getURL());
            throw new SocketTimeoutException(new StringBuilder(28 + String.valueOf(string).length()).append("Timeout while fetching URL: ").append(string).toString());
        }
        catch (ApiProxy.ApiProxyException ex) {
            throw new IOException(ex);
        }
        URLFetchServicePb.URLFetchResponse responseProto = URLFetchServicePb.URLFetchResponse.parseFrom(responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        if (!request.getFetchOptions().getAllowTruncate() && responseProto.getContentWasTruncated()) {
            throw new ResponseTooLargeException(request.getURL().toString());
        }
        return this.convertFromPb(responseProto);
    }

    @Override
    public Future<HTTPResponse> fetchAsync(URL url) {
        return this.fetchAsync(new HTTPRequest(url));
    }

    @Override
    public Future<HTTPResponse> fetchAsync(HTTPRequest request) {
        final FetchOptions fetchOptions = request.getFetchOptions();
        final URL url = request.getURL();
        Future<byte[]> response = ApiProxy.makeAsyncCall(PACKAGE, "Fetch", this.convertToPb(request).toByteArray(), this.createApiConfig(fetchOptions));
        return new FutureWrapper<byte[], HTTPResponse>(response){

            @Override
            protected HTTPResponse wrap(byte @Nullable [] responseBytes) throws IOException {
                URLFetchServicePb.URLFetchResponse responseProto = ((URLFetchServicePb.URLFetchResponse.Builder)URLFetchServicePb.URLFetchResponse.newBuilder().mergeFrom(responseBytes)).build();
                if (!fetchOptions.getAllowTruncate() && responseProto.getContentWasTruncated()) {
                    throw new ResponseTooLargeException(url.toString());
                }
                return URLFetchServiceImpl.this.convertFromPb(responseProto);
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    return URLFetchServiceImpl.this.convertApplicationException(url, (ApiProxy.ApplicationException)cause);
                }
                if (cause instanceof ApiProxy.ApiDeadlineExceededException) {
                    String string = String.valueOf(url);
                    return new SocketTimeoutException(new StringBuilder(28 + String.valueOf(string).length()).append("Timeout while fetching URL: ").append(string).toString());
                }
                return cause;
            }
        };
    }

    private ApiProxy.ApiConfig createApiConfig(FetchOptions options) {
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Double deadline = options.getDeadline();
        if (deadline != null) {
            apiConfig.setDeadlineInSeconds(deadline);
        } else if (DeadlineParser.INSTANCE.deadlineMs >= 0) {
            apiConfig.setDeadlineInSeconds((double)DeadlineParser.INSTANCE.deadlineMs / 1000.0);
        }
        return apiConfig;
    }

    private String getURLExceptionMessage(String formatString, String url, @Nullable String errorDetail) {
        if (errorDetail == null || errorDetail.trim().isEmpty()) {
            return String.format(formatString, url);
        }
        return String.format(String.valueOf(formatString).concat(", error: %s"), url, errorDetail);
    }

    private Throwable convertApplicationException(URL requestUrl, ApiProxy.ApplicationException ex) {
        String urlString = requestUrl.toString();
        URLFetchServicePb.URLFetchServiceError.ErrorCode errorCode = URLFetchServicePb.URLFetchServiceError.ErrorCode.forNumber(ex.getApplicationError());
        String errorDetail = ex.getErrorDetail();
        switch (errorCode) {
            case INVALID_URL: {
                return new MalformedURLException(this.getURLExceptionMessage("Invalid URL specified: %s", urlString, errorDetail));
            }
            case PAYLOAD_TOO_LARGE: {
                return new RequestPayloadTooLargeException(urlString);
            }
            case CLOSED: {
                return new IOException(this.getURLExceptionMessage("Connection closed unexpectedly by server at URL: %s", urlString, null));
            }
            case TOO_MANY_REDIRECTS: {
                return new IOException(this.getURLExceptionMessage("Too many redirects at URL: %s with redirect=true", urlString, null));
            }
            case MALFORMED_REPLY: {
                return new IOException(this.getURLExceptionMessage("Malformed HTTP reply received from server at URL: %s", urlString, errorDetail));
            }
            case RESPONSE_TOO_LARGE: {
                return new ResponseTooLargeException(urlString);
            }
            case DNS_ERROR: {
                return new UnknownHostException(this.getURLExceptionMessage("DNS host lookup failed for URL: %s", urlString, null));
            }
            case FETCH_ERROR: {
                return new IOException(this.getURLExceptionMessage("Could not fetch URL: %s", urlString, errorDetail));
            }
            case INTERNAL_TRANSIENT_ERROR: {
                return new InternalTransientException(urlString);
            }
            case DEADLINE_EXCEEDED: {
                return new SocketTimeoutException(this.getURLExceptionMessage("Timeout while fetching URL: %s", urlString, null));
            }
            case SSL_CERTIFICATE_ERROR: {
                return new SSLHandshakeException(this.getURLExceptionMessage("Could not verify SSL certificate for URL: %s", urlString, null));
            }
        }
        return new IOException(ex.getErrorDetail());
    }

    private URLFetchServicePb.URLFetchRequest convertToPb(HTTPRequest request) {
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder();
        requestProto.setUrl(request.getURL().toExternalForm());
        byte[] payload = request.getPayload();
        if (payload != null) {
            requestProto.setPayload(ByteString.copyFrom(payload));
        }
        switch (request.getMethod()) {
            case GET: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.GET);
                break;
            }
            case POST: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.POST);
                break;
            }
            case HEAD: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.HEAD);
                break;
            }
            case PUT: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.PUT);
                break;
            }
            case DELETE: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.DELETE);
                break;
            }
            case PATCH: {
                requestProto.setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.PATCH);
                break;
            }
            default: {
                String string = String.valueOf((Object)request.getMethod());
                throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(string).length()).append("unknown method: ").append(string).toString());
            }
        }
        for (HTTPHeader header : request.getHeaders()) {
            URLFetchServicePb.URLFetchRequest.Header.Builder headerProto = URLFetchServicePb.URLFetchRequest.Header.newBuilder();
            headerProto.setKey(header.getName());
            headerProto.setValue(header.getValue());
            requestProto.addHeader(headerProto);
        }
        requestProto.setFollowRedirects(request.getFetchOptions().getFollowRedirects());
        switch (request.getFetchOptions().getCertificateValidationBehavior()) {
            case VALIDATE: {
                requestProto.setMustValidateServerCertificate(true);
                break;
            }
            case DO_NOT_VALIDATE: {
                requestProto.setMustValidateServerCertificate(false);
                break;
            }
        }
        return requestProto.build();
    }

    private HTTPResponse convertFromPb(URLFetchServicePb.URLFetchResponse responseProto) {
        byte[] content = responseProto.hasContent() ? responseProto.getContent().toByteArray() : null;
        ArrayList<HTTPHeader> headers = new ArrayList<HTTPHeader>(responseProto.getHeaderCount());
        for (URLFetchServicePb.URLFetchResponse.Header header : responseProto.getHeaderList()) {
            headers.add(new HTTPHeader(header.getKey(), header.getValue()));
        }
        URL finalURL = null;
        if (responseProto.hasFinalUrl() && responseProto.getFinalUrl().length() > 0) {
            try {
                finalURL = new URL(responseProto.getFinalUrl());
            }
            catch (MalformedURLException e) {
                String string = String.valueOf(e);
                logger.severe(new StringBuilder(21 + String.valueOf(string).length()).append("malformed final URL: ").append(string).toString());
            }
        }
        return new HTTPResponse(responseProto.getStatusCode(), content, finalURL, headers);
    }

    static class DeadlineParser {
        static final DeadlineParser INSTANCE = DeadlineParser.initializedDeadlineParser();
        volatile int deadlineMs = -1;

        private DeadlineParser() {
        }

        private static DeadlineParser initializedDeadlineParser() {
            DeadlineParser parser = new DeadlineParser();
            parser.refresh();
            return parser;
        }

        void refresh() {
            String globalDefault = System.getProperty("appengine.api.urlfetch.defaultDeadline");
            if (globalDefault != null) {
                try {
                    this.deadlineMs = (int)(Double.parseDouble(globalDefault) * 1000.0);
                }
                catch (NumberFormatException e) {
                    this.deadlineMs = -1;
                    String string = String.valueOf(globalDefault);
                    logger.warning(string.length() != 0 ? "Cannot parse deadline: ".concat(string) : new String("Cannot parse deadline: "));
                }
            } else {
                this.deadlineMs = -1;
            }
        }
    }
}

