/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Verify;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.ListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.html.HtmlTextHandler;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.repackaged.com.google.common.net.InternetDomainName;
import com.google.appengine.repackaged.com.google.common.net.UrlEscapers;
import com.google.i18n.Idn;
import com.ibm.icu.text.UnicodeSet;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@GoogleInternal
@GwtIncompatible
public final class LinkDetector {
    private static final Logger logger = Logger.getLogger(LinkDetector.class.getName());
    private static final char EOF = '\u0000';
    private String input;
    private int inputLength;
    private HtmlTextHandler handler;
    private int scanPos;
    private int outputPos;
    private int linePos;
    private boolean endLinksOnNewline = false;
    private int multilineMinimumLength = -1;
    private boolean allowMixedCaseInHostNames = false;
    private boolean allowIdnAndIriUrls = true;
    private boolean allowAllPublicSuffixes = false;
    private boolean outputUnsafeSchemesAsPlaintext = false;
    private final Set<String> safeSchemes = Sets.newHashSet(DEFAULT_SAFE_SCHEMES);
    private ImmutableSet<String> additionalTlds = ImmutableSet.of();
    private static final UnicodeSet PATH_CHARS = new UnicodeSet("[\\p{L}\\p{N}\\p{M}\\p{S}\\p{Pd}\\p{Pc}]").remove(65533).freeze();
    private static final int MAX_SCANNERS = 3;
    private static final ImmutableSet<String> URL_BLACKLIST = ImmutableSet.of("m.in");
    private static final int SCHEME_FLAGS;
    private static final int SCHEME_START_FLAGS;
    private static final int USERNAME_FLAGS;
    private static final int USERNAME_START_FLAGS;
    private static final int HOSTNAME_LABEL_FLAGS;
    private static final int HOSTNAME_DOT_FLAGS;
    private static final int PORT_FLAGS;
    private static final int PATH_FLAGS;
    private static final int PATH_STARTER_FLAGS;
    private static final int STRONG_PUNCTUATION_FLAGS;
    private static final int CLOSING_PUNCTUATION_FLAGS;
    private static final int NEWLINE_FLAGS;
    private static final int ALPHANUM_FLAGS;
    private static final int NON_LATIN_ALPHANUM_FLAGS;
    private static final int WHITESPACE_FLAGS;
    private static final int PATH_TOKEN_SEPARATOR_FLAGS;
    private static final int[] CHAR_MAP;
    private static final int NON_ASCII_CLOSING_PUNCTUATION;
    private static final int NON_ASCII_STRONG_PUNCTUATION;
    private static final int NON_LATIN_ALPHANUM;
    private static final int EXTENDED_LATIN_ALPHANUM;
    private static final int NON_ASCII_WHITESPACE;
    private static final int NON_ASCII_PATH_TOKEN_SEPARATOR;
    private static final int USERNAME_PUNCTUATION_FLAGS;
    private static final int CAN_FOLLOW_HOST_LATIN_ALPHANUM;
    private static final int CAN_FOLLOW_HOST_NON_LATIN_ALPHANUM;
    private static final int CAN_FOLLOW_HOST_DASH;
    private static final int HOST_LABEL;
    private static final int HOSTNAME_TYPE_SWITCH;
    private static final int MULTILINE_URL_STOPPER_FLAGS;
    private static final int NON_LATIN_URL_PIECE_FLAGS;
    private static final ImmutableSet<String> DEFAULT_SAFE_SCHEMES;
    private static final ImmutableSet<String> OPTIONAL_SAFE_SCHEMES;
    private static final ImmutableSet<String> COUNTRY_CODE_TOP_LEVEL_DOMAINS;
    private static final ImmutableSet<String> SPONSORED_TOP_LEVEL_DOMAINS;
    private static final ImmutableSet<String> GENERIC_TOP_LEVEL_DOMAINS;
    private static final ImmutableSet<String> COMMON_TOP_LEVEL_DOMAINS;
    private static final ImmutableSet<String> IFFY_TOP_LEVEL_DOMAINS;
    private static final ImmutableSet<String> COMMON_FILE_EXTENSIONS;
    private static final ListMultimap<String, String> SUFFIX_MAP;
    private static final boolean DEBUG = false;

    public void setEndLinksOnNewLine(boolean endLinkOnNewline) {
        this.endLinksOnNewline = endLinkOnNewline;
    }

    public void setMultilineMinimumLength(int minimumLength) {
        this.multilineMinimumLength = minimumLength;
    }

    public void setAllowMixedCaseInHostNames(boolean allowMixedCase) {
        this.allowMixedCaseInHostNames = allowMixedCase;
    }

    @Deprecated
    public void setAllowIdnAndIriUrls(boolean allowIdnAndIriUrls) {
        this.allowIdnAndIriUrls = allowIdnAndIriUrls;
    }

    public void setAdditionalTopLevelDomains(Set<String> additionalTlds) {
        Preconditions.checkNotNull(additionalTlds);
        this.additionalTlds = ImmutableSet.copyOf(additionalTlds);
    }

    public void setAllowAllPublicSuffixes(boolean allowAllPublicSuffixes) {
        this.allowAllPublicSuffixes = allowAllPublicSuffixes;
    }

    public void setOutputUnsafeSchemesAsPlaintext(boolean outputUnsafeSchemesAsPlaintext) {
        this.outputUnsafeSchemesAsPlaintext = outputUnsafeSchemesAsPlaintext;
    }

    public void process(String input, HtmlTextHandler handler) {
        Preconditions.checkNotNull(input);
        Preconditions.checkNotNull(handler);
        this.input = input;
        this.inputLength = input.length();
        this.handler = handler;
        this.detectLinks();
        this.input = null;
        this.inputLength = 0;
        this.handler = null;
    }

    private void detectLinks() {
        this.outputPos = 0;
        this.linePos = -1;
        Scanner[] currScanners = new Scanner[4];
        Scanner[] nextScanners = new Scanner[4];
        Scanner[] tranScanners = new Scanner[4];
        Scanner[] swap = null;
        this.getRootScanners(currScanners);
        this.scanPos = 0;
        while (this.scanPos <= this.inputLength) {
            block12: {
                Scanner scanner;
                char ch = this.charAt(this.scanPos);
                int charClasses = LinkDetector.getClassesFor(ch);
                ++this.linePos;
                int next = 0;
                int trans = 0;
                int failed = 0;
                for (int i = 0; i < 3 && (scanner = currScanners[i]) != null; ++i) {
                    ScannerState result = scanner.scanNextChar(ch, charClasses);
                    if (result == ScannerState.Scanning) {
                        nextScanners[next++] = scanner;
                        continue;
                    }
                    if (result == ScannerState.Transition) {
                        Scanner[] continueWith = scanner.nextScanners();
                        Verify.verify(continueWith != null && continueWith.length > 0, "No scanners specified.", new Object[0]);
                        for (Scanner tranScanner : continueWith) {
                            tranScanners[trans++] = tranScanner;
                        }
                        continue;
                    }
                    if (result == ScannerState.Failed) {
                        ++failed;
                        continue;
                    }
                    this.outputSegment(scanner, result);
                    this.getRootScanners(currScanners);
                    break block12;
                }
                if (trans > 0) {
                    tranScanners[trans] = null;
                    swap = currScanners;
                    currScanners = tranScanners;
                    tranScanners = swap;
                } else if (next > 0) {
                    if (failed > 0) {
                        nextScanners[next] = null;
                        swap = currScanners;
                        currScanners = nextScanners;
                        nextScanners = swap;
                    }
                } else {
                    this.maybeOutputPlaintext(this.outputPos, this.scanPos);
                    this.outputPos = this.scanPos;
                    this.getRootScanners(currScanners);
                }
                if (LinkDetector.intersects(charClasses, NEWLINE_FLAGS)) {
                    this.linePos = -1;
                }
            }
            ++this.scanPos;
        }
        this.maybeOutputPlaintext(this.outputPos, this.inputLength);
    }

    private void outputSegment(Scanner scanner, ScannerState state) {
        int start = scanner.segmentStart();
        int end = scanner.segmentEnd();
        this.maybeOutputPlaintext(this.outputPos, start);
        if (state == ScannerState.EmailAddressFound) {
            this.outputEmailAddress(start, end);
        } else if (state == ScannerState.PlaintextFound) {
            this.maybeOutputPlaintext(start, end);
        } else {
            this.outputUrl(start, end, state == ScannerState.UnschemedUrlFound);
        }
        this.outputPos = end;
        this.scanPos = end;
    }

    private void maybeOutputPlaintext(int start, int end) {
        if (start < end) {
            this.handler.handlePlainText(this.input, start, end);
        }
    }

    private void outputUrl(int start, int end, boolean addScheme) {
        Verify.verify(start < end, "Start is not less than end", new Object[0]);
        String desc = this.input.substring(start, end);
        if (URL_BLACKLIST.contains(desc)) {
            this.maybeOutputPlaintext(start, end);
            return;
        }
        if (this.outputUnsafeSchemesAsPlaintext && addScheme && LinkDetector.isPrefixedByScheme(this.input, start)) {
            this.maybeOutputPlaintext(start, end);
            return;
        }
        String url = desc.replace("\r\n", "");
        if (addScheme) {
            String string = String.valueOf(url);
            url = string.length() != 0 ? "http://".concat(string) : new String("http://");
        }
        String formattedUrl = LinkDetector.formatSchemedUrl(url);
        if (this.allowIdnAndIriUrls || url.equals(formattedUrl)) {
            this.handler.handleUrl(formattedUrl, desc);
        } else {
            this.maybeOutputPlaintext(start, end);
        }
    }

    private void outputEmailAddress(int start, int end) {
        Verify.verify(start < end, "Start is not less than end", new Object[0]);
        String address = this.input.substring(start, end);
        this.handler.handleMailAddress(address, address);
    }

    private void getRootScanners(Scanner[] scanners) {
        scanners[0] = new SchemeScanner();
        scanners[1] = new HostnameScanner(null, true, false, false);
        scanners[2] = new UsernameScanner(null, false);
        scanners[3] = null;
    }

    private static int toBitmask(CharClass ... classes) {
        int bits = 0;
        for (CharClass charClass : classes) {
            bits |= 1 << charClass.ordinal();
        }
        return bits;
    }

    private static boolean intersects(int bitmask1, int bitmask2) {
        return (bitmask1 & bitmask2) != 0;
    }

    private static final int[] getClassifiedCharMap() {
        int[] charMap = new int[256];
        for (char ch = '\u0000'; ch < '\u0100'; ch = (char)(ch + '\u0001')) {
            if (Character.isWhitespace(ch)) {
                LinkDetector.addClasses(charMap, ch, CharClass.Whitespace, CharClass.StrongPunctuation);
            }
            if (ch >= '\u0080') {
                LinkDetector.addClasses(charMap, ch, CharClass.NonAscii);
            }
            if (!Character.isLetterOrDigit(ch)) continue;
            LinkDetector.addClasses(charMap, ch, CharClass.HostnameLabel, CharClass.Path, CharClass.Alphanum, CharClass.LatinAlphanum);
            if (ch >= 128) continue;
            LinkDetector.addClasses(charMap, ch, CharClass.Username, CharClass.UsernameStart);
            if (Character.isLetter(ch)) {
                LinkDetector.addClasses(charMap, ch, CharClass.Scheme, CharClass.SchemeStart);
            }
            if (!Character.isDigit(ch)) continue;
            LinkDetector.addClasses(charMap, ch, CharClass.Port, CharClass.AsciiNumber);
        }
        LinkDetector.addClasses(charMap, "-_", CharClass.HostnameDash);
        LinkDetector.addClasses(charMap, ".", CharClass.HostnameDot);
        LinkDetector.addClasses(charMap, ":/", CharClass.Scheme);
        LinkDetector.addClasses(charMap, "{}'%;&-_+.", CharClass.Username);
        LinkDetector.addClasses(charMap, "/?#~!@$%&*()[]{}.,`'-_=+|;:\\\u00b7", CharClass.Path);
        LinkDetector.addClasses(charMap, "/?#", CharClass.PathStarter);
        LinkDetector.addClasses(charMap, ".!?\"';:]})", CharClass.ClosingPunctuation);
        LinkDetector.addClasses(charMap, ",^<>\"\\", CharClass.StrongPunctuation);
        LinkDetector.addClasses(charMap, "\u00a0\u0000", CharClass.Whitespace, CharClass.StrongPunctuation);
        LinkDetector.addClasses(charMap, "\r\n", CharClass.Newline);
        LinkDetector.addClasses(charMap, "/&=-_#:<>+\"^(){}[]\u00b7", CharClass.PathTokenSeparator);
        return charMap;
    }

    private static void addClasses(int[] map, String str, CharClass ... classes) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            LinkDetector.addClasses(map, str.charAt(i), classes);
        }
    }

    private static void addClasses(int[] map, char ch, CharClass ... classes) {
        Verify.verify(ch < '\u0100', "Character map only holds characters up to 255", new Object[0]);
        char c = ch;
        map[c] = map[c] | LinkDetector.toBitmask(classes);
    }

    private static int getClassesFor(char ch) {
        return ch < '\u0100' ? CHAR_MAP[ch] : LinkDetector.getClassesForNonMappedChars(ch);
    }

    private static int getClassesForNonMappedChars(char ch) {
        switch (ch) {
            case '\u3001': 
            case '\uff0e': 
            case '\uff61': {
                return NON_ASCII_CLOSING_PUNCTUATION;
            }
            case '\u3002': {
                return NON_ASCII_STRONG_PUNCTUATION;
            }
            case '\u2013': {
                return NON_ASCII_PATH_TOKEN_SEPARATOR;
            }
        }
        if (PATH_CHARS.contains((int)ch)) {
            if (ch > '\u00c1' && ch < '\u024f' || ch > '\u2c60' && ch < '\u2c7f' || ch > '\ua720' && ch < '\ua7ff' || ch > '\u1e00' && ch < '\u1eff') {
                return EXTENDED_LATIN_ALPHANUM;
            }
            return NON_LATIN_ALPHANUM;
        }
        if (Character.isWhitespace(ch)) {
            return NON_ASCII_WHITESPACE;
        }
        return 0;
    }

    private static boolean isWhitespace(char ch) {
        return LinkDetector.intersects(LinkDetector.getClassesFor(ch), WHITESPACE_FLAGS);
    }

    private char peek() {
        return this.charAt(this.scanPos + 1);
    }

    private char charAt(int index) {
        return index < 0 || index >= this.inputLength ? (char)'\u0000' : this.input.charAt(index);
    }

    private boolean atClosingPunctuation(int charClassesAtScanPos) {
        if (LinkDetector.intersects(charClassesAtScanPos, STRONG_PUNCTUATION_FLAGS)) {
            return true;
        }
        if (LinkDetector.intersects(charClassesAtScanPos, CLOSING_PUNCTUATION_FLAGS)) {
            int nextCharClasses = LinkDetector.getClassesFor(this.charAt(this.scanPos + 1));
            if (LinkDetector.intersects(nextCharClasses, STRONG_PUNCTUATION_FLAGS)) {
                return true;
            }
            if (LinkDetector.intersects(nextCharClasses, CLOSING_PUNCTUATION_FLAGS)) {
                return LinkDetector.isWhitespace(this.charAt(this.scanPos + 2));
            }
        }
        return false;
    }

    private static int getNextValidHostnameCharClasses(int currClasses) {
        switch (currClasses & HOSTNAME_TYPE_SWITCH) {
            case 32: {
                return CAN_FOLLOW_HOST_DASH;
            }
            case 65536: {
                return CAN_FOLLOW_HOST_LATIN_ALPHANUM;
            }
            case 131072: {
                return CAN_FOLLOW_HOST_NON_LATIN_ALPHANUM;
            }
        }
        return HOST_LABEL;
    }

    public void addOptionalSafeSchemesIn(Set<String> additionalSchemes) {
        HashSet<String> additionalFullSchemes = Sets.newHashSet();
        String extension = "://";
        for (String scheme : additionalSchemes) {
            String string = String.valueOf(scheme);
            String string2 = String.valueOf(extension);
            additionalFullSchemes.add(string2.length() != 0 ? string.concat(string2) : new String(string));
        }
        this.safeSchemes.addAll(Sets.intersection(OPTIONAL_SAFE_SCHEMES, additionalFullSchemes));
    }

    @VisibleForTesting
    boolean isSafeScheme(String str, int start, int end) {
        int schemeLen = end - start;
        for (String safe : this.safeSchemes) {
            if (schemeLen != safe.length() || !str.regionMatches(true, start, safe, 0, schemeLen)) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrefixedByScheme(String str, int end) {
        return str.regionMatches(end - 3, "://", 0, 3);
    }

    @VisibleForTesting
    static boolean isCommonUrlEnding(String str, int start, int end) {
        return COMMON_FILE_EXTENSIONS.contains(str.substring(start, end).toLowerCase());
    }

    private static ListMultimap<String, String> makeSuffixMap(Set<String> extensions) {
        ArrayListMultimap<String, String> map = ArrayListMultimap.create();
        for (String ext : extensions) {
            for (int index = 1; index < ext.length(); ++index) {
                String suffix = ext.substring(index);
                String prefix = ext.substring(0, index);
                map.put(suffix, prefix);
            }
        }
        return map;
    }

    @VisibleForTesting
    static boolean isIpAddress(String input, int start, int end) {
        int octet = 0;
        int numOctets = 0;
        for (int i = start; i < end; ++i) {
            char ch = input.charAt(i);
            if (LinkDetector.intersects(LinkDetector.getClassesFor(ch), HOSTNAME_DOT_FLAGS)) {
                if (++numOctets > 4) {
                    return false;
                }
                octet = 0;
                continue;
            }
            int digit = Character.digit(ch, 10);
            if (digit == -1) {
                return false;
            }
            if ((octet = octet * 10 + digit) <= 255) continue;
            return false;
        }
        return ++numOctets == 4;
    }

    @VisibleForTesting
    static String formatSchemedUrl(String rawUrl) {
        int pathStart;
        if (CharMatcher.ascii().matchesAllOf(rawUrl)) {
            return rawUrl;
        }
        int schemePos = rawUrl.indexOf("://");
        Verify.verify(schemePos >= 0, "Non-schemed url passed into formatSchemedUrl(): %s", (Object)rawUrl);
        int hostStart = schemePos + 3;
        int n = pathStart = hostStart >= rawUrl.length() ? -1 : CharMatcher.anyOf("/?#").indexIn(rawUrl, hostStart);
        if (pathStart < 0) {
            pathStart = rawUrl.length();
        }
        String scheme = rawUrl.substring(0, hostStart);
        String host = rawUrl.substring(hostStart, pathStart);
        String path = rawUrl.substring(pathStart);
        try {
            StringBuilder url = new StringBuilder(scheme);
            url.append(Idn.toASCII((String)host));
            url.append(new URI(LinkDetector.fixPath(path)).toASCIIString());
            return url.toString();
        }
        catch (URISyntaxException e) {
            logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "formatSchemedUrl", rawUrl, e);
        }
        catch (IllegalArgumentException e) {
            logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "formatSchemedUrl", rawUrl, e);
        }
        catch (IndexOutOfBoundsException e) {
            logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "formatSchemedUrl", rawUrl, e);
        }
        return rawUrl;
    }

    @VisibleForTesting
    static String fixPath(String path) {
        StringBuilder processed = new StringBuilder();
        String remainder = path;
        while (remainder.length() > 0) {
            try {
                URI uri = new URI(remainder);
                processed.append(remainder);
                break;
            }
            catch (URISyntaxException e) {
                int index = e.getIndex();
                processed.append(remainder, 0, index);
                if (index >= remainder.length()) break;
                processed.append(UrlEscapers.urlFormParameterEscaper().escape(remainder.substring(index, index + 1)));
                remainder = remainder.substring(index + 1);
            }
        }
        return processed.toString();
    }

    private void debug(Object src, Object msg) {
        StringBuilder buffer = new StringBuilder();
        String indent = "\n ";
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        buffer.append("POS  : ").append(this.scanPos);
        if (this.scanPos >= 0) {
            buffer.append(" (").append(this.input.substring(this.scanPos)).append(")");
        }
        for (int i = 1; i < stackTrace.length; ++i) {
            String method = stackTrace[i].getMethodName();
            if ("debug".equals(method) || method.indexOf(36) != -1) continue;
            buffer.append("\n ");
            if (src instanceof Scanner) {
                Scanner scanner = (Scanner)src;
                if (scanner.previous != null) {
                    buffer.append(scanner.previous.getClass().getName());
                    buffer.append(" >> ");
                }
            }
            buffer.append(src.getClass().getName());
            buffer.append('.');
            buffer.append(method);
            buffer.append("()");
            break;
        }
        if (src instanceof Scanner) {
            Scanner scanner = (Scanner)src;
            buffer.append("\n ").append(scanner.start);
            buffer.append(" -> ").append(scanner.end);
        }
        if (msg != null) {
            buffer.append("\n ").append(msg.toString());
        }
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "debug", buffer.toString());
    }

    public static void main(String[] args) throws Exception {
        if (new File(args[0]).exists()) {
            LinkDetector.runLoadTest(args[0]);
            return;
        }
        HtmlTextHandler debugHandler = new HtmlTextHandler(){

            @Override
            public void handlePlainText(String text, int start, int end) {
                String string = String.valueOf(text.substring(start, end));
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handlePlainText", string.length() != 0 ? "\n\n ++ TEXT: ".concat(string) : new String("\n\n ++ TEXT: "));
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handlePlainText", "\n");
            }

            @Override
            public void handleUrl(String url, String desc) {
                String string = String.valueOf(desc);
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handleUrl", string.length() != 0 ? "\n\n ++ DESC: ".concat(string) : new String("\n\n ++ DESC: "));
                String string2 = String.valueOf(url);
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handleUrl", string2.length() != 0 ? " ++ URL : ".concat(string2) : new String(" ++ URL : "));
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handleUrl", "\n");
            }

            @Override
            public void handleMailAddress(String address, String desc) {
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handleMailAddress", new StringBuilder(13 + String.valueOf(desc).length()).append("\n\n ++DESC: '").append(desc).append("'").toString());
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handleMailAddress", new StringBuilder(11 + String.valueOf(address).length()).append(" ++MAIL: '").append(address).append("'").toString());
                logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector$1", "handleMailAddress", "\n");
            }
        };
        for (String arg : args) {
            new LinkDetector().process(arg, debugHandler);
        }
    }

    private static void runLoadTest(String filename) throws Exception {
        File file = new File(filename);
        String message = file.isDirectory() ? "" : Files.asCharSource(file, StandardCharsets.UTF_8).read();
        int numIterations = 10;
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", "Running load test ...");
        HtmlTextHandler nullHandler = new HtmlTextHandler(){

            @Override
            public void handlePlainText(String text, int start, int end) {
            }

            @Override
            public void handleUrl(String url, String desc) {
            }

            @Override
            public void handleMailAddress(String address, String desc) {
            }
        };
        LinkDetector detector = new LinkDetector();
        long startTs = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            detector.process(message, nullHandler);
        }
        long endTs = System.currentTimeMillis();
        long elapsed = endTs - startTs;
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", "Num iterations: 10");
        int n = message.length();
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", new StringBuilder(33).append("Message length: ").append(n).append(" chars").toString());
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", new StringBuilder(35).append("Start time   : ").append(startTs).toString());
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", new StringBuilder(35).append("Finished at  : ").append(endTs).toString());
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", new StringBuilder(48).append("Elapsed time : ").append(elapsed).append(" milliseconds").toString());
        float f = (float)elapsed / 10.0f;
        logger.logp(Level.INFO, "com.google.appengine.repackaged.com.google.common.html.LinkDetector", "runLoadTest", new StringBuilder(43).append("Per iteration: ").append(f).append(" milliseconds").toString());
    }

    static {
        if (CharClass.values().length > 32) {
            throw new Error("Number of CharClass's exceeds # of bits in an int");
        }
        SCHEME_FLAGS = LinkDetector.toBitmask(CharClass.Scheme);
        SCHEME_START_FLAGS = LinkDetector.toBitmask(CharClass.SchemeStart);
        USERNAME_FLAGS = LinkDetector.toBitmask(CharClass.Username);
        USERNAME_START_FLAGS = LinkDetector.toBitmask(CharClass.UsernameStart);
        HOSTNAME_LABEL_FLAGS = LinkDetector.toBitmask(CharClass.HostnameLabel);
        HOSTNAME_DOT_FLAGS = LinkDetector.toBitmask(CharClass.HostnameDot);
        PORT_FLAGS = LinkDetector.toBitmask(CharClass.Port);
        PATH_FLAGS = LinkDetector.toBitmask(CharClass.Path);
        PATH_STARTER_FLAGS = LinkDetector.toBitmask(CharClass.PathStarter);
        STRONG_PUNCTUATION_FLAGS = LinkDetector.toBitmask(CharClass.StrongPunctuation);
        CLOSING_PUNCTUATION_FLAGS = LinkDetector.toBitmask(CharClass.ClosingPunctuation);
        NEWLINE_FLAGS = LinkDetector.toBitmask(CharClass.Newline);
        ALPHANUM_FLAGS = LinkDetector.toBitmask(CharClass.Alphanum);
        NON_LATIN_ALPHANUM_FLAGS = LinkDetector.toBitmask(CharClass.NonLatinAlphanum);
        WHITESPACE_FLAGS = LinkDetector.toBitmask(CharClass.Whitespace);
        PATH_TOKEN_SEPARATOR_FLAGS = LinkDetector.toBitmask(CharClass.PathTokenSeparator);
        CHAR_MAP = LinkDetector.getClassifiedCharMap();
        NON_ASCII_CLOSING_PUNCTUATION = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.ClosingPunctuation);
        NON_ASCII_STRONG_PUNCTUATION = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.StrongPunctuation);
        NON_LATIN_ALPHANUM = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.Alphanum, CharClass.NonLatinAlphanum, CharClass.HostnameLabel);
        EXTENDED_LATIN_ALPHANUM = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.Alphanum, CharClass.Path, CharClass.LatinAlphanum, CharClass.HostnameLabel);
        NON_ASCII_WHITESPACE = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.Whitespace, CharClass.StrongPunctuation);
        NON_ASCII_PATH_TOKEN_SEPARATOR = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.Path, CharClass.PathTokenSeparator);
        USERNAME_PUNCTUATION_FLAGS = LinkDetector.toBitmask(CharClass.Username, CharClass.ClosingPunctuation, CharClass.StrongPunctuation);
        CAN_FOLLOW_HOST_LATIN_ALPHANUM = LinkDetector.toBitmask(CharClass.LatinAlphanum, CharClass.HostnameDash, CharClass.HostnameDot);
        CAN_FOLLOW_HOST_NON_LATIN_ALPHANUM = LinkDetector.toBitmask(CharClass.NonLatinAlphanum, CharClass.HostnameDash, CharClass.HostnameDot);
        CAN_FOLLOW_HOST_DASH = LinkDetector.toBitmask(CharClass.HostnameLabel, CharClass.HostnameDash);
        HOST_LABEL = LinkDetector.toBitmask(CharClass.HostnameLabel);
        HOSTNAME_TYPE_SWITCH = LinkDetector.toBitmask(CharClass.LatinAlphanum, CharClass.NonLatinAlphanum, CharClass.HostnameDash);
        Verify.verify(32 == LinkDetector.toBitmask(CharClass.HostnameDash), "Need to update switch() in getNextValidHostnameCharClasses", new Object[0]);
        Verify.verify(65536 == LinkDetector.toBitmask(CharClass.LatinAlphanum), "Need to update switch() in getNextValidHostnameCharClasses", new Object[0]);
        Verify.verify(131072 == LinkDetector.toBitmask(CharClass.NonLatinAlphanum), "Need to update switch() in getNextValidHostnameCharClasses", new Object[0]);
        MULTILINE_URL_STOPPER_FLAGS = LinkDetector.toBitmask(CharClass.NonAscii, CharClass.Whitespace, CharClass.ClosingPunctuation, CharClass.StrongPunctuation);
        NON_LATIN_URL_PIECE_FLAGS = LinkDetector.toBitmask(CharClass.AsciiNumber, CharClass.NonLatinAlphanum);
        DEFAULT_SAFE_SCHEMES = ImmutableSet.of("http://", "https://", "ftp://");
        OPTIONAL_SAFE_SCHEMES = ImmutableSet.of("callto://", "ftps://", "notes://");
        COUNTRY_CODE_TOP_LEVEL_DOMAINS = ImmutableSet.of("ac", "ad", "ae", "af", "ag", "ai", new String[]{"al", "am", "ao", "aq", "ar", "as", "at", "au", "aw", "ax", "az", "ba", "bb", "bd", "be", "bf", "bg", "bh", "bi", "bj", "bm", "bn", "bo", "br", "bs", "bt", "bv", "bw", "by", "bz", "ca", "cc", "cd", "cf", "cg", "ch", "ci", "ck", "cl", "cm", "cn", "co", "cr", "cu", "cv", "cx", "cy", "cz", "de", "dj", "dk", "dm", "do", "dz", "ec", "ee", "eg", "er", "es", "et", "eu", "fi", "fj", "fk", "fm", "fo", "fr", "ga", "gb", "gd", "ge", "gf", "gg", "gh", "gi", "gl", "gm", "gn", "gp", "gq", "gr", "gs", "gt", "gu", "gw", "gy", "hk", "hm", "hn", "hr", "ht", "hu", "id", "ie", "il", "im", "in", "io", "iq", "ir", "is", "it", "je", "jm", "jo", "jp", "ke", "kg", "kh", "ki", "km", "kn", "kp", "kr", "kw", "ky", "kz", "la", "lb", "lc", "li", "lk", "lr", "ls", "lt", "lu", "lv", "ly", "ma", "mc", "md", "me", "mg", "mh", "mk", "ml", "mm", "mn", "mo", "mp", "mq", "mr", "ms", "mt", "mu", "mv", "mw", "mx", "my", "mz", "na", "nc", "ne", "nf", "ng", "ni", "nl", "no", "np", "nr", "nu", "nz", "om", "pa", "pe", "pf", "pg", "ph", "pk", "pl", "pm", "pn", "pr", "ps", "pt", "pw", "py", "qa", "re", "ro", "rs", "ru", "rw", "sa", "sb", "sc", "sd", "se", "sg", "sh", "si", "sj", "sk", "sl", "sm", "sn", "so", "sr", "st", "su", "sv", "sx", "sy", "sz", "tc", "td", "tf", "tg", "th", "tj", "tk", "tl", "tm", "tn", "to", "tr", "tt", "tv", "tw", "tz", "ua", "ug", "uk", "us", "uy", "uz", "va", "vc", "ve", "vg", "vi", "vn", "vu", "wf", "ws", "ye", "yt", "za", "zm", "zw"});
        SPONSORED_TOP_LEVEL_DOMAINS = ImmutableSet.of("aero", "asia", "cat", "coop", "edu", "gov", new String[]{"int", "jobs", "mil", "museum", "post", "tel", "travel"});
        GENERIC_TOP_LEVEL_DOMAINS = ImmutableSet.of("agency", "biz", "com", "dev", "info", "mobi", new String[]{"name", "net", "nyc", "org", "page", "pro", "space", "vote", "work", "xyz"});
        COMMON_TOP_LEVEL_DOMAINS = ((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(COUNTRY_CODE_TOP_LEVEL_DOMAINS)).addAll(SPONSORED_TOP_LEVEL_DOMAINS)).addAll(GENERIC_TOP_LEVEL_DOMAINS)).build();
        IFFY_TOP_LEVEL_DOMAINS = ImmutableSet.of("cc", "py", "sh", "so", "do", "ng", new String[]{"my", "vu", "mo", "au", "md"});
        COMMON_FILE_EXTENSIONS = ImmutableSet.of(".asp", ".avi", ".bmp", ".com", ".doc", ".exe", new String[]{".htm", ".html", ".ico", ".gif", ".jpeg", ".jpg", ".js", ".jsp", ".mp3", ".mpeg", ".mpg", ".net", ".org", ".pcx", ".pdf", ".php", ".php3", ".pic", ".pl", ".png", ".ppt", ".py", ".shtml", ".txt", ".mov", ".wav", ".xml", ".zip"});
        SUFFIX_MAP = LinkDetector.makeSuffixMap(COMMON_FILE_EXTENSIONS);
    }

    private final class NonLatinUrlPieceScanner
    extends Scanner {
        NonLatinUrlPieceScanner(PathScanner previous) {
            super(previous);
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            char nextChar = LinkDetector.this.peek();
            if (nextChar == ')' || nextChar == ']' || nextChar == '}') {
                return this.backToPreviousScanner();
            }
            if (ch == ',') {
                return LinkDetector.isWhitespace(nextChar) ? this.done(true) : ScannerState.Scanning;
            }
            if (LinkDetector.intersects(charClasses, PATH_TOKEN_SEPARATOR_FLAGS)) {
                return LinkDetector.this.atClosingPunctuation(charClasses) ? this.done(true) : this.backToPreviousScanner();
            }
            if (LinkDetector.this.atClosingPunctuation(charClasses)) {
                return this.done(true);
            }
            if (!LinkDetector.intersects(charClasses, NON_LATIN_URL_PIECE_FLAGS)) {
                return this.done(false);
            }
            return ScannerState.Scanning;
        }

        private ScannerState backToPreviousScanner() {
            return this.continueWithScanners(this.previous);
        }

        private ScannerState done(boolean include) {
            this.end = include ? LinkDetector.this.scanPos : this.previous.segmentEnd();
            return this.successState();
        }
    }

    private final class MultilineUrlScanner
    extends Scanner {
        private final int newlinePos;
        private final int lineStart;
        private boolean foundLetter;
        private boolean foundDigit;
        private int dotPos;

        MultilineUrlScanner(PathScanner previous, int newlinePos) {
            super(previous);
            this.foundLetter = false;
            this.foundDigit = false;
            this.dotPos = -1;
            this.newlinePos = newlinePos;
            this.lineStart = LinkDetector.this.input.regionMatches(newlinePos, "\r\n", 0, 2) ? newlinePos + 2 : newlinePos + 1;
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            if (LinkDetector.this.scanPos < this.lineStart) {
                return ScannerState.Scanning;
            }
            switch (ch) {
                case ':': {
                    if (LinkDetector.isWhitespace(LinkDetector.this.peek())) {
                        return this.done();
                    }
                    if (!LinkDetector.this.input.regionMatches(LinkDetector.this.scanPos, ":/", 0, 2) && !LinkDetector.this.input.regionMatches(true, LinkDetector.this.scanPos - 6, "mailto", 0, 6)) break;
                    return this.done(false);
                }
                case '@': {
                    return this.done(false);
                }
                case '/': {
                    if (!this.foundLetter && !this.foundDigit) break;
                    return this.dotPos < 0 ? this.backToPreviousScanner() : this.done(false);
                }
                case '#': 
                case '-': 
                case '=': {
                    int nextCharClasses = LinkDetector.getClassesFor(LinkDetector.this.peek());
                    return LinkDetector.intersects(nextCharClasses, ALPHANUM_FLAGS) || !LinkDetector.intersects(nextCharClasses, WHITESPACE_FLAGS) && Character.isLetterOrDigit(LinkDetector.this.charAt(LinkDetector.this.scanPos + 2)) ? this.backToPreviousScanner() : this.done(false);
                }
                case '&': {
                    return this.backToPreviousScanner();
                }
                case ',': 
                case '?': {
                    if (LinkDetector.isWhitespace(LinkDetector.this.peek())) {
                        return this.done();
                    }
                    return this.backToPreviousScanner();
                }
                case '.': {
                    if (LinkDetector.isWhitespace(LinkDetector.this.peek())) {
                        return this.done();
                    }
                    if (this.dotPos >= 0) {
                        return this.done(false);
                    }
                    if (LinkDetector.this.input.regionMatches(LinkDetector.this.scanPos + 1, "..", 0, 2)) {
                        return this.done(false);
                    }
                    this.dotPos = LinkDetector.this.scanPos;
                    break;
                }
                default: {
                    if (charClasses == 0 || LinkDetector.intersects(charClasses, MULTILINE_URL_STOPPER_FLAGS)) {
                        return this.done();
                    }
                    this.foundLetter = this.foundLetter || Character.isLetter(ch);
                    this.foundDigit = this.foundDigit || Character.isDigit(ch);
                }
            }
            return ScannerState.Scanning;
        }

        private boolean isWrappedUrlSuffix() {
            String suffix = LinkDetector.this.input.substring(this.lineStart, LinkDetector.this.scanPos).toLowerCase();
            Collection prefixes = SUFFIX_MAP.get(suffix);
            for (String prefix : prefixes) {
                int len = prefix.length();
                if (!LinkDetector.this.input.regionMatches(true, this.newlinePos - len, prefix, 0, len)) continue;
                return true;
            }
            return false;
        }

        private ScannerState backToPreviousScanner() {
            return this.continueWithScanners(this.previous);
        }

        private ScannerState done() {
            if (this.dotPos >= 0) {
                return this.done(LinkDetector.isCommonUrlEnding(LinkDetector.this.input, this.dotPos, LinkDetector.this.scanPos));
            }
            boolean multiline = this.foundLetter && this.foundDigit || this.isWrappedUrlSuffix();
            return this.done(multiline);
        }

        private ScannerState done(boolean multiline) {
            this.end = multiline ? LinkDetector.this.scanPos : this.previous.segmentEnd();
            return this.successState();
        }
    }

    private final class PathScanner
    extends Scanner {
        private PairedCharStack pairedChars;
        private int lastDot;
        private int previousCharClasses;

        PathScanner(Scanner previous) {
            super(previous);
            this.pairedChars = null;
            this.lastDot = -1;
            this.previousCharClasses = LinkDetector.toBitmask(new CharClass[]{CharClass.PathTokenSeparator});
            this.successState = previous.successState() == ScannerState.SchemedUrlFound ? ScannerState.SchemedUrlFound : ScannerState.UnschemedUrlFound;
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            switch (ch) {
                case ',': {
                    if (!LinkDetector.isWhitespace(LinkDetector.this.peek())) break;
                    return this.done();
                }
                case '!': 
                case '\'': 
                case ':': 
                case ';': 
                case '\u3001': 
                case '\u3002': {
                    if (!LinkDetector.this.atClosingPunctuation(charClasses)) break;
                    return this.done();
                }
                case '(': 
                case '[': 
                case '{': {
                    this.getPairedChars().addOpener(ch);
                    break;
                }
                case ')': 
                case ']': 
                case '}': {
                    if (!this.getPairedChars().isOutsideCloser(ch) || !LinkDetector.this.atClosingPunctuation(charClasses)) break;
                    return this.done();
                }
                case '.': {
                    this.lastDot = LinkDetector.this.scanPos;
                }
                case '?': {
                    if (!LinkDetector.this.atClosingPunctuation(charClasses)) break;
                    return this.checkForMultiline(charClasses);
                }
                case '\n': 
                case '\r': {
                    if (this.lastDot >= 0 && LinkDetector.isCommonUrlEnding(LinkDetector.this.input, this.lastDot, LinkDetector.this.scanPos)) {
                        return this.done();
                    }
                    return this.checkForMultiline(charClasses);
                }
                default: {
                    if (LinkDetector.intersects(charClasses, PATH_FLAGS)) break;
                    if (LinkDetector.intersects(charClasses, NON_LATIN_ALPHANUM_FLAGS) && LinkDetector.intersects(this.previousCharClasses, PATH_TOKEN_SEPARATOR_FLAGS)) {
                        return this.continueWithScanners(new NonLatinUrlPieceScanner(this));
                    }
                    return this.done();
                }
            }
            this.previousCharClasses = charClasses;
            return ScannerState.Scanning;
        }

        private PairedCharStack getPairedChars() {
            if (this.pairedChars == null) {
                this.pairedChars = new PairedCharStack();
            }
            return this.pairedChars;
        }

        private ScannerState done() {
            this.end = LinkDetector.this.scanPos;
            return this.successState();
        }

        private ScannerState checkForMultiline(int currCharClasses) {
            int newlinePos = -1;
            if (LinkDetector.intersects(currCharClasses, NEWLINE_FLAGS)) {
                newlinePos = LinkDetector.this.scanPos;
            } else if (LinkDetector.intersects(LinkDetector.getClassesFor(LinkDetector.this.peek()), NEWLINE_FLAGS)) {
                newlinePos = LinkDetector.this.scanPos + 1;
            }
            if (newlinePos == -1 || LinkDetector.this.endLinksOnNewline || LinkDetector.this.linePos < LinkDetector.this.multilineMinimumLength) {
                LinkDetector.this.linePos = -1;
                return this.done();
            }
            return this.continueWithScanners(new MultilineUrlScanner(this, newlinePos));
        }
    }

    private static class PairedCharStack {
        private int parenCount = 0;
        private int squareCount = 0;
        private int curlyCount = 0;

        PairedCharStack() {
        }

        void addOpener(char c) {
            switch (c) {
                case '(': {
                    ++this.parenCount;
                    break;
                }
                case '[': {
                    ++this.squareCount;
                    break;
                }
                case '{': {
                    ++this.curlyCount;
                }
            }
        }

        boolean isOutsideCloser(char c) {
            switch (c) {
                case ')': {
                    return --this.parenCount < 0;
                }
                case ']': {
                    return --this.squareCount < 0;
                }
                case '}': {
                    return --this.curlyCount < 0;
                }
            }
            return false;
        }
    }

    private final class PortScanner
    extends Scanner {
        private int portLength;

        PortScanner(HostnameScanner previous) {
            super(previous);
            this.portLength = 0;
            this.successState = previous.successState() == ScannerState.SchemedUrlFound ? ScannerState.SchemedUrlFound : ScannerState.UnschemedUrlFound;
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            if (LinkDetector.intersects(charClasses, PORT_FLAGS)) {
                ++this.portLength;
                return ScannerState.Scanning;
            }
            if (LinkDetector.intersects(charClasses, PATH_STARTER_FLAGS) && this.portLength > 0 && !LinkDetector.this.atClosingPunctuation(charClasses)) {
                return this.continueWithScanners(new PathScanner(this));
            }
            if (this.portLength > 0 && (LinkDetector.this.atClosingPunctuation(charClasses) || LinkDetector.intersects(charClasses, NON_LATIN_ALPHANUM_FLAGS))) {
                this.end = LinkDetector.this.scanPos;
                return this.successState();
            }
            return ScannerState.Failed;
        }
    }

    private final class HostnameScanner
    extends Scanner {
        private final boolean strictHostname;
        private final boolean emailOnly;
        private final boolean hasLinkablePrefix;
        private boolean foundDot;
        private int nextValidHostnameCharClasses;

        HostnameScanner(Scanner previous, boolean strictHostname, boolean emailOnly, boolean hasLinkablePrefix) {
            super(previous);
            this.foundDot = false;
            this.nextValidHostnameCharClasses = HOST_LABEL;
            this.strictHostname = strictHostname;
            this.emailOnly = emailOnly;
            this.hasLinkablePrefix = hasLinkablePrefix;
        }

        private void setStart(int pos) {
            this.start = pos;
            this.foundDot = false;
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            if (this.start == -1) {
                if (LinkDetector.intersects(charClasses, HOSTNAME_LABEL_FLAGS)) {
                    this.setStart(LinkDetector.this.scanPos);
                }
            } else {
                switch (ch) {
                    case ':': {
                        if (LinkDetector.this.input.regionMatches(LinkDetector.this.scanPos + 1, "//", 0, 2)) {
                            if (this.previous == null) break;
                            this.end = this.previous.segmentEnd();
                            return ScannerState.PlaintextFound;
                        }
                        if (this.emailOnly || LinkDetector.this.atClosingPunctuation(charClasses) || !this.goodHost()) break;
                        return this.continueWithScanners(new PortScanner(this));
                    }
                    case '#': 
                    case '/': 
                    case '?': {
                        if (this.emailOnly || LinkDetector.this.atClosingPunctuation(charClasses) || !this.goodHost()) break;
                        return this.continueWithScanners(new PathScanner(this));
                    }
                }
                if (LinkDetector.this.atClosingPunctuation(charClasses) && this.goodHost()) {
                    this.end = LinkDetector.this.scanPos;
                    return this.successState();
                }
                if (LinkDetector.intersects(charClasses, this.nextValidHostnameCharClasses)) {
                    this.foundDot = this.foundDot || LinkDetector.intersects(charClasses, HOSTNAME_DOT_FLAGS);
                } else if (LinkDetector.intersects(charClasses, HOSTNAME_LABEL_FLAGS)) {
                    if (this.foundDot) {
                        if (this.goodHost(true)) {
                            this.end = LinkDetector.this.scanPos;
                            return this.successState();
                        }
                    } else {
                        this.setStart(LinkDetector.this.scanPos);
                    }
                } else if (ch == '@') {
                    this.setStart(-1);
                } else {
                    if (this.goodHost()) {
                        this.end = LinkDetector.this.scanPos;
                        return this.successState();
                    }
                    this.setStart(-1);
                }
            }
            this.nextValidHostnameCharClasses = LinkDetector.getNextValidHostnameCharClasses(charClasses);
            return this.start == -1 ? this.failed() : ScannerState.Scanning;
        }

        private boolean goodHost() {
            return this.goodHost(this.strictHostname);
        }

        private boolean goodHost(boolean strict) {
            return !strict || this.foundDot && this.checkHost(this.start, LinkDetector.this.scanPos);
        }

        @VisibleForTesting
        boolean checkHost(int start, int end) {
            String tld = "";
            boolean validTld = false;
            boolean foundLower = false;
            boolean foundUpper = false;
            int numDots = 0;
            if (this.hasLinkablePrefix && LinkDetector.this.allowAllPublicSuffixes) {
                String host = LinkDetector.this.input.substring(start, end);
                validTld = InternetDomainName.isValid((String)host) ? InternetDomainName.from((String)host).hasPublicSuffix() : validTld;
            }
            for (int i = end - 1; i >= start; --i) {
                char ch = LinkDetector.this.input.charAt(i);
                if (LinkDetector.intersects(LinkDetector.getClassesFor(ch), HOSTNAME_DOT_FLAGS)) {
                    if (++numDots == 1) {
                        tld = LinkDetector.this.input.substring(i + 1, end).toLowerCase();
                        validTld = validTld || COMMON_TOP_LEVEL_DOMAINS.contains(tld) || LinkDetector.this.additionalTlds.contains(tld);
                    } else if (validTld) {
                        return true;
                    }
                    if (validTld) continue;
                    if (!LinkDetector.isIpAddress(LinkDetector.this.input, start, end)) {
                        return false;
                    }
                    if (end < LinkDetector.this.input.length() && (LinkDetector.this.input.charAt(end) == '/' || LinkDetector.this.input.charAt(end) == ':')) {
                        return true;
                    }
                    return start > 0 && (LinkDetector.this.input.charAt(start - 1) == '/' || LinkDetector.this.input.charAt(start - 1) == '@');
                }
                if (LinkDetector.this.allowMixedCaseInHostNames) continue;
                foundLower = foundLower || Character.isLowerCase(ch);
                foundUpper = foundUpper || Character.isUpperCase(ch);
            }
            if (!LinkDetector.this.allowMixedCaseInHostNames && foundLower && foundUpper) {
                return false;
            }
            if (end < LinkDetector.this.input.length() && LinkDetector.this.input.charAt(end) == '/') {
                return true;
            }
            return !IFFY_TOP_LEVEL_DOMAINS.contains(tld);
        }

        private ScannerState failed() {
            if (this.previous == null) {
                this.start = -1;
                this.foundDot = false;
                return ScannerState.Scanning;
            }
            if (this.emailOnly) {
                this.end = LinkDetector.this.scanPos;
                return this.successState();
            }
            return ScannerState.Failed;
        }

        @Override
        protected ScannerState defaultSuccessState() {
            return ScannerState.UnschemedUrlFound;
        }
    }

    private final class UsernameScanner
    extends Scanner {
        private final boolean emailOnly;

        UsernameScanner(Scanner previous, boolean emailOnly) {
            super(previous);
            this.emailOnly = emailOnly;
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            if (this.start == -1) {
                if (LinkDetector.intersects(charClasses, USERNAME_START_FLAGS)) {
                    this.start = LinkDetector.this.scanPos;
                    return ScannerState.Scanning;
                }
                return this.failed();
            }
            if ((charClasses & USERNAME_PUNCTUATION_FLAGS) == USERNAME_FLAGS) {
                return ScannerState.Scanning;
            }
            if (LinkDetector.this.atClosingPunctuation(charClasses)) {
                if (this.emailOnly) {
                    this.end = LinkDetector.this.scanPos;
                    return this.successState();
                }
                return this.failed();
            }
            if (ch == '@') {
                return this.continueWithScanners(new HostnameScanner(this, !this.emailOnly, this.emailOnly, true));
            }
            if (ch == ':') {
                if (this.emailOnly) {
                    this.end = LinkDetector.this.scanPos;
                    return this.successState();
                }
                if (this.successState() == ScannerState.SchemedUrlFound) {
                    return this.continueWithScanners(this);
                }
                return ScannerState.Scanning;
            }
            if (LinkDetector.intersects(charClasses, USERNAME_FLAGS)) {
                return ScannerState.Scanning;
            }
            if (this.emailOnly) {
                this.end = LinkDetector.this.scanPos;
                return this.successState();
            }
            return this.failed();
        }

        private ScannerState failed() {
            if (this.previous == null) {
                this.start = -1;
                return ScannerState.Scanning;
            }
            return ScannerState.Failed;
        }

        @Override
        protected ScannerState defaultSuccessState() {
            return ScannerState.EmailAddressFound;
        }
    }

    private final class SchemeScanner
    extends Scanner {
        boolean lastCharSchemeStarter;

        SchemeScanner() {
            super(null);
            this.lastCharSchemeStarter = false;
        }

        @Override
        protected ScannerState scanNextChar(char ch, int charClasses) {
            boolean schemeStarter = LinkDetector.intersects(charClasses, SCHEME_START_FLAGS);
            if (!this.lastCharSchemeStarter && schemeStarter) {
                this.start = LinkDetector.this.scanPos;
            } else if (this.start != -1) {
                if (!LinkDetector.intersects(charClasses, SCHEME_FLAGS)) {
                    this.start = -1;
                } else if (ch == '/') {
                    if (LinkDetector.this.isSafeScheme(LinkDetector.this.input, this.start, LinkDetector.this.scanPos + 1)) {
                        this.successState = ScannerState.SchemedUrlFound;
                        return this.continueWithScanners(new HostnameScanner(this, false, false, true), new UsernameScanner(this, false));
                    }
                } else if (ch == ':' && this.start == LinkDetector.this.scanPos - 6 && LinkDetector.this.input.regionMatches(true, this.start, "mailto", 0, 6)) {
                    this.start = LinkDetector.this.scanPos + 1;
                    this.successState = ScannerState.EmailAddressFound;
                    return this.continueWithScanners(new UsernameScanner(this, true));
                }
            }
            this.lastCharSchemeStarter = schemeStarter;
            return ScannerState.Scanning;
        }
    }

    private abstract class Scanner {
        private Scanner[] nextScanners = null;
        protected final Scanner previous;
        protected ScannerState successState;
        protected int start;
        protected int end;

        Scanner(Scanner previous) {
            this.previous = previous;
            this.successState = null;
            this.start = -1;
            this.end = -1;
        }

        protected abstract ScannerState scanNextChar(char var1, int var2);

        protected final ScannerState continueWithScanners(Scanner ... scanners) {
            this.end = LinkDetector.this.scanPos;
            this.nextScanners = scanners;
            return ScannerState.Transition;
        }

        final Scanner[] nextScanners() {
            return this.nextScanners;
        }

        final ScannerState scanNextCharDebug(char ch, int charClasses) {
            ScannerState currentState = this.scanNextChar(ch, charClasses);
            return currentState;
        }

        final int segmentStart() {
            return this.previous != null ? this.previous.segmentStart() : this.start;
        }

        final int segmentEnd() {
            return this.end;
        }

        protected final ScannerState successState() {
            if (this.successState != null) {
                return this.successState;
            }
            if (this.previous != null) {
                return this.previous.successState();
            }
            return this.defaultSuccessState();
        }

        protected ScannerState defaultSuccessState() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum ScannerState {
        Scanning,
        Failed,
        Transition,
        SchemedUrlFound,
        UnschemedUrlFound,
        EmailAddressFound,
        PlaintextFound;

    }

    static enum CharClass {
        Scheme,
        SchemeStart,
        Username,
        UsernameStart,
        HostnameLabel,
        HostnameDash,
        HostnameDot,
        Port,
        Path,
        PathStarter,
        NonAscii,
        StrongPunctuation,
        ClosingPunctuation,
        Newline,
        AsciiNumber,
        Alphanum,
        LatinAlphanum,
        NonLatinAlphanum,
        Whitespace,
        PathTokenSeparator;

    }
}

