/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.Crc32c;
import com.google.appengine.api.files.FileReadChannel;
import com.google.appengine.api.files.RecordConstants;
import com.google.appengine.api.files.RecordReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.logging.Level;
import java.util.logging.Logger;

@Deprecated
final class RecordReadChannelImpl
implements RecordReadChannel {
    private static final Logger log = Logger.getLogger(RecordReadChannelImpl.class.getName());
    private final Object lock = new Object();
    private final FileReadChannel input;
    private ByteBuffer blockBuffer;
    private ByteBuffer finalRecord;

    RecordReadChannelImpl(FileReadChannel input) {
        this.input = input;
        this.blockBuffer = ByteBuffer.allocate(32768);
        this.blockBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.finalRecord = ByteBuffer.allocate(32768);
        this.finalRecord.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public ByteBuffer readRecord() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.finalRecord.clear();
            RecordConstants.RecordType lastRead = RecordConstants.RecordType.NONE;
            while (true) {
                String string;
                try {
                    while (true) {
                        Record record;
                        if ((record = this.readPhysicalRecord()) == null) {
                            return null;
                        }
                        switch (record.type()) {
                            case NONE: {
                                this.validateRemainderIsEmpty();
                                break;
                            }
                            case FULL: {
                                if (lastRead != RecordConstants.RecordType.NONE) {
                                    string = String.valueOf((Object)record.type);
                                    throw new RecordReadException(new StringBuilder(20 + String.valueOf(string).length()).append("Invalid RecordType: ").append(string).toString());
                                }
                                return record.data().slice();
                            }
                            case FIRST: {
                                if (lastRead != RecordConstants.RecordType.NONE) {
                                    string = String.valueOf((Object)record.type);
                                    throw new RecordReadException(new StringBuilder(20 + String.valueOf(string).length()).append("Invalid RecordType: ").append(string).toString());
                                }
                                this.finalRecord = RecordReadChannelImpl.appendToBuffer(this.finalRecord, record.data());
                                break;
                            }
                            case MIDDLE: {
                                if (lastRead == RecordConstants.RecordType.NONE) {
                                    string = String.valueOf((Object)record.type);
                                    throw new RecordReadException(new StringBuilder(20 + String.valueOf(string).length()).append("Invalid RecordType: ").append(string).toString());
                                }
                                this.finalRecord = RecordReadChannelImpl.appendToBuffer(this.finalRecord, record.data());
                                break;
                            }
                            case LAST: {
                                if (lastRead == RecordConstants.RecordType.NONE) {
                                    string = String.valueOf((Object)record.type);
                                    throw new RecordReadException(new StringBuilder(20 + String.valueOf(string).length()).append("Invalid RecordType: ").append(string).toString());
                                }
                                this.finalRecord = RecordReadChannelImpl.appendToBuffer(this.finalRecord, record.data());
                                this.finalRecord.flip();
                                return this.finalRecord.slice();
                            }
                            default: {
                                byte by = record.type.value();
                                throw new RecordReadException(new StringBuilder(24).append("Invalid RecordType: ").append(by).toString());
                            }
                        }
                        lastRead = record.type();
                    }
                }
                catch (RecordReadException e) {
                    string = e.getMessage();
                    long l = this.position();
                    String string2 = String.valueOf(this.input);
                    log.log(Level.SEVERE, new StringBuilder(32 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" At pos ").append(l).append(" in ").append(string2).toString());
                    this.finalRecord.clear();
                    this.sync();
                    continue;
                }
                break;
            }
        }
    }

    private void validateRemainderIsEmpty() throws IOException, RecordReadException {
        int bytesToBlockEnd = (int)(32768L - this.input.position() % 32768L);
        this.blockBuffer.clear();
        this.blockBuffer.limit(bytesToBlockEnd);
        int read = this.input.read(this.blockBuffer);
        if (read != bytesToBlockEnd) {
            throw new RecordReadException(new StringBuilder(48).append("There are ").append(bytesToBlockEnd).append(" but ").append(read).append(" were read.").toString());
        }
        this.blockBuffer.flip();
        for (int i = 0; i < bytesToBlockEnd; ++i) {
            byte b = this.blockBuffer.get(i);
            if (b == 0) continue;
            int n = i;
            throw new RecordReadException(new StringBuilder(113).append("Found a non-zero byte: ").append(b).append(" before the end of the block ").append(n).append(" bytes after encountering a RecordType of NONE").toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.input.position();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void position(long newPosition) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.input.position(newPosition);
        }
    }

    private Record readPhysicalRecord() throws IOException, RecordReadException {
        int bytesToBlockEnd = (int)(32768L - this.input.position() % 32768L);
        if (bytesToBlockEnd < 7) {
            return new Record(RecordConstants.RecordType.NONE, null);
        }
        this.blockBuffer.clear();
        this.blockBuffer.limit(7);
        int bytesRead = this.input.read(this.blockBuffer);
        if (bytesRead != 7) {
            return null;
        }
        this.blockBuffer.flip();
        int checksum = this.blockBuffer.getInt();
        short length = this.blockBuffer.getShort();
        RecordConstants.RecordType type = RecordConstants.RecordType.get(this.blockBuffer.get());
        if (length > bytesToBlockEnd || length < 0) {
            throw new RecordReadException(new StringBuilder(26).append("Length is too large:").append(length).toString());
        }
        this.blockBuffer.clear();
        this.blockBuffer.limit(length);
        bytesRead = this.input.read(this.blockBuffer);
        if (bytesRead != length) {
            return null;
        }
        if (!RecordReadChannelImpl.isValidCrc(checksum, this.blockBuffer, type.value())) {
            throw new RecordReadException("Checksum doesn't validate.");
        }
        this.blockBuffer.flip();
        return new Record(type, this.blockBuffer);
    }

    private void sync() throws IOException {
        long padLength = 32768L - this.input.position() % 32768L;
        this.input.position(this.input.position() + padLength);
    }

    private static boolean isValidCrc(int checksum, ByteBuffer data, byte type) {
        if (checksum == 0 && type == 0 && data.limit() == 0) {
            return true;
        }
        Crc32c crc = new Crc32c();
        crc.update(type);
        crc.update(data.array(), 0, data.limit());
        return RecordConstants.unmaskCrc(checksum) == crc.getValue();
    }

    private static ByteBuffer appendToBuffer(ByteBuffer to, ByteBuffer from) {
        if (to.remaining() < from.remaining()) {
            int capacity = to.capacity();
            while (capacity - to.position() < from.remaining()) {
                capacity *= 2;
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
            to.flip();
            newBuffer.put(to);
            to = newBuffer;
            to.order(ByteOrder.LITTLE_ENDIAN);
        }
        to.put(from);
        return to;
    }

    private static final class Record {
        private final ByteBuffer data;
        private final RecordConstants.RecordType type;

        public Record(RecordConstants.RecordType type, ByteBuffer data) {
            this.type = type;
            this.data = data;
        }

        public ByteBuffer data() {
            return this.data;
        }

        public RecordConstants.RecordType type() {
            return this.type;
        }
    }

    static final class RecordReadException
    extends Exception {
        private static final long serialVersionUID = -5691948325473580337L;

        public RecordReadException(String errorMessage) {
            super(errorMessage);
        }
    }
}

