/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.field;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeField;
import com.google.appengine.repackaged.org.joda.time.DateTimeFieldType;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.DurationField;
import com.google.appengine.repackaged.org.joda.time.Interval;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.io.Serializable;
import java.util.Locale;

public abstract class AbstractReadableInstantFieldProperty
implements Serializable {
    private static final long serialVersionUID = 1971226328211649661L;

    public abstract DateTimeField getField();

    public DateTimeFieldType getFieldType() {
        return this.getField().getType();
    }

    public String getName() {
        return this.getField().getName();
    }

    protected abstract long getMillis();

    protected Chronology getChronology() {
        throw new UnsupportedOperationException("The method getChronology() was added in v1.4 and needs to be implemented by subclasses of AbstractReadableInstantFieldProperty");
    }

    public int get() {
        return this.getField().get(this.getMillis());
    }

    public String getAsString() {
        return Integer.toString(this.get());
    }

    public String getAsText() {
        return this.getAsText(null);
    }

    public String getAsText(Locale locale) {
        return this.getField().getAsText(this.getMillis(), locale);
    }

    public String getAsShortText() {
        return this.getAsShortText(null);
    }

    public String getAsShortText(Locale locale) {
        return this.getField().getAsShortText(this.getMillis(), locale);
    }

    public int getDifference(ReadableInstant instant) {
        if (instant == null) {
            return this.getField().getDifference(this.getMillis(), DateTimeUtils.currentTimeMillis());
        }
        return this.getField().getDifference(this.getMillis(), instant.getMillis());
    }

    public long getDifferenceAsLong(ReadableInstant instant) {
        if (instant == null) {
            return this.getField().getDifferenceAsLong(this.getMillis(), DateTimeUtils.currentTimeMillis());
        }
        return this.getField().getDifferenceAsLong(this.getMillis(), instant.getMillis());
    }

    public DurationField getDurationField() {
        return this.getField().getDurationField();
    }

    public DurationField getRangeDurationField() {
        return this.getField().getRangeDurationField();
    }

    public boolean isLeap() {
        return this.getField().isLeap(this.getMillis());
    }

    public int getLeapAmount() {
        return this.getField().getLeapAmount(this.getMillis());
    }

    public DurationField getLeapDurationField() {
        return this.getField().getLeapDurationField();
    }

    public int getMinimumValueOverall() {
        return this.getField().getMinimumValue();
    }

    public int getMinimumValue() {
        return this.getField().getMinimumValue(this.getMillis());
    }

    public int getMaximumValueOverall() {
        return this.getField().getMaximumValue();
    }

    public int getMaximumValue() {
        return this.getField().getMaximumValue(this.getMillis());
    }

    public int getMaximumTextLength(Locale locale) {
        return this.getField().getMaximumTextLength(locale);
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.getField().getMaximumShortTextLength(locale);
    }

    public long remainder() {
        return this.getField().remainder(this.getMillis());
    }

    public Interval toInterval() {
        DateTimeField field = this.getField();
        long start = field.roundFloor(this.getMillis());
        long end = field.add(start, 1);
        Interval interval = new Interval(start, end);
        return interval;
    }

    public int compareTo(ReadableInstant instant) {
        int otherValue;
        if (instant == null) {
            throw new IllegalArgumentException("The instant must not be null");
        }
        int thisValue = this.get();
        if (thisValue < (otherValue = instant.get(this.getFieldType()))) {
            return -1;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return 0;
    }

    public int compareTo(ReadablePartial partial) {
        int otherValue;
        if (partial == null) {
            throw new IllegalArgumentException("The partial must not be null");
        }
        int thisValue = this.get();
        if (thisValue < (otherValue = partial.get(this.getFieldType()))) {
            return -1;
        }
        if (thisValue > otherValue) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AbstractReadableInstantFieldProperty)) {
            return false;
        }
        AbstractReadableInstantFieldProperty other = (AbstractReadableInstantFieldProperty)object;
        return this.get() == other.get() && this.getFieldType().equals(other.getFieldType()) && FieldUtils.equals(this.getChronology(), other.getChronology());
    }

    public int hashCode() {
        return this.get() * 17 + this.getFieldType().hashCode() + this.getChronology().hashCode();
    }

    public String toString() {
        String string = this.getName();
        return new StringBuilder(10 + String.valueOf(string).length()).append("Property[").append(string).append("]").toString();
    }
}

