/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import com.google.appengine.repackaged.com.google.common.flags.FlagInfo;
import com.google.appengine.repackaged.com.google.common.flags.Flags;
import com.google.appengine.repackaged.com.google.common.flags.IllegalFlagStateException;
import com.google.appengine.repackaged.com.google.common.flags.InvalidFlagValueException;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.ForOverride;
import com.google.appengine.repackaged.com.google.errorprone.annotations.concurrent.WriteOnly;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public abstract class Flag<T> {
    @Nullable
    volatile T value;
    @Nullable
    final T defaultValue;
    @WriteOnly
    boolean accessed = false;
    boolean setFromString = false;
    @Nullable
    private volatile String commandLineName;
    @Nullable
    private volatile String commandLineValue;
    @Nullable
    final String declaringClassName;
    @Nullable
    private volatile FlagInfo flagInfo;

    protected Flag(@Nullable T defaultValue) {
        this.defaultValue = defaultValue;
        this.declaringClassName = Flag.findLeafConstructingClassName(new Exception().fillInStackTrace());
        this.value = defaultValue;
        Flags.addFlag(this);
    }

    @Nullable
    private static String findLeafConstructingClassName(Throwable throwable) {
        for (StackTraceElement ste : throwable.getStackTrace()) {
            if (!ste.getMethodName().equals("<clinit>")) continue;
            return ste.getClassName().replace('$', '.');
        }
        return null;
    }

    @Nullable
    @CanIgnoreReturnValue
    public T get() {
        if (!this.accessed && this.value != this.defaultValue) {
            this.warnIfDeprecated();
        }
        this.accessed = true;
        return this.value;
    }

    @CanIgnoreReturnValue
    public final T getNonNull() {
        T value = this.get();
        if (value == null) {
            FlagInfo info = this.getInfo();
            String flagName = info == null ? "" : String.valueOf(info.longFlagName()).concat(" ");
            throw new IllegalStateException(new StringBuilder(12 + String.valueOf(flagName).length()).append("Flag ").append(flagName).append("is null").toString());
        }
        return value;
    }

    public final T orElseGet(FlagValueSupplier<? extends T> supplier) {
        T value = this.get();
        return value != null ? value : FlagDescription.checkNotNull(supplier.get());
    }

    @Nullable
    public final String parsableStringValue() {
        T value = this.get();
        return value != null ? this.parsableStringValue(value) : null;
    }

    protected String parsableStringValue(T value) {
        return value.toString();
    }

    public final String toString() {
        return String.valueOf(this.get());
    }

    public boolean wasSetFromString() {
        return this.setFromString;
    }

    @Nullable
    public final T getDefault() {
        return this.defaultValue;
    }

    @Nullable
    String getDetails() {
        return null;
    }

    @Nullable
    public final FlagInfo getInfo() {
        if (this.flagInfo == null) {
            this.setInfo(Flags.getFlagInfo(this));
        }
        return this.flagInfo;
    }

    final void setInfo(@Nullable FlagInfo flagInfo) {
        this.flagInfo = flagInfo;
    }

    @Nullable
    public final String getCommandLineName() {
        if (this.commandLineName != null) {
            return this.commandLineName;
        }
        FlagInfo info = this.getInfo();
        if (info != null) {
            List<String> names = info.names();
            if (!names.isEmpty()) {
                return names.get(0);
            }
            return info.longFlagName();
        }
        return null;
    }

    private String getLongestName() {
        FlagInfo info = this.getInfo();
        if (info != null) {
            String longName = info.longFlagName();
            if (longName != null) {
                return longName;
            }
            List<String> names = info.names();
            if (!names.isEmpty()) {
                return names.get(0);
            }
        }
        if (this.commandLineName != null) {
            return this.commandLineName;
        }
        return "<unknown>";
    }

    @Nullable
    public final String getCommandLineValue() {
        return this.commandLineValue;
    }

    private void checkWriteState() throws IllegalFlagStateException {
        if (!Flags.isParseInProgress() && !this.isSetFromStringAllowed()) {
            String string = this.getLongestName();
            throw new IllegalFlagStateException(new StringBuilder(41 + String.valueOf(string).length()).append("Setting flag ").append(string).append(" from string is not allowed.").toString());
        }
        if (this.accessed && !Flags.stateCheckingDisabled()) {
            String string = this.getLongestName();
            throw new IllegalFlagStateException(new StringBuilder(40 + String.valueOf(string).length()).append("Attempted to set flag ").append(string).append(" after it was read").toString());
        }
    }

    private void checkTestWriteState() {
        if (this.accessed && !Flags.stateCheckingDisabled()) {
            String string = this.getLongestName();
            throw new IllegalFlagStateException(new StringBuilder(65 + String.valueOf(string).length()).append("Attempted to set flag ").append(string).append(" for tests without disabling state checking").toString());
        }
    }

    private void warnIfDeprecated() {
        FlagInfo info = this.getInfo();
        if (info != null && info.isDeprecated()) {
            String string = info.longFlagName();
            String string2 = info.doc();
            FlagLogger.logger.logp(Level.WARNING, "com.google.appengine.repackaged.com.google.common.flags.Flag", "warnIfDeprecated", new StringBuilder(23 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Flag --").append(string).append(" is deprecated: ").append(string2).toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void setFromNameAndString(@Nullable String commandLineName, @Nullable String valueString, @Nullable String commandLineValue) throws InvalidFlagValueException {
        this.checkWriteState();
        this.setFromString = true;
        this.commandLineName = commandLineName;
        this.commandLineValue = commandLineValue;
        if (valueString == null) {
            if (!Flags.stateCheckingDisabled()) throw new NullPointerException();
            this.value = null;
            return;
        } else {
            this.value = this.parse(valueString);
            this.warnIfDeprecated();
        }
    }

    public final void setFromString(@Nullable String valueString) throws InvalidFlagValueException {
        this.setFromNameAndString(null, valueString, valueString);
    }

    @ForOverride
    protected boolean isSetFromStringAllowed() {
        return true;
    }

    public void resetForTest() {
        this.checkTestWriteState();
        this.commandLineName = null;
        this.commandLineValue = null;
        this.accessed = false;
        this.setFromString = false;
        this.value = this.defaultValue;
    }

    public void setForTest(@Nullable T newValue) {
        this.checkTestWriteState();
        this.commandLineName = null;
        this.commandLineValue = null;
        this.value = newValue;
    }

    protected abstract T parse(String var1) throws InvalidFlagValueException;

    public static Flag<String> value(@Nullable String defaultValue) {
        return new Flag<String>(defaultValue){

            @Override
            protected String parse(String valueString) {
                return valueString;
            }
        };
    }

    public static Flag<String> nullString() {
        return Flag.value((String)null);
    }

    public static Flag<Integer> value(int defaultValue) {
        return new IntegerFlag(defaultValue, Integer.MIN_VALUE);
    }

    public static Flag<Integer> nullInteger() {
        return new IntegerFlag(null, Integer.MIN_VALUE);
    }

    public static Flag<Integer> nonnegativeValue(int defaultValue) {
        return new IntegerFlag(defaultValue, 0);
    }

    public static Flag<Integer> nullNonnegativeValue() {
        return new IntegerFlag(null, 0);
    }

    public static Flag<Integer> positiveValue(int defaultValue) {
        return new IntegerFlag(defaultValue, 1);
    }

    public static Flag<Integer> nullPositiveValue() {
        return new IntegerFlag(null, 1);
    }

    private static Integer parseIntegerOrMax(String text) {
        return "MAX".equals(text) ? Integer.valueOf(Integer.MAX_VALUE) : Integer.decode(text);
    }

    public static Flag<Long> value(long defaultValue) {
        return new LongFlag(defaultValue);
    }

    public static Flag<Long> nullLong() {
        return new LongFlag(null);
    }

    public static Flag<Long> nonnegativeValue(long defaultValue) {
        return new Flag<Long>(Long.valueOf(defaultValue)){

            @Override
            protected Long parse(String text) throws InvalidFlagValueException {
                try {
                    Long val = Flag.parseLongOrMax(text);
                    if (val < 0L) {
                        throw new InvalidFlagValueException("Must not be negative");
                    }
                    return val;
                }
                catch (NumberFormatException e) {
                    throw new InvalidFlagValueException("Invalid integer syntax", e);
                }
            }
        };
    }

    public static Flag<Long> positiveValue(long defaultValue) {
        return new Flag<Long>(Long.valueOf(defaultValue)){

            @Override
            protected Long parse(String text) throws InvalidFlagValueException {
                try {
                    Long value = Flag.parseLongOrMax(text);
                    if (value <= 0L) {
                        throw new InvalidFlagValueException("Must be positive");
                    }
                    return value;
                }
                catch (NumberFormatException e) {
                    throw new InvalidFlagValueException("Invalid integer syntax", e);
                }
            }
        };
    }

    private static Long parseLongOrMax(String text) {
        return "MAX".equals(text) ? Long.valueOf(Long.MAX_VALUE) : Long.decode(text);
    }

    public static Flag<Float> value(float defaultValue) {
        return new FloatFlag(Float.valueOf(defaultValue));
    }

    public static Flag<Float> nullFloat() {
        return new FloatFlag(null);
    }

    private static Float parseFloatOrMax(String text) {
        return "MAX".equals(text) ? Float.valueOf(Float.POSITIVE_INFINITY) : Float.valueOf(text);
    }

    public static Flag<Double> value(double defaultValue) {
        return new DoubleFlag(defaultValue);
    }

    public static Flag<Double> nullDouble() {
        return new DoubleFlag(null);
    }

    private static Double parseDoubleOrMax(String text) {
        return "MAX".equals(text) ? Double.valueOf(Double.POSITIVE_INFINITY) : Double.valueOf(text);
    }

    public static Flag<Boolean> value(boolean defaultValue) {
        return new BooleanFlag(defaultValue);
    }

    public static Flag<Boolean> nullBoolean() {
        return new BooleanFlag(null);
    }

    public static Flag<BigDecimal> value(@Nullable BigDecimal defaultValue) {
        return new Flag<BigDecimal>(defaultValue){

            @Override
            protected BigDecimal parse(String text) throws InvalidFlagValueException {
                try {
                    return new BigDecimal(text);
                }
                catch (NumberFormatException ex) {
                    throw new InvalidFlagValueException("Invalid BigDecimal syntax");
                }
            }
        };
    }

    public static Flag<BigDecimal> nullBigDecimal() {
        return Flag.value((BigDecimal)null);
    }

    public static Flag<Class<?>> value(@Nullable Class<?> defaultValue) {
        return new ClassFlag(defaultValue, Object.class);
    }

    public static Flag<Class<?>> nullClass() {
        return new ClassFlag(null, Object.class);
    }

    public static <T> Flag<Class<? extends T>> value(@Nullable Class<? extends T> defaultValue, Class<T> constraint) {
        return new ClassFlag(defaultValue, constraint);
    }

    public static <T> Flag<Class<? extends T>> nullClass(Class<T> constraint) {
        return new ClassFlag(null, constraint);
    }

    public static <T extends Enum<T>> Flag<T> value(T defaultValue) {
        FlagDescription.checkNotNull(defaultValue);
        return Flag.value(defaultValue, false);
    }

    public static <T extends Enum<T>> Flag<T> value(T defaultValue, boolean autoUpperCase) {
        FlagDescription.checkNotNull(defaultValue);
        return new EnumFlag(defaultValue, defaultValue.getDeclaringClass(), autoUpperCase, null);
    }

    public static <T extends Enum<T>> Flag<T> value(Class<T> enumType, boolean autoUpperCase) {
        FlagDescription.checkNotNull(enumType);
        return new EnumFlag(null, enumType, autoUpperCase, null);
    }

    public static <T extends Enum<T>> Flag<T> value(Class<T> enumType, @Nullable T defaultValue) {
        FlagDescription.checkNotNull(enumType);
        return new EnumFlag(defaultValue, enumType, false, null);
    }

    @Deprecated
    public static Flag<Date> value(@Nullable Date defaultValue, final DateFormat format) {
        FlagDescription.checkNotNull(format);
        return new Flag<Date>(defaultValue){

            @Override
            protected Date parse(String text) throws InvalidFlagValueException {
                try {
                    return format.parse(text);
                }
                catch (ParseException ex) {
                    throw new InvalidFlagValueException("Invalid date syntax");
                }
            }

            @Override
            public String parsableStringValue(Date value) {
                return format.format(value);
            }
        };
    }

    public static Flag<List<Integer>> integerList(int ... defaultValues) {
        List<Integer> defaultValue = new ArrayList();
        for (int i : defaultValues) {
            defaultValue.add(i);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<Integer>>(defaultValue){

            @Override
            protected List<Integer> parse(String text) throws InvalidFlagValueException {
                ArrayList<Integer> result = new ArrayList<Integer>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseIntegerOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().equals("")) continue;
                        String string = String.valueOf(s);
                        throw new InvalidFlagValueException(string.length() != 0 ? "Invalid integer syntax ".concat(string) : new String("Invalid integer syntax "));
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<Integer> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    private static String joinToStrings(Iterable<?> objs) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : objs) {
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(obj);
        }
        return sb.toString();
    }

    public static Flag<List<Long>> longList(long ... defaultValues) {
        List<Long> defaultValue = new ArrayList();
        for (long i : defaultValues) {
            defaultValue.add(i);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<Long>>(defaultValue){

            @Override
            protected List<Long> parse(String text) throws InvalidFlagValueException {
                ArrayList<Long> result = new ArrayList<Long>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseLongOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().equals("")) continue;
                        String string = String.valueOf(s);
                        throw new InvalidFlagValueException(string.length() != 0 ? "Invalid long syntax ".concat(string) : new String("Invalid long syntax "));
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<Long> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<List<Double>> doubleList(double ... defaultValues) {
        List<Double> defaultValue = new ArrayList();
        for (double i : defaultValues) {
            defaultValue.add(i);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<Double>>(defaultValue){

            @Override
            protected List<Double> parse(String text) throws InvalidFlagValueException {
                ArrayList<Double> result = new ArrayList<Double>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseDoubleOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().equals("")) continue;
                        String string = String.valueOf(s);
                        throw new InvalidFlagValueException(string.length() != 0 ? "Invalid double syntax ".concat(string) : new String("Invalid double syntax "));
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<Double> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static <T extends Enum<T>> Flag<List<T>> enumList(Class<T> enumType, T ... defaultValues) {
        return Flag.enumList(enumType, (boolean)false, defaultValues);
    }

    public static <T extends Enum<T>> Flag<List<T>> enumList(final Class<T> enumType, final boolean autoUpperCase, T ... defaultValues) {
        FlagDescription.checkNotNull(enumType, "enumType must not be null");
        List<T> defaultValue = new ArrayList();
        for (T t : defaultValues) {
            FlagDescription.checkNotNull(t, "Elements of defaultValues must not be null");
            defaultValue.add(t);
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<T>>(defaultValue){

            @Override
            protected List<T> parse(String text) throws InvalidFlagValueException {
                ArrayList result = new ArrayList();
                if (!text.trim().equals("")) {
                    if (autoUpperCase) {
                        text = text.toUpperCase(Locale.ENGLISH);
                    }
                    for (String s : text.split(",")) {
                        try {
                            result.add(Enum.valueOf(enumType, s.trim()));
                        }
                        catch (IllegalArgumentException ex) {
                            String string = enumType.getName();
                            String string2 = s.trim();
                            throw new InvalidFlagValueException(new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Not a valid enum ").append(string).append(" constant: ").append(string2).toString());
                        }
                    }
                }
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<T> value) {
                ArrayList<String> enumNames = new ArrayList<String>();
                for (Enum enumValue : value) {
                    enumNames.add(enumValue.name());
                }
                return Flag.joinToStrings(enumNames);
            }
        };
    }

    public static Flag<List<String>> stringList(String ... defaultValues) {
        List<String> defaultValue = new ArrayList();
        for (String s : defaultValues) {
            defaultValue.add(s.toString());
        }
        defaultValue = Collections.unmodifiableList(defaultValue);
        return new Flag<List<String>>(defaultValue){

            @Override
            protected List<String> parse(String text) {
                return Collections.unmodifiableList(Flag.splitCsvString(text));
            }

            @Override
            public String parsableStringValue(List<String> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<Set<String>> stringSet(String ... defaultValues) {
        LinkedHashSet<String> defaultValue = new LinkedHashSet<String>();
        for (String s : defaultValues) {
            defaultValue.add(s.toString());
        }
        return new Flag<Set<String>>(Collections.unmodifiableSet(defaultValue)){

            @Override
            protected Set<String> parse(String text) {
                return Collections.unmodifiableSet(new LinkedHashSet(Flag.splitCsvString(text)));
            }

            @Override
            public String parsableStringValue(Set<String> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    private static List<String> splitCsvString(String text) {
        ArrayList<String> result = new ArrayList<String>();
        if (!text.trim().equals("")) {
            for (String s : text.split(",")) {
                result.add(s.trim());
            }
        }
        return result;
    }

    public static Flag<Set<Integer>> integerSet(int ... defaultValues) {
        LinkedHashSet<Integer> defaultValue = new LinkedHashSet<Integer>();
        for (int s : defaultValues) {
            defaultValue.add(s);
        }
        return new Flag<Set<Integer>>(Collections.unmodifiableSet(defaultValue)){

            @Override
            protected Set<Integer> parse(String text) throws InvalidFlagValueException {
                LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseIntegerOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        String string = String.valueOf(s);
                        throw new InvalidFlagValueException(string.length() != 0 ? "Invalid integer syntax ".concat(string) : new String("Invalid integer syntax "));
                    }
                }
                return Collections.unmodifiableSet(result);
            }

            @Override
            public String parsableStringValue(Set<Integer> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<Set<Long>> longSet(long ... defaultValues) {
        LinkedHashSet<Long> defaultValue = new LinkedHashSet<Long>();
        for (long s : defaultValues) {
            defaultValue.add(s);
        }
        return new Flag<Set<Long>>(Collections.unmodifiableSet(defaultValue)){

            @Override
            protected Set<Long> parse(String text) throws InvalidFlagValueException {
                LinkedHashSet<Long> result = new LinkedHashSet<Long>();
                for (String s : text.split(",")) {
                    try {
                        result.add(Flag.parseLongOrMax(s.trim()));
                    }
                    catch (NumberFormatException e) {
                        if (text.trim().isEmpty()) continue;
                        String string = String.valueOf(s);
                        throw new InvalidFlagValueException(string.length() != 0 ? "Invalid long syntax ".concat(string) : new String("Invalid long syntax "));
                    }
                }
                return Collections.unmodifiableSet(result);
            }

            @Override
            public String parsableStringValue(Set<Long> value) {
                return Flag.joinToStrings(value);
            }
        };
    }

    public static Flag<List<String>> stringCollector(String ... defaultValues) {
        final ArrayList<String> defaults = new ArrayList<String>(defaultValues.length);
        for (String s : defaultValues) {
            FlagDescription.checkNotNull(s);
            defaults.add(s);
        }
        final ArrayList result = new ArrayList(defaults);
        return new Flag<List<String>>(Collections.unmodifiableList(result)){
            private boolean resultCleared;
            {
                super(defaultValue);
                this.resultCleared = false;
            }

            @Override
            protected List<String> parse(String text) {
                if (!this.resultCleared) {
                    this.resultCleared = true;
                    result.clear();
                }
                result.add(text);
                return Collections.unmodifiableList(result);
            }

            @Override
            public String parsableStringValue(List<String> value) {
                String string = String.valueOf(value);
                throw new UnsupportedOperationException(new StringBuilder(48 + String.valueOf(string).length()).append("List can not be represented in a single String: ").append(string).toString());
            }

            @Override
            public void resetForTest() {
                super.resetForTest();
                result.clear();
                result.addAll(defaults);
                this.resultCleared = false;
            }

            @Override
            String getDetails() {
                return "can be specified multiple times, values will be aggregated.";
            }
        };
    }

    public static Flag<Map<String, String>> stringMap() {
        return Flag.stringMap(Collections.emptyMap());
    }

    public static Flag<Map<String, String>> stringMap(@Nullable Map<String, String> defaultValue) {
        return new Flag<Map<String, String>>(defaultValue){

            @Override
            protected Map<String, String> parse(String text) throws InvalidFlagValueException {
                LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
                if (!text.trim().equals("")) {
                    for (String s : text.split(",")) {
                        int index = s.indexOf(61);
                        if (index == -1) {
                            String string = String.valueOf(s);
                            throw new InvalidFlagValueException(string.length() != 0 ? "Invalid map entry syntax ".concat(string) : new String("Invalid map entry syntax "));
                        }
                        result.put(s.substring(0, index).trim(), s.substring(index + 1).trim());
                    }
                }
                return result;
            }

            @Override
            public String parsableStringValue(Map<String, String> value) {
                ArrayList<String> keyValueStrings = new ArrayList<String>();
                for (Map.Entry<String, String> entry : value.entrySet()) {
                    String string = entry.getKey();
                    String string2 = entry.getValue();
                    keyValueStrings.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
                }
                return Flag.joinToStrings(keyValueStrings);
            }
        };
    }

    private static class EnumFlag<T extends Enum<T>>
    extends Flag<T> {
        private final Class<T> enumType;
        private final boolean autoUpperCase;

        private EnumFlag(@Nullable T defaultValue, Class<T> enumType, boolean autoUpperCase) {
            super(defaultValue);
            this.enumType = enumType;
            this.autoUpperCase = autoUpperCase;
        }

        @Override
        protected T parse(String name) throws InvalidFlagValueException {
            String valueToParse = this.autoUpperCase ? name.toUpperCase(Locale.ENGLISH) : name;
            try {
                return Enum.valueOf(this.enumType, valueToParse);
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidFlagValueException(String.format("'%s' is not a valid enum %s constant. Valid values are: %s", valueToParse, this.enumType.getName(), this.validValues()));
            }
        }

        @Override
        public String parsableStringValue(T value) {
            return ((Enum)value).name();
        }

        @Override
        String getDetails() {
            String string = String.valueOf(this.validValues());
            return string.length() != 0 ? "valid values: ".concat(string) : new String("valid values: ");
        }

        private String validValues() {
            ArrayList<String> validValues = new ArrayList<String>();
            for (Enum validValue : (Enum[])this.enumType.getEnumConstants()) {
                validValues.add(validValue.name());
            }
            return ((Object)validValues).toString();
        }

        /* synthetic */ EnumFlag(Enum x0, Class x1, boolean x2, 1 x3) {
            this(x0, x1, x2);
        }
    }

    private static class ClassFlag<T>
    extends Flag<Class<? extends T>> {
        private final Class<T> constraint;

        private ClassFlag(Class<? extends T> defaultValue, Class<T> constraint) {
            super(defaultValue);
            this.constraint = FlagDescription.checkNotNull(constraint);
        }

        @Override
        protected Class<? extends T> parse(String text) throws InvalidFlagValueException {
            try {
                return ClassFlag.classForName(text).asSubclass(this.constraint);
            }
            catch (ClassCastException ex) {
                String string = String.valueOf(this.constraint);
                throw new InvalidFlagValueException(new StringBuilder(17 + String.valueOf(string).length()).append("Not a subtype of ").append(string).toString(), ex);
            }
        }

        @Override
        public String parsableStringValue(Class<? extends T> value) {
            return value.getName();
        }

        private static Class<?> classForName(String name) throws InvalidFlagValueException {
            try {
                return Class.forName(name.toString());
            }
            catch (ClassNotFoundException e) {
                throw new InvalidFlagValueException("No class name with the given name could be found; there are several possible causes: the class exists but is not available to the classloader (e.g. missing dependency), the class name is misspelled, or the class name needs to be fully qualified.", e);
            }
        }
    }

    private static class BooleanFlag
    extends Flag<Boolean> {
        private static final Pattern TRUE_PATTERN = Pattern.compile("^(true|t|yes|y|1)$", 2);
        private static final Pattern FALSE_PATTERN = Pattern.compile("^(false|f|no|n|0)$", 2);

        private BooleanFlag(Boolean defaultValue) {
            super(defaultValue);
        }

        @Override
        protected Boolean parse(String text) throws InvalidFlagValueException {
            if (TRUE_PATTERN.matcher(text).matches()) {
                return true;
            }
            if (FALSE_PATTERN.matcher(text).matches()) {
                return false;
            }
            throw new InvalidFlagValueException("Invalid boolean syntax");
        }
    }

    private static class DoubleFlag
    extends Flag<Double> {
        private DoubleFlag(Double defaultValue) {
            super(defaultValue);
        }

        @Override
        protected Double parse(String text) throws InvalidFlagValueException {
            try {
                return Flag.parseDoubleOrMax(text);
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid double syntax", ex);
            }
        }
    }

    private static class FloatFlag
    extends Flag<Float> {
        private FloatFlag(Float defaultValue) {
            super(defaultValue);
        }

        @Override
        protected Float parse(String text) throws InvalidFlagValueException {
            try {
                return Flag.parseFloatOrMax(text);
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid float syntax", ex);
            }
        }
    }

    private static class LongFlag
    extends Flag<Long> {
        private LongFlag(Long defaultValue) {
            super(defaultValue);
        }

        @Override
        protected Long parse(String text) throws InvalidFlagValueException {
            try {
                return Flag.parseLongOrMax(text);
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid long syntax", ex);
            }
        }
    }

    private static class IntegerFlag
    extends Flag<Integer> {
        private final int lowerBound;

        private IntegerFlag(Integer defaultValue, int lowerBound) {
            super(defaultValue);
            this.lowerBound = lowerBound;
        }

        @Override
        protected Integer parse(String text) throws InvalidFlagValueException {
            try {
                Integer value = Flag.parseIntegerOrMax(text);
                if (value < this.lowerBound) {
                    int n = this.lowerBound;
                    throw new InvalidFlagValueException(new StringBuilder(28).append("Must be at least ").append(n).toString());
                }
                return value;
            }
            catch (NumberFormatException ex) {
                throw new InvalidFlagValueException("Invalid integer syntax", ex);
            }
        }
    }

    public static interface FlagValueSupplier<T> {
        public T get();
    }

    static class FlagLogger {
        private static final Logger logger = Logger.getLogger(Flag.class.getName());

        FlagLogger() {
        }
    }
}

