/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.FilterMatcher;
import com.google.appengine.api.datastore.ValidatedQuery;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.DatastorePb;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class BaseEntityComparator<EntityT>
implements Comparator<EntityT> {
    static final Comparator<Comparable<Object>> MULTI_TYPE_COMPARATOR = new MultiTypeComparator();
    static final Comparator<DatastorePb.Query.Order> ORDER_PROPERTY_COMPARATOR = new Comparator<DatastorePb.Query.Order>(){

        @Override
        public int compare(DatastorePb.Query.Order o1, DatastorePb.Query.Order o2) {
            return o1.getProperty().compareTo(o2.getProperty());
        }
    };
    static final DatastorePb.Query.Order KEY_ASC_ORDER = new DatastorePb.Query.Order().setProperty("__key__").setDirection(DatastorePb.Query.Order.Direction.ASCENDING);
    final List<DatastorePb.Query.Order> orders;
    final Map<String, FilterMatcher> filters;

    BaseEntityComparator(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
        this.orders = BaseEntityComparator.makeAdjustedOrders(orders, filters);
        this.filters = BaseEntityComparator.makeFilterMatchers(orders, filters);
    }

    abstract List<Comparable<Object>> getComparablePropertyValues(EntityT var1, String var2);

    private static List<DatastorePb.Query.Order> makeAdjustedOrders(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
        ArrayList<DatastorePb.Query.Order> existsOrders = Lists.newArrayList();
        for (DatastorePb.Query.Filter filter : filters) {
            if (filter.getOpEnum() != DatastorePb.Query.Filter.Operator.EXISTS) continue;
            existsOrders.add(new DatastorePb.Query.Order().setProperty(filter.getProperty(0).getName()).setDirection(DatastorePb.Query.Order.Direction.ASCENDING));
        }
        Collections.sort(existsOrders, ORDER_PROPERTY_COMPARATOR);
        ArrayList<DatastorePb.Query.Order> adjusted = new ArrayList<DatastorePb.Query.Order>(orders.size() + existsOrders.size() + 1);
        adjusted.addAll(orders);
        if (adjusted.isEmpty()) {
            for (DatastorePb.Query.Filter filter : filters) {
                if (!ValidatedQuery.INEQUALITY_OPERATORS.contains(filter.getOpEnum())) continue;
                adjusted.add(new DatastorePb.Query.Order().setProperty(filter.getProperty(0).getName()).setDirection(DatastorePb.Query.Order.Direction.ASCENDING));
                break;
            }
        }
        adjusted.addAll(existsOrders);
        if (adjusted.isEmpty() || !((DatastorePb.Query.Order)adjusted.get(adjusted.size() - 1)).equals(KEY_ASC_ORDER)) {
            adjusted.add(KEY_ASC_ORDER);
        }
        return adjusted;
    }

    private static Map<String, FilterMatcher> makeFilterMatchers(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
        HashMap<String, FilterMatcher> filterMatchers = new HashMap<String, FilterMatcher>();
        for (DatastorePb.Query.Filter filter : filters) {
            String name = filter.getProperty(0).getName();
            FilterMatcher filterMatcher = (FilterMatcher)filterMatchers.get(name);
            if (filterMatcher == null) {
                filterMatcher = new FilterMatcher();
                filterMatchers.put(name, filterMatcher);
            }
            filterMatcher.addFilter(filter);
        }
        for (DatastorePb.Query.Order order : orders) {
            if (!filterMatchers.containsKey(order.getProperty())) {
                filterMatchers.put(order.getProperty(), FilterMatcher.MATCH_ALL);
            }
            if (!order.getProperty().equals(KEY_ASC_ORDER.getProperty())) continue;
            break;
        }
        return filterMatchers;
    }

    @Override
    public int compare(EntityT entityA, EntityT entityB) {
        for (DatastorePb.Query.Order order : this.orders) {
            Comparable<Object> extremeB;
            Comparable<Object> extremeA;
            int result;
            String property = order.getProperty();
            List<Comparable<Object>> aValues = this.getComparablePropertyValues(entityA, property);
            List<Comparable<Object>> bValues = this.getComparablePropertyValues(entityB, property);
            if (aValues == null || bValues == null) {
                return 0;
            }
            boolean findMin = order.getDirectionEnum() == DatastorePb.Query.Order.Direction.ASCENDING;
            FilterMatcher matcher = this.filters.get(property);
            if (matcher == null) {
                matcher = FilterMatcher.MATCH_ALL;
            }
            if ((result = MULTI_TYPE_COMPARATOR.compare(extremeA = BaseEntityComparator.multiTypeExtreme(aValues, findMin, matcher), extremeB = BaseEntityComparator.multiTypeExtreme(bValues, findMin, matcher))) == 0) continue;
            if (order.getDirectionEnum() == DatastorePb.Query.Order.Direction.DESCENDING) {
                result = -result;
            }
            return result;
        }
        return 0;
    }

    static Comparable<Object> multiTypeExtreme(Collection<Comparable<Object>> comparables, boolean findMin, FilterMatcher matcher) {
        boolean findMax = !findMin;
        Comparable<Object> extreme = FilterMatcher.NoValue.INSTANCE;
        for (Comparable<Object> value : comparables) {
            if (!matcher.considerValueForOrder(value)) continue;
            if (extreme == FilterMatcher.NoValue.INSTANCE) {
                extreme = value;
                continue;
            }
            if (findMin && MULTI_TYPE_COMPARATOR.compare(value, extreme) < 0) {
                extreme = value;
                continue;
            }
            if (!findMax || MULTI_TYPE_COMPARATOR.compare(value, extreme) <= 0) continue;
            extreme = value;
        }
        if (extreme == FilterMatcher.NoValue.INSTANCE) {
            throw new IllegalArgumentException("Entity contains no relevant values.");
        }
        return extreme;
    }

    private static final class MultiTypeComparator
    implements Comparator<Comparable<Object>> {
        private MultiTypeComparator() {
        }

        @Override
        public int compare(Comparable<Object> o1, Comparable<Object> o2) {
            int comp2TypeRank;
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            int comp1TypeRank = DataTypeTranslator.getTypeRank(o1.getClass());
            if (comp1TypeRank == (comp2TypeRank = DataTypeTranslator.getTypeRank(o2.getClass()))) {
                return o1.compareTo(o2);
            }
            return Integer.compare(comp1TypeRank, comp2TypeRank);
        }
    }
}

