/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app;

import com.google.apphosting.datastore.EntityV4;
import java.util.EnumSet;

public class EntityTranslator {
    public static final EntityTranslator DEFAULT = new EntityTranslator();
    static final int MEANING_PREDEFINED_ENTITY_POINT = 21;
    static final int MEANING_GEORSS_POINT = 9;

    private static void entitiesToGeoPoints(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            EntityTranslator.entitiesToGeoPoints(prop.getValueBuilder());
        }
    }

    private static void entitiesToGeoPoints(EntityV4.Value.Builder value) {
        if (value.hasEntityValue() && value.getMeaning() == 9) {
            EntityV4.EntityOrBuilder entityValue = value.getEntityValueOrBuilder();
            EntityV4.GeoPoint.Builder geoPointValue = EntityV4.GeoPoint.newBuilder();
            for (EntityV4.PropertyOrBuilder propertyOrBuilder : entityValue.getPropertyOrBuilderList()) {
                if (!propertyOrBuilder.getValueOrBuilder().hasDoubleValue()) continue;
                switch (propertyOrBuilder.getName()) {
                    case "x": {
                        geoPointValue.setLatitude(propertyOrBuilder.getValueOrBuilder().getDoubleValue());
                        break;
                    }
                    case "y": {
                        geoPointValue.setLongitude(propertyOrBuilder.getValueOrBuilder().getDoubleValue());
                        break;
                    }
                }
            }
            if (geoPointValue.hasLatitude() && geoPointValue.hasLongitude()) {
                value.setGeoPointValue(geoPointValue);
                value.clearMeaning();
                value.clearEntityValue();
            }
        }
        if (value.hasEntityValue()) {
            EntityTranslator.entitiesToGeoPoints(value.getEntityValueBuilder());
        }
        for (EntityV4.Value.Builder child : value.getListValueBuilderList()) {
            EntityTranslator.entitiesToGeoPoints(child);
        }
    }

    private static void geoPointsToEntities(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            EntityTranslator.geoPointsToEntities(prop.getValueBuilder());
        }
    }

    private static void geoPointsToEntities(EntityV4.Value.Builder value) {
        if (value.hasGeoPointValue()) {
            EntityV4.GeoPointOrBuilder geopointValue = value.getGeoPointValueOrBuilder();
            value.getEntityValueBuilder().addProperty(EntityTranslator.toV4UnindexedProperty("x", geopointValue.getLatitude())).addProperty(EntityTranslator.toV4UnindexedProperty("y", geopointValue.getLongitude()));
            value.setMeaning(9);
            value.clearGeoPointValue();
        } else if (value.hasEntityValue()) {
            EntityTranslator.geoPointsToEntities(value.getEntityValueBuilder());
        }
        for (EntityV4.Value.Builder child : value.getListValueBuilderList()) {
            EntityTranslator.geoPointsToEntities(child);
        }
    }

    private static EntityV4.Property.Builder toV4UnindexedProperty(String propertyName, double doubleValue) {
        return EntityV4.Property.newBuilder().setName(propertyName).setValue(EntityV4.Value.newBuilder().setDoubleValue(doubleValue).setIndexed(false));
    }

    private static void multiValuesToLists(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            EntityTranslator.multiValuesToLists(prop);
        }
    }

    private static boolean hasEntityWithProperties(EntityV4.ValueOrBuilder value) {
        return value.hasEntityValue() && value.getEntityValueOrBuilder().getPropertyCount() > 0;
    }

    private static void multiValuesToLists(EntityV4.Property.Builder prop) {
        if (prop.getDeprecatedMulti()) {
            EntityV4.Value.Builder value = prop.getValueBuilder();
            value.addAllListValue(prop.getDeprecatedValueList());
            for (int i = 0; i < value.getListValueCount(); ++i) {
                EntityV4.ValueOrBuilder subValue = value.getListValueOrBuilder(i);
                if (!EntityTranslator.hasEntityWithProperties(subValue)) continue;
                EntityTranslator.multiValuesToLists(value.getListValueBuilder(i).getEntityValueBuilder());
            }
        } else if (prop.getDeprecatedValueCount() > 0) {
            prop.setValue(prop.getDeprecatedValue(0));
            if (EntityTranslator.hasEntityWithProperties(prop.getValueOrBuilder())) {
                EntityTranslator.multiValuesToLists(prop.getValueBuilder().getEntityValueBuilder());
            }
        }
        prop.clearDeprecatedMulti().clearDeprecatedValue();
    }

    private static void listsToMultiValues(EntityV4.Entity.Builder entity) {
        for (EntityV4.Property.Builder prop : entity.getPropertyBuilderList()) {
            EntityTranslator.listsToMultiValues(prop);
        }
    }

    private static void listsToMultiValues(EntityV4.Property.Builder prop) {
        if (prop.getValueOrBuilder().getListValueCount() > 0) {
            prop.setDeprecatedMulti(true);
            prop.addAllDeprecatedValue(prop.getValueOrBuilder().getListValueList());
        } else {
            prop.addDeprecatedValue(prop.getValue());
        }
        prop.clearValue();
        for (int i = 0; i < prop.getDeprecatedValueCount(); ++i) {
            EntityV4.ValueOrBuilder value = prop.getDeprecatedValueOrBuilder(i);
            if (!EntityTranslator.hasEntityWithProperties(value)) continue;
            EntityTranslator.listsToMultiValues(prop.getDeprecatedValueBuilder(i).getEntityValueBuilder());
        }
    }

    public static enum Format {
        V1BETA1,
        V1BETA2,
        V1BETA3;


        private final Format downgrade(EntityV4.Entity.Builder entity) {
            switch (this) {
                case V1BETA2: {
                    EntityTranslator.listsToMultiValues(entity);
                    return V1BETA1;
                }
                case V1BETA3: {
                    EntityTranslator.geoPointsToEntities(entity);
                    return V1BETA2;
                }
            }
            String string = String.valueOf((Object)this);
            throw new UnsupportedOperationException(new StringBuilder(24 + String.valueOf(string).length()).append("cannot downgrade format ").append(string).toString());
        }

        private final Format upgrade(EntityV4.Entity.Builder entity) {
            switch (this) {
                case V1BETA1: {
                    EntityTranslator.multiValuesToLists(entity);
                    return V1BETA2;
                }
                case V1BETA2: {
                    EntityTranslator.entitiesToGeoPoints(entity);
                    return V1BETA3;
                }
            }
            String string = String.valueOf((Object)this);
            throw new UnsupportedOperationException(new StringBuilder(22 + String.valueOf(string).length()).append("cannot upgrade format ").append(string).toString());
        }

        private final Boolean isCompatibleWithValueHelper(EntityV4.ValueOrBuilder value) {
            if (value.hasGeoPointValue()) {
                return this == V1BETA3;
            }
            if (value.hasEntityValue()) {
                if (value.getMeaning() == 9) {
                    return this != V1BETA3;
                }
                Boolean v = this.isCompatibleWithHelper(value.getEntityValueOrBuilder().getPropertyOrBuilderList());
                if (v != null) {
                    return v;
                }
            }
            for (EntityV4.ValueOrBuilder valueOrBuilder : value.getListValueOrBuilderList()) {
                Boolean v = this.isCompatibleWithValueHelper(valueOrBuilder);
                if (v == null) continue;
                return v;
            }
            return null;
        }

        private final Boolean isCompatibleWithHelper(Iterable<? extends EntityV4.PropertyOrBuilder> properties) {
            for (EntityV4.PropertyOrBuilder propertyOrBuilder : properties) {
                Boolean v = this.isCompatibleWithValueHelper(propertyOrBuilder.getValueOrBuilder());
                if (v == null) continue;
                return v;
            }
            return null;
        }

        public final boolean isCompatibleWith(EntityV4.EntityOrBuilder entity) {
            if (entity.getPropertyCount() == 0) {
                return true;
            }
            EntityV4.PropertyOrBuilder property0 = entity.getPropertyOrBuilder(0);
            if (property0.hasDeprecatedMulti() || property0.getDeprecatedValueCount() > 0) {
                return this == V1BETA1;
            }
            if (this == V1BETA1) {
                return false;
            }
            Boolean v = this.isCompatibleWithHelper(entity.getPropertyOrBuilderList());
            if (v != null) {
                return v;
            }
            return true;
        }

        private final EntityV4.Entity.Builder convertHelper(EntityV4.Entity.Builder builder, Format fromFormat) {
            EnumSet<Format> seen = EnumSet.noneOf(Format.class);
            while (true) {
                if (!seen.add(fromFormat)) {
                    throw new IllegalStateException("cycle detected during format conversion");
                }
                int compare = fromFormat.compareTo(this);
                if (compare < 0) {
                    fromFormat = fromFormat.upgrade(builder);
                    continue;
                }
                if (compare <= 0) break;
                fromFormat = fromFormat.downgrade(builder);
            }
            return builder;
        }

        public final EntityV4.Entity convert(EntityV4.Entity entity) {
            if (V1BETA3.isCompatibleWith(entity)) {
                if (this != V1BETA3) {
                    entity = this.convertHelper(entity.toBuilder(), V1BETA3).build();
                }
            } else if (V1BETA2.isCompatibleWith(entity)) {
                if (this != V1BETA2) {
                    entity = this.convertHelper(entity.toBuilder(), V1BETA2).build();
                }
            } else {
                throw new IllegalArgumentException("Unsupported input format");
            }
            return entity;
        }

        public final EntityV4.Entity.Builder convertIfFormat(EntityV4.Entity.Builder entity, Format fromFormat) {
            if (!fromFormat.isCompatibleWith(entity)) {
                throw new IllegalArgumentException("entity is not compatible with format");
            }
            if (this == fromFormat || this.isCompatibleWith(entity)) {
                return entity;
            }
            return this.convertHelper(entity, fromFormat);
        }

        public final EntityV4.Entity convertIfFormat(EntityV4.Entity entity, Format fromFormat) {
            if (!fromFormat.isCompatibleWith(entity)) {
                throw new IllegalArgumentException("entity is not compatible with format");
            }
            if (this == fromFormat || this.isCompatibleWith(entity)) {
                return entity;
            }
            return this.convertHelper(entity.toBuilder(), fromFormat).build();
        }
    }
}

