/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchResponse;
import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.LowLevelHttpResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;

final class UrlFetchRequest
extends LowLevelHttpRequest {
    private final HTTPRequest request;

    UrlFetchRequest(FetchOptions fetchOptions, HTTPMethod method, String url) throws IOException {
        this.request = new HTTPRequest(new URL(url), method, fetchOptions);
    }

    @Override
    public void addHeader(String name, String value) {
        this.request.addHeader(new HTTPHeader(name, value));
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) {
        this.request.getFetchOptions().setDeadline(connectTimeout == 0 || readTimeout == 0 ? Double.MAX_VALUE : (double)(connectTimeout + readTimeout) / 1000.0);
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        if (this.getStreamingContent() != null) {
            String contentEncoding;
            String contentType = this.getContentType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.getContentEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getStreamingContent().writeTo(out);
            byte[] payload = out.toByteArray();
            if (payload.length != 0) {
                this.request.setPayload(payload);
            }
        }
        URLFetchService service = URLFetchServiceFactory.getURLFetchService();
        HTTPResponse response = service.fetch(this.request);
        return new UrlFetchResponse(response);
    }
}

