/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.memcache;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.memcache.AsyncMemcacheService;
import com.google.appengine.api.memcache.BaseMemcacheServiceImpl;
import com.google.appengine.api.memcache.ConsistentErrorHandler;
import com.google.appengine.api.memcache.ErrorHandler;
import com.google.appengine.api.memcache.Expiration;
import com.google.appengine.api.memcache.InvalidValueException;
import com.google.appengine.api.memcache.MemcacheSerialization;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.api.memcache.MemcacheServiceApiHelper;
import com.google.appengine.api.memcache.MemcacheServiceException;
import com.google.appengine.api.memcache.MemcacheServicePb;
import com.google.appengine.api.memcache.Stats;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.base.Ascii;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.primitives.Bytes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

class AsyncMemcacheServiceImpl
extends BaseMemcacheServiceImpl
implements AsyncMemcacheService {
    private static final ErrorHandler DO_NOTHING_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void handleDeserializationError(InvalidValueException ivx) {
        }

        @Override
        public void handleServiceError(MemcacheServiceException ex) {
        }
    };
    private static final ErrorHandler DO_NOTHING_CONSISTENT_ERROR_HANDLER = new ConsistentErrorHandler(){

        @Override
        public void handleDeserializationError(InvalidValueException ivx) {
        }

        @Override
        public void handleServiceError(MemcacheServiceException ex) {
        }
    };
    static final int ITEM_SIZE_LIMIT = 1048480;
    private static final int MAX_LOGGED_VALUE_SIZE = 100;
    private static final int MEMCACHEG_OVERHEAD = 73;
    private static final int ONE_MEGABYTE = 0x100000;
    public static final int MAX_ITEM_SIZE = 1048503;

    AsyncMemcacheServiceImpl(String namespace) {
        super(namespace);
    }

    static <T, V> Map<T, V> makeMap(Collection<T> keys, V value) {
        LinkedHashMap<T, V> map = new LinkedHashMap<T, V>(keys.size(), 1.0f);
        for (T key : keys) {
            map.put(key, value);
        }
        return map;
    }

    private static ByteString makePbKey(Object key) {
        try {
            return ByteString.copyFrom(MemcacheSerialization.makePbKey(key));
        }
        catch (IOException ex) {
            String string = String.valueOf(key);
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Cannot use as a key: '").append(string).append("'").toString(), ex);
        }
    }

    private static MemcacheSerialization.ValueAndFlags serializeValue(Object value) {
        try {
            return MemcacheSerialization.serialize(value);
        }
        catch (IOException ex) {
            String string = String.valueOf(value);
            throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(string).length()).append("Cannot use as value: '").append(string).append("'").toString(), ex);
        }
    }

    private Object deserializeItem(Object key, MemcacheServicePb.MemcacheGetResponse.Item item) {
        try {
            return MemcacheSerialization.deserialize(item.getValue().toByteArray(), item.getFlags());
        }
        catch (ClassNotFoundException ex) {
            String string = String.valueOf(key);
            this.getErrorHandler().handleDeserializationError(new InvalidValueException(new StringBuilder(36 + String.valueOf(string).length()).append("Can't find class for value of key '").append(string).append("'").toString(), ex));
        }
        catch (IOException ex) {
            String string = String.valueOf(key);
            this.getErrorHandler().handleDeserializationError(new InvalidValueException(new StringBuilder(32 + String.valueOf(string).length()).append("Failed to parse the value for '").append(string).append("'").toString(), ex));
        }
        return null;
    }

    private <M extends Message, T> MemcacheServiceApiHelper.RpcResponseHandler<M, T> createRpcResponseHandler(M response, String errorText, MemcacheServiceApiHelper.Transformer<M, T> responseTransformer) {
        return new MemcacheServiceApiHelper.RpcResponseHandler<M, T>(response, errorText, responseTransformer, this.getErrorHandler());
    }

    private <T> RpcResponseHandlerForPut<T> createRpcResponseHandlerForPut(Iterable<MemcacheServicePb.MemcacheSetRequest.Item.Builder> itemBuilders, String namespace, MemcacheServicePb.MemcacheSetResponse response, String errorText, MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheSetResponse, T> responseTransformer) {
        return new RpcResponseHandlerForPut<T>(this, itemBuilders, namespace, response, errorText, responseTransformer, this.getErrorHandler());
    }

    @Override
    public Future<Boolean> contains(Object key) {
        String string = String.valueOf(key);
        return this.doGet(key, false, new StringBuilder(48 + String.valueOf(string).length()).append("Memcache contains: exception testing contains (").append(string).append(")").toString(), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, Boolean>(this){

            @Override
            public Boolean transform(MemcacheServicePb.MemcacheGetResponse response) {
                return response.getItemCount() > 0;
            }
        }, DefaultValueProviders.falseValue());
    }

    private <T> Future<T> doGet(Object key, boolean forCas, String errorText, MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, T> responseTransfomer, MemcacheServiceApiHelper.Provider<T> defaultValue) {
        MemcacheServicePb.MemcacheGetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheGetRequest.newBuilder();
        requestBuilder.addKey(AsyncMemcacheServiceImpl.makePbKey(key));
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        if (forCas) {
            requestBuilder.setForCas(true);
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Get", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheGetResponse.getDefaultInstance(), errorText, responseTransfomer), defaultValue);
    }

    @Override
    public Future<Object> get(final Object key) {
        String string = String.valueOf(key);
        return this.doGet(key, false, new StringBuilder(40 + String.valueOf(string).length()).append("Memcache get: exception getting 1 key (").append(string).append(")").toString(), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, Object>(){

            @Override
            public Object transform(MemcacheServicePb.MemcacheGetResponse response) {
                return response.getItemCount() == 0 ? null : AsyncMemcacheServiceImpl.this.deserializeItem(key, response.getItem(0));
            }
        }, DefaultValueProviders.nullValue());
    }

    @Override
    public Future<MemcacheService.IdentifiableValue> getIdentifiable(final Object key) {
        String string = String.valueOf(key);
        return this.doGet(key, true, new StringBuilder(52 + String.valueOf(string).length()).append("Memcache getIdentifiable: exception getting 1 key (").append(string).append(")").toString(), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, MemcacheService.IdentifiableValue>(){

            @Override
            public MemcacheService.IdentifiableValue transform(MemcacheServicePb.MemcacheGetResponse response) {
                if (response.getItemCount() == 0) {
                    return null;
                }
                MemcacheServicePb.MemcacheGetResponse.Item item = response.getItem(0);
                return new IdentifiableValueImpl(AsyncMemcacheServiceImpl.this.deserializeItem(key, item), item.getCasId());
            }
        }, DefaultValueProviders.nullValue());
    }

    public <K> Future<Map<K, MemcacheService.IdentifiableValue>> getIdentifiables(Collection<K> keys) {
        return this.doGetAll(keys, true, "Memcache getIdentifiables: exception getting multiple keys", new MemcacheServiceApiHelper.Transformer<KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item>, MemcacheService.IdentifiableValue>(){

            @Override
            public MemcacheService.IdentifiableValue transform(KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item> pair) {
                MemcacheServicePb.MemcacheGetResponse.Item item = (MemcacheServicePb.MemcacheGetResponse.Item)pair.value;
                Object value = AsyncMemcacheServiceImpl.this.deserializeItem(pair.key, item);
                return new IdentifiableValueImpl(value, item.getCasId());
            }
        }, DefaultValueProviders.emptyMap());
    }

    public <K> Future<Map<K, Object>> getAll(Collection<K> keys) {
        return this.doGetAll(keys, false, "Memcache getAll: exception getting multiple keys", new MemcacheServiceApiHelper.Transformer<KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item>, Object>(){

            @Override
            public Object transform(KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item> pair) {
                return AsyncMemcacheServiceImpl.this.deserializeItem(pair.key, (MemcacheServicePb.MemcacheGetResponse.Item)pair.value);
            }
        }, DefaultValueProviders.emptyMap());
    }

    private <K, V> Future<Map<K, V>> doGetAll(Collection<K> keys, boolean forCas, String errorText, final MemcacheServiceApiHelper.Transformer<KeyValuePair<K, MemcacheServicePb.MemcacheGetResponse.Item>, V> responseTransfomer, MemcacheServiceApiHelper.Provider<Map<K, V>> defaultValue) {
        MemcacheServicePb.MemcacheGetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheGetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        final HashMap<ByteString, K> byteStringToKey = new HashMap<ByteString, K>(keys.size(), 1.0f);
        for (K key : keys) {
            ByteString pbKey = AsyncMemcacheServiceImpl.makePbKey(key);
            byteStringToKey.put(pbKey, key);
            requestBuilder.addKey(pbKey);
        }
        if (forCas) {
            requestBuilder.setForCas(forCas);
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Get", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheGetResponse.getDefaultInstance(), errorText, new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheGetResponse, Map<K, V>>(this){

            @Override
            public Map<K, V> transform(MemcacheServicePb.MemcacheGetResponse response) {
                HashMap result = new HashMap();
                for (MemcacheServicePb.MemcacheGetResponse.Item item : response.getItemList()) {
                    Object key = byteStringToKey.get(item.getKey());
                    Object obj = responseTransfomer.transform(KeyValuePair.of(key, item));
                    result.put(key, obj);
                }
                return result;
            }
        }), defaultValue);
    }

    private Future<Boolean> doPut(final Object key, MemcacheService.IdentifiableValue oldValue, Object value, Expiration expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy policy) {
        MemcacheServicePb.MemcacheSetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheSetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder = MemcacheServicePb.MemcacheSetRequest.Item.newBuilder();
        MemcacheSerialization.ValueAndFlags vaf = AsyncMemcacheServiceImpl.serializeValue(value);
        itemBuilder.setValue(ByteString.copyFrom(vaf.value));
        itemBuilder.setFlags(vaf.flags.ordinal());
        itemBuilder.setKey(AsyncMemcacheServiceImpl.makePbKey(key));
        itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
        itemBuilder.setSetPolicy(policy);
        if (policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS) {
            if (oldValue == null) {
                throw new IllegalArgumentException("oldValue must not be null.");
            }
            if (!(oldValue instanceof IdentifiableValueImpl)) {
                throw new IllegalArgumentException("oldValue is an instance of an unapproved IdentifiableValue implementation.  Perhaps you implemented your own version of IdentifiableValue?  If so, don't do this.");
            }
            itemBuilder.setCasId(((IdentifiableValueImpl)oldValue).getCasId());
        }
        final int itemSize = itemBuilder.getKey().size() + itemBuilder.getValue().size();
        requestBuilder.addItem(itemBuilder);
        String valueAsString = Ascii.truncate(String.valueOf(value), 100, "...");
        return MemcacheServiceApiHelper.makeAsyncCall("Set", requestBuilder.build(), this.createRpcResponseHandlerForPut(Arrays.asList(itemBuilder), requestBuilder.getNameSpace(), MemcacheServicePb.MemcacheSetResponse.getDefaultInstance(), String.format("Memcache put: exception setting 1 key (%s) to '%s'", key, valueAsString), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheSetResponse, Boolean>(this){

            @Override
            public Boolean transform(MemcacheServicePb.MemcacheSetResponse response) {
                if (response.getSetStatusCount() != 1) {
                    int n = response.getSetStatusCount();
                    throw new MemcacheServiceException(new StringBuilder(61).append("Memcache put: Set one item, got ").append(n).append(" response statuses").toString());
                }
                MemcacheServicePb.MemcacheSetResponse.SetStatusCode status = response.getSetStatus(0);
                if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR) {
                    if (itemSize > 1048503) {
                        throw new MemcacheServiceException(String.format("Memcache put: Item may not be more than %d bytes in length; received %d bytes.", 1048503, itemSize));
                    }
                    String string = String.valueOf(key);
                    throw new MemcacheServiceException(new StringBuilder(42 + String.valueOf(string).length()).append("Memcache put: Error setting single item (").append(string).append(")").toString());
                }
                return status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED;
            }
        }), DefaultValueProviders.falseValue());
    }

    private static MemcacheServicePb.MemcacheSetRequest.SetPolicy convertSetPolicyToPb(MemcacheService.SetPolicy policy) {
        switch (policy) {
            case SET_ALWAYS: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET;
            }
            case ADD_ONLY_IF_NOT_PRESENT: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.ADD;
            }
            case REPLACE_ONLY_IF_PRESENT: {
                return MemcacheServicePb.MemcacheSetRequest.SetPolicy.REPLACE;
            }
        }
        String string = String.valueOf((Object)policy);
        throw new IllegalArgumentException(new StringBuilder(16 + String.valueOf(string).length()).append("Unknown policy: ").append(string).toString());
    }

    @Override
    public Future<Boolean> put(Object key, Object value, Expiration expires, MemcacheService.SetPolicy policy) {
        return this.doPut(key, null, value, expires, AsyncMemcacheServiceImpl.convertSetPolicyToPb(policy));
    }

    @Override
    public Future<Void> put(Object key, Object value, Expiration expires) {
        return VoidFutureWrapper.wrap(this.doPut(key, null, value, expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET));
    }

    @Override
    public Future<Void> put(Object key, Object value) {
        return VoidFutureWrapper.wrap(this.doPut(key, null, value, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET));
    }

    @Override
    public Future<Boolean> putIfUntouched(Object key, MemcacheService.IdentifiableValue oldValue, Object newValue, Expiration expires) {
        return this.doPut(key, oldValue, newValue, expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS);
    }

    @Override
    public Future<Boolean> putIfUntouched(Object key, MemcacheService.IdentifiableValue oldValue, Object newValue) {
        return this.doPut(key, oldValue, newValue, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS);
    }

    @Override
    public <T> Future<Set<T>> putIfUntouched(Map<T, MemcacheService.CasValues> values) {
        return this.doPutAll(values, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS, "putIfUntouched");
    }

    @Override
    public <T> Future<Set<T>> putIfUntouched(Map<T, MemcacheService.CasValues> values, Expiration expiration) {
        return this.doPutAll(values, expiration, MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS, "putIfUntouched");
    }

    private <T> Future<Set<T>> doPutAll(Map<T, ?> values, Expiration expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy policy, String operation) {
        MemcacheServicePb.MemcacheSetRequest.Builder requestBuilder = MemcacheServicePb.MemcacheSetRequest.newBuilder();
        requestBuilder.setNameSpace(this.getEffectiveNamespace());
        final ArrayList<T> requestedKeys = new ArrayList<T>(values.size());
        HashSet<Integer> oversized = new HashSet<Integer>();
        int itemIndex = 0;
        for (Map.Entry<T, ?> entry : values.entrySet()) {
            MemcacheSerialization.ValueAndFlags vaf;
            MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder = MemcacheServicePb.MemcacheSetRequest.Item.newBuilder();
            requestedKeys.add(entry.getKey());
            itemBuilder.setKey(AsyncMemcacheServiceImpl.makePbKey(entry.getKey()));
            if (policy == MemcacheServicePb.MemcacheSetRequest.SetPolicy.CAS) {
                MemcacheService.CasValues value = (MemcacheService.CasValues)entry.getValue();
                if (value == null) {
                    String string = String.valueOf(entry.getKey());
                    throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string).length()).append(string).append(" has a null for CasValues").toString());
                }
                vaf = AsyncMemcacheServiceImpl.serializeValue(value.getNewValue());
                if (!(value.getOldValue() instanceof IdentifiableValueImpl)) {
                    String string = String.valueOf(entry.getKey());
                    throw new IllegalArgumentException(new StringBuilder(173 + String.valueOf(string).length()).append(string).append(" CasValues has an oldValue instance of an unapproved IdentifiableValue implementation.  Perhaps you implemented your own version of IdentifiableValue?  If so, don't do this.").toString());
                }
                itemBuilder.setCasId(((IdentifiableValueImpl)value.getOldValue()).getCasId());
                if (value.getExipration() != null) {
                    itemBuilder.setExpirationTime(value.getExipration().getSecondsValue());
                } else {
                    itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
                }
            } else {
                vaf = AsyncMemcacheServiceImpl.serializeValue(entry.getValue());
                itemBuilder.setExpirationTime(expires == null ? 0 : expires.getSecondsValue());
            }
            itemBuilder.setValue(ByteString.copyFrom(vaf.value));
            itemBuilder.setFlags(vaf.flags.ordinal());
            itemBuilder.setSetPolicy(policy);
            requestBuilder.addItem(itemBuilder);
            int itemSize = itemBuilder.getKey().size() + itemBuilder.getValue().size();
            if (itemSize > 1048503) {
                oversized.add(itemIndex);
            }
            ++itemIndex;
        }
        final HashSet oversizedFinal = new HashSet(oversized);
        int n = values.size();
        return MemcacheServiceApiHelper.makeAsyncCall("Set", requestBuilder.build(), this.createRpcResponseHandlerForPut(requestBuilder.getItemBuilderList(), requestBuilder.getNameSpace(), MemcacheServicePb.MemcacheSetResponse.getDefaultInstance(), new StringBuilder(53 + String.valueOf(operation).length()).append("Memcache ").append(operation).append(": Unknown exception setting ").append(n).append(" keys").toString(), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheSetResponse, Set<T>>(this){

            @Override
            public Set<T> transform(MemcacheServicePb.MemcacheSetResponse response) {
                if (response.getSetStatusCount() != requestedKeys.size()) {
                    throw new MemcacheServiceException(String.format("Memcache put: Set %d items, got %d response statuses", requestedKeys.size(), response.getSetStatusCount()));
                }
                HashSet result = new HashSet();
                HashSet sizeErrors = new HashSet();
                HashSet otherErrors = new HashSet();
                Iterator<MemcacheServicePb.MemcacheSetResponse.SetStatusCode> statusIter = response.getSetStatusList().iterator();
                int itemIndex = 0;
                for (Object requestedKey : requestedKeys) {
                    MemcacheServicePb.MemcacheSetResponse.SetStatusCode status = statusIter.next();
                    if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.ERROR) {
                        if (oversizedFinal.contains(itemIndex)) {
                            sizeErrors.add(requestedKey);
                        } else {
                            otherErrors.add(requestedKey);
                        }
                    } else if (status == MemcacheServicePb.MemcacheSetResponse.SetStatusCode.STORED) {
                        result.add(requestedKey);
                    }
                    ++itemIndex;
                }
                if (!sizeErrors.isEmpty() || !otherErrors.isEmpty()) {
                    StringBuilder builder = new StringBuilder("Memcache put: ");
                    if (!sizeErrors.isEmpty()) {
                        builder.append(sizeErrors.size());
                        builder.append(" items failed for exceeding ");
                        builder.append(1048503).append(" bytes; keys: ");
                        builder.append(Joiner.on(", ").join(sizeErrors));
                        builder.append(". ");
                    }
                    if (!otherErrors.isEmpty()) {
                        builder.append("Set failed to set ");
                        builder.append(otherErrors.size()).append(" keys: ");
                        builder.append(Joiner.on(", ").join(otherErrors));
                    }
                    throw new MemcacheServiceException(builder.toString());
                }
                return result;
            }
        }), DefaultValueProviders.emptySet());
    }

    @Override
    public <T> Future<Set<T>> putAll(Map<T, ?> values, Expiration expires, MemcacheService.SetPolicy policy) {
        return this.doPutAll(values, expires, AsyncMemcacheServiceImpl.convertSetPolicyToPb(policy), "putAll");
    }

    @Override
    public Future<Void> putAll(Map<?, ?> values, Expiration expires) {
        return VoidFutureWrapper.wrap(this.doPutAll(values, expires, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET, "putAll"));
    }

    @Override
    public Future<Void> putAll(Map<?, ?> values) {
        return VoidFutureWrapper.wrap(this.doPutAll(values, null, MemcacheServicePb.MemcacheSetRequest.SetPolicy.SET, "putAll"));
    }

    @Override
    public Future<Boolean> delete(Object key) {
        return this.delete(key, 0L);
    }

    @Override
    public Future<Boolean> delete(Object key, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteRequest request = MemcacheServicePb.MemcacheDeleteRequest.newBuilder().setNameSpace(this.getEffectiveNamespace()).addItem(MemcacheServicePb.MemcacheDeleteRequest.Item.newBuilder().setKey(AsyncMemcacheServiceImpl.makePbKey(key)).setDeleteTime((int)TimeUnit.SECONDS.convert(millisNoReAdd, TimeUnit.MILLISECONDS))).build();
        String string = String.valueOf(key);
        return MemcacheServiceApiHelper.makeAsyncCall("Delete", request, this.createRpcResponseHandler(MemcacheServicePb.MemcacheDeleteResponse.getDefaultInstance(), new StringBuilder(49 + String.valueOf(string).length()).append("Memcache delete: Unknown exception deleting key: ").append(string).toString(), new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheDeleteResponse, Boolean>(this){

            @Override
            public Boolean transform(MemcacheServicePb.MemcacheDeleteResponse response) {
                return response.getDeleteStatus(0) == MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED;
            }
        }), DefaultValueProviders.falseValue());
    }

    @Override
    public <T> Future<Set<T>> deleteAll(Collection<T> keys) {
        return this.deleteAll(keys, 0L);
    }

    @Override
    public <T> Future<Set<T>> deleteAll(Collection<T> keys, long millisNoReAdd) {
        MemcacheServicePb.MemcacheDeleteRequest.Builder requestBuilder = MemcacheServicePb.MemcacheDeleteRequest.newBuilder().setNameSpace(this.getEffectiveNamespace());
        final ArrayList<T> requestedKeys = new ArrayList<T>(keys.size());
        for (T key : keys) {
            requestedKeys.add(key);
            requestBuilder.addItem(MemcacheServicePb.MemcacheDeleteRequest.Item.newBuilder().setDeleteTime((int)(millisNoReAdd / 1000L)).setKey(AsyncMemcacheServiceImpl.makePbKey(key)));
        }
        return MemcacheServiceApiHelper.makeAsyncCall("Delete", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheDeleteResponse.getDefaultInstance(), "Memcache deleteAll: Unknown exception deleting multiple keys", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheDeleteResponse, Set<T>>(this){

            @Override
            public Set<T> transform(MemcacheServicePb.MemcacheDeleteResponse response) {
                LinkedHashSet retval = new LinkedHashSet();
                Iterator requestedKeysIter = requestedKeys.iterator();
                for (MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode deleteStatus : response.getDeleteStatusList()) {
                    Object requestedKey = requestedKeysIter.next();
                    if (deleteStatus != MemcacheServicePb.MemcacheDeleteResponse.DeleteStatusCode.DELETED) continue;
                    retval.add(requestedKey);
                }
                return retval;
            }
        }), DefaultValueProviders.emptySet());
    }

    private static MemcacheServicePb.MemcacheIncrementRequest.Builder newIncrementRequestBuilder(Object key, long delta, Long initialValue) {
        MemcacheServicePb.MemcacheIncrementRequest.Builder requestBuilder = MemcacheServicePb.MemcacheIncrementRequest.newBuilder();
        requestBuilder.setKey(AsyncMemcacheServiceImpl.makePbKey(key));
        if (delta > 0L) {
            requestBuilder.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.INCREMENT);
            requestBuilder.setDelta(delta);
        } else {
            requestBuilder.setDirection(MemcacheServicePb.MemcacheIncrementRequest.Direction.DECREMENT);
            requestBuilder.setDelta(-delta);
        }
        if (initialValue != null) {
            requestBuilder.setInitialValue(initialValue);
            requestBuilder.setInitialFlags(MemcacheSerialization.Flag.LONG.ordinal());
        }
        return requestBuilder;
    }

    @Override
    public Future<Long> increment(Object key, long delta) {
        return this.increment(key, delta, null);
    }

    @Override
    public Future<Long> increment(final Object key, long delta, Long initialValue) {
        MemcacheServicePb.MemcacheIncrementRequest request = AsyncMemcacheServiceImpl.newIncrementRequestBuilder(key, delta, initialValue).setNameSpace(this.getEffectiveNamespace()).build();
        String string = String.valueOf(key);
        return MemcacheServiceApiHelper.makeAsyncCall("Increment", request, new MemcacheServiceApiHelper.RpcResponseHandler<MemcacheServicePb.MemcacheIncrementResponse, Long>(this, MemcacheServicePb.MemcacheIncrementResponse.getDefaultInstance(), new StringBuilder(54 + String.valueOf(string).length()).append("Memcache increment: exception when incrementing key '").append(string).append("'").toString(), (MemcacheServiceApiHelper.Transformer)new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheIncrementResponse, Long>(this){

            @Override
            public Long transform(MemcacheServicePb.MemcacheIncrementResponse response) {
                return response.hasNewValue() ? Long.valueOf(response.getNewValue()) : null;
            }
        }, this.getErrorHandler()){

            @Override
            void handleApiProxyException(Throwable cause) throws Exception {
                if (cause instanceof ApiProxy.ApplicationException) {
                    ApiProxy.ApplicationException applicationException = (ApiProxy.ApplicationException)cause;
                    this.getLogger().info(applicationException.getErrorDetail());
                    if (applicationException.getApplicationError() == 6) {
                        String string = String.valueOf(key);
                        throw new InvalidValueException(new StringBuilder(34 + String.valueOf(string).length()).append("Non-incrementable value for key '").append(string).append("'").toString());
                    }
                }
                super.handleApiProxyException(cause);
            }
        }, DefaultValueProviders.nullValue());
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Collection<T> keys, long delta) {
        return this.incrementAll(keys, delta, null);
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Collection<T> keys, long delta, Long initialValue) {
        return this.incrementAll(AsyncMemcacheServiceImpl.makeMap(keys, delta), initialValue);
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Map<T, Long> offsets) {
        return this.incrementAll(offsets, null);
    }

    @Override
    public <T> Future<Map<T, Long>> incrementAll(Map<T, Long> offsets, Long initialValue) {
        MemcacheServicePb.MemcacheBatchIncrementRequest.Builder requestBuilder = MemcacheServicePb.MemcacheBatchIncrementRequest.newBuilder().setNameSpace(this.getEffectiveNamespace());
        final ArrayList<T> requestedKeys = new ArrayList<T>(offsets.size());
        for (Map.Entry<T, Long> entry : offsets.entrySet()) {
            requestedKeys.add(entry.getKey());
            requestBuilder.addItem(AsyncMemcacheServiceImpl.newIncrementRequestBuilder(entry.getKey(), entry.getValue(), initialValue));
        }
        return MemcacheServiceApiHelper.makeAsyncCall("BatchIncrement", requestBuilder.build(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheBatchIncrementResponse.getDefaultInstance(), "Memcache incrmentAll: exception incrementing multiple keys", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheBatchIncrementResponse, Map<T, Long>>(this){

            @Override
            public Map<T, Long> transform(MemcacheServicePb.MemcacheBatchIncrementResponse response) {
                LinkedHashMap result = new LinkedHashMap(requestedKeys.size(), 1.0f);
                Iterator<MemcacheServicePb.MemcacheIncrementResponse> items = response.getItemList().iterator();
                for (Object requestedKey : requestedKeys) {
                    MemcacheServicePb.MemcacheIncrementResponse item = items.next();
                    if (item.getIncrementStatus().equals(MemcacheServicePb.MemcacheIncrementResponse.IncrementStatusCode.OK) && item.hasNewValue()) {
                        result.put(requestedKey, item.getNewValue());
                        continue;
                    }
                    result.put(requestedKey, null);
                }
                return result;
            }
        }), new MemcacheServiceApiHelper.Provider<Map<T, Long>>(this){

            @Override
            public Map<T, Long> get() {
                return AsyncMemcacheServiceImpl.makeMap(requestedKeys, null);
            }
        });
    }

    @Override
    public Future<Void> clearAll() {
        return MemcacheServiceApiHelper.makeAsyncCall("FlushAll", MemcacheServicePb.MemcacheFlushRequest.getDefaultInstance(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheFlushResponse.getDefaultInstance(), "Memcache clearAll: exception", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheFlushResponse, Void>(this){

            @Override
            public Void transform(MemcacheServicePb.MemcacheFlushResponse response) {
                return null;
            }
        }), DefaultValueProviders.nullValue());
    }

    @Override
    public Future<Stats> getStatistics() {
        return MemcacheServiceApiHelper.makeAsyncCall("Stats", MemcacheServicePb.MemcacheStatsRequest.getDefaultInstance(), this.createRpcResponseHandler(MemcacheServicePb.MemcacheStatsResponse.getDefaultInstance(), "Memcache getStatistics: exception", new MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheStatsResponse, Stats>(this){

            @Override
            public Stats transform(MemcacheServicePb.MemcacheStatsResponse response) {
                return new StatsImpl(response.getStats());
            }
        }), DefaultValueProviders.emptyStats());
    }

    private class RpcResponseHandlerForPut<T>
    extends MemcacheServiceApiHelper.RpcResponseHandler<MemcacheServicePb.MemcacheSetResponse, T> {
        private final Iterable<MemcacheServicePb.MemcacheSetRequest.Item.Builder> itemsSentToBackend;
        private final String namespace;

        RpcResponseHandlerForPut(AsyncMemcacheServiceImpl asyncMemcacheServiceImpl, Iterable<MemcacheServicePb.MemcacheSetRequest.Item.Builder> itemsSentToBackend, String namespace, MemcacheServicePb.MemcacheSetResponse response, String errorText, MemcacheServiceApiHelper.Transformer<MemcacheServicePb.MemcacheSetResponse, T> responseTransfomer, ErrorHandler errorHandler) {
            super(response, errorText, responseTransfomer, errorHandler);
            this.itemsSentToBackend = itemsSentToBackend;
            this.namespace = namespace;
        }

        @Override
        void handleApiProxyException(Throwable cause) throws Exception {
            ErrorHandler errorHandler = this.getErrorHandler();
            if (cause instanceof ApiProxy.ApplicationException) {
                ApiProxy.ApplicationException applicationException = (ApiProxy.ApplicationException)cause;
                if (applicationException.getApplicationError() == 1) {
                    errorHandler = this.handleApiProxyException(applicationException.getErrorDetail(), errorHandler);
                }
            } else if (cause instanceof MemcacheServiceException) {
                errorHandler = this.handleApiProxyException(cause.getMessage(), errorHandler);
            }
            super.handleApiProxyException(cause, errorHandler);
        }

        private ErrorHandler handleApiProxyException(String msg, ErrorHandler errorHandler) throws MemcacheServiceException {
            boolean errorHandlerCalled = false;
            for (MemcacheServicePb.MemcacheSetRequest.Item.Builder itemBuilder : this.itemsSentToBackend) {
                ByteString pbKey = itemBuilder.getKey();
                ByteString value = itemBuilder.getValue();
                if (value.size() + pbKey.size() > 1048480) {
                    String string = String.valueOf(msg);
                    errorHandlerCalled |= this.maybeThrow(errorHandler, string.length() != 0 ? "Key+value is bigger than maximum allowed. ".concat(string) : new String("Key+value is bigger than maximum allowed. "));
                }
                if (Bytes.contains(pbKey.toByteArray(), (byte)0)) {
                    String string = String.valueOf(msg);
                    errorHandlerCalled |= this.maybeThrow(errorHandler, string.length() != 0 ? "Key contains embedded null byte. ".concat(string) : new String("Key contains embedded null byte. "));
                }
                if (this.namespace == null) continue;
                try {
                    NamespaceManager.validateNamespace(this.namespace);
                }
                catch (IllegalArgumentException ex) {
                    errorHandlerCalled |= this.maybeThrow(errorHandler, ex.toString());
                }
            }
            if (errorHandlerCalled) {
                if (errorHandler instanceof ConsistentErrorHandler) {
                    return DO_NOTHING_CONSISTENT_ERROR_HANDLER;
                }
                return DO_NOTHING_ERROR_HANDLER;
            }
            return errorHandler;
        }

        private boolean maybeThrow(ErrorHandler errorHandler, String msg) {
            errorHandler.handleServiceError(new MemcacheServiceException(msg));
            return true;
        }
    }

    private static final class KeyValuePair<K, V> {
        private final K key;
        private final V value;

        private KeyValuePair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        static <K, V> KeyValuePair<K, V> of(K key, V value) {
            return new KeyValuePair<K, V>(key, value);
        }
    }

    private static class VoidFutureWrapper<K>
    extends FutureWrapper<K, Void> {
        private VoidFutureWrapper(Future<K> parent) {
            super(parent);
        }

        private static <K> Future<Void> wrap(Future<K> parent) {
            return new VoidFutureWrapper<K>(parent);
        }

        @Override
        protected Void wrap(K value) {
            return null;
        }

        @Override
        protected Throwable convertException(Throwable cause) {
            return cause;
        }
    }

    private static class DefaultValueProviders {
        private static final MemcacheServiceApiHelper.Provider NULL_PROVIDER = new MemcacheServiceApiHelper.Provider(){

            public Object get() {
                return null;
            }
        };
        private static final MemcacheServiceApiHelper.Provider<Boolean> FALSE_PROVIDER = new MemcacheServiceApiHelper.Provider<Boolean>(){

            @Override
            public Boolean get() {
                return Boolean.FALSE;
            }
        };
        private static final MemcacheServiceApiHelper.Provider SET_PROVIDER = new MemcacheServiceApiHelper.Provider<Set<?>>(){

            @Override
            public Set<?> get() {
                return new HashSet(0, 1.0f);
            }
        };
        private static final MemcacheServiceApiHelper.Provider MAP_PROVIDER = new MemcacheServiceApiHelper.Provider<Map<?, ?>>(){

            @Override
            public Map<?, ?> get() {
                return new HashMap(0, 1.0f);
            }
        };
        private static final MemcacheServiceApiHelper.Provider<Stats> STATS_PROVIDER = new MemcacheServiceApiHelper.Provider<Stats>(){
            final Stats emptyStats = new StatsImpl(null);

            @Override
            public Stats get() {
                return this.emptyStats;
            }
        };

        private DefaultValueProviders() {
        }

        static MemcacheServiceApiHelper.Provider<Boolean> falseValue() {
            return FALSE_PROVIDER;
        }

        static <T> MemcacheServiceApiHelper.Provider<T> nullValue() {
            return NULL_PROVIDER;
        }

        static <T> MemcacheServiceApiHelper.Provider<Set<T>> emptySet() {
            return SET_PROVIDER;
        }

        static <K, V> MemcacheServiceApiHelper.Provider<Map<K, V>> emptyMap() {
            return MAP_PROVIDER;
        }

        static MemcacheServiceApiHelper.Provider<Stats> emptyStats() {
            return STATS_PROVIDER;
        }
    }

    static final class IdentifiableValueImpl
    implements MemcacheService.IdentifiableValue {
        private final Object value;
        private final long casId;

        IdentifiableValueImpl(Object value, long casId) {
            this.value = value;
            this.casId = casId;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        long getCasId() {
            return this.casId;
        }

        public boolean equals(Object otherObj) {
            if (this == otherObj) {
                return true;
            }
            if (otherObj == null || this.getClass() != otherObj.getClass()) {
                return false;
            }
            IdentifiableValueImpl otherIdentifiableValue = (IdentifiableValueImpl)otherObj;
            return Objects.equals(this.value, otherIdentifiableValue.value) && this.casId == otherIdentifiableValue.casId;
        }

        public int hashCode() {
            return Objects.hash(this.value, this.casId);
        }
    }

    static class StatsImpl
    implements Stats {
        private final long hits;
        private final long misses;
        private final long bytesFetched;
        private final long items;
        private final long bytesStored;
        private final int maxCachedTime;

        StatsImpl(MemcacheServicePb.MergedNamespaceStats stats) {
            if (stats != null) {
                this.hits = stats.getHits();
                this.misses = stats.getMisses();
                this.bytesFetched = stats.getByteHits();
                this.items = stats.getItems();
                this.bytesStored = stats.getBytes();
                this.maxCachedTime = stats.getOldestItemAge();
            } else {
                this.bytesStored = 0L;
                this.items = 0L;
                this.bytesFetched = 0L;
                this.misses = 0L;
                this.hits = 0L;
                this.maxCachedTime = 0;
            }
        }

        @Override
        public long getHitCount() {
            return this.hits;
        }

        @Override
        public long getMissCount() {
            return this.misses;
        }

        @Override
        public long getBytesReturnedForHits() {
            return this.bytesFetched;
        }

        @Override
        public long getItemCount() {
            return this.items;
        }

        @Override
        public long getTotalItemBytes() {
            return this.bytesStored;
        }

        @Override
        public int getMaxTimeWithoutAccess() {
            return this.maxCachedTime;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Hits: ").append(this.hits).append('\n');
            builder.append("Misses: ").append(this.misses).append('\n');
            builder.append("Bytes Fetched: ").append(this.bytesFetched).append('\n');
            builder.append("Bytes Stored: ").append(this.bytesStored).append('\n');
            builder.append("Items: ").append(this.items).append('\n');
            builder.append("Max Cached Time: ").append(this.maxCachedTime).append('\n');
            return builder.toString();
        }
    }
}

