/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.Cursor;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.FieldExpression;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.MatchScorer;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.Query;
import com.google.appengine.api.search.QueryOptions;
import com.google.appengine.api.search.RescoringMatchScorer;
import com.google.appengine.api.search.Results;
import com.google.appengine.api.search.ScoredDocument;
import com.google.appengine.api.search.SearchBaseException;
import com.google.appengine.api.search.SortExpression;
import com.google.appengine.api.search.SortOptions;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.gson.Gson;
import com.google.appengine.repackaged.com.google.gson.GsonBuilder;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializer;
import com.google.appengine.repackaged.com.google.gson.JsonElement;
import com.google.appengine.repackaged.com.google.gson.JsonParseException;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcHandler;
import com.google.apphosting.client.searchservice.app.InternalSearchApiUtils;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.cloudsearch.v1.FieldValue;
import com.google.cloudsearch.v1.FieldValueList;
import com.google.cloudsearch.v1.SearchRequest;
import com.google.cloudsearch.v1.SearchResponse;
import com.google.cloudsearch.v1.SearchResult;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SearchRpcHandler
extends CloudSearchRpcHandler<SearchRequest, SearchResponse> {
    private static final int DEFAULT_SEARCH_PAGE_SIZE = 10;
    private static final int DEFAULT_SEARCH_SCORER_SIZE = 100;
    private static final String DOCUMENT_ID_FIELD_NAME = "docId";
    private static final String RANK_FIELD_NAME = "rank";
    private static final String SCORE_FIELD_NAME = "score";
    private static final String MATCH_SCORER = "generic";
    private static final String RESCORING_MATCH_SCORER = "rescoring_match_scorer";
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)FieldExpression.class), new JsonDeserializer<FieldExpression>(){

        @Override
        public FieldExpression deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String name = json.getAsJsonObject().get("name").getAsString();
            String expression = json.getAsJsonObject().get("expression").getAsString();
            return FieldExpression.newBuilder().setName(name).setExpression(expression).build();
        }
    }).create();

    SearchRpcHandler() {
    }

    @Override
    public SearchResponse call(RpcHandler.CallOptions options, SearchRequest req) throws RpcException {
        SearchResponse.Builder respBuilder = SearchResponse.newBuilder();
        Index index = InternalSearchApiUtils.getIndex(req.getIndexId());
        try {
            Results<ScoredDocument> result = index.search(SearchRpcHandler.createQueryFromProto(req));
            SearchRpcHandler.buildSearchResponse(respBuilder, result, req.getReturnFieldsList());
        }
        catch (IllegalArgumentException e) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, e.getMessage());
        }
        catch (SearchBaseException e) {
            OperationResult opResult = e.getOperationResult();
            throw new RpcException(SearchRpcHandler.fromInternalCode(opResult.getCode()), MoreObjects.firstNonNull(e.getMessage(), ""));
        }
        catch (RuntimeException e) {
            throw new RpcException("internal search runtime error", e);
        }
        return respBuilder.build();
    }

    private static void buildSearchResponse(SearchResponse.Builder respBuilder, Results<ScoredDocument> result, List<String> returnFieldsList) throws RpcException {
        respBuilder.setMatchedCount(result.getNumberFound());
        for (ScoredDocument doc : result) {
            SearchResult.Builder searchResultBuilder = respBuilder.addResultsBuilder();
            SearchRpcHandler.addScoredDocument(searchResultBuilder, doc, returnFieldsList);
        }
    }

    private static Query createQueryFromProto(SearchRequest req) throws RpcException {
        QueryOptions.Builder queryOptionsBuilder = QueryOptions.newBuilder();
        queryOptionsBuilder.setLimit(req.getPageSize() == 0 ? 10 : req.getPageSize());
        if (req.getOffset() != 0) {
            if (!Strings.isNullOrEmpty(req.getPageToken())) {
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Cannot set both offset and page token in Search Request");
            }
            queryOptionsBuilder.setOffset(req.getOffset());
        }
        Cursor.Builder cursorBuilder = Cursor.newBuilder().setPerResult(true);
        if (!Strings.isNullOrEmpty(req.getPageToken())) {
            queryOptionsBuilder.setCursor(cursorBuilder.build(req.getPageToken()));
        } else {
            queryOptionsBuilder.setCursor(cursorBuilder.build());
        }
        if (req.getMatchedCountAccuracy() != 0) {
            queryOptionsBuilder.setNumberFoundAccuracy(req.getMatchedCountAccuracy());
        }
        HashMap<String, String> fieldExpressionMap = Maps.newHashMap();
        for (String[] fieldExpressionEntry : req.getFieldExpressionsList()) {
            SearchRpcHandler.parseFieldExpression(fieldExpressionMap, fieldExpressionEntry.trim());
        }
        SortOptions.Builder sortOptionsBuilder = SortOptions.newBuilder();
        if (!Strings.isNullOrEmpty(req.getOrderBy())) {
            for (String orderByString : req.getOrderBy().split(",")) {
                SortExpression.Builder sortExpressionBuilder = SortExpression.newBuilder();
                SearchRpcHandler.parseOrderByString(sortExpressionBuilder, orderByString.trim());
                SearchRpcHandler.parseOrderByFieldExpression(sortExpressionBuilder, fieldExpressionMap);
                SearchRpcHandler.parseOrderBySpecialFields(sortExpressionBuilder, !Strings.isNullOrEmpty(req.getScorer()));
                sortOptionsBuilder.addSortExpression(sortExpressionBuilder);
            }
        }
        if (!Strings.isNullOrEmpty(req.getScorer())) {
            String scorer = req.getScorer();
            if (scorer.equals(MATCH_SCORER)) {
                sortOptionsBuilder.setMatchScorer(MatchScorer.newBuilder());
            } else if (scorer.equals(RESCORING_MATCH_SCORER)) {
                sortOptionsBuilder.setMatchScorer(RescoringMatchScorer.newBuilder());
            } else {
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, new StringBuilder(25 + String.valueOf(scorer).length()).append("Scorer ").append(scorer).append(" is not available.").toString());
            }
            sortOptionsBuilder.setLimit(req.getScorerSize() == 0 ? 100 : req.getScorerSize());
        } else {
            if (req.getScorerSize() != 0) {
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Scorer limit requires scoring.");
            }
            if (req.getReturnFieldsList().contains(SCORE_FIELD_NAME)) {
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Return score field requires scoring.");
            }
        }
        if (!Strings.isNullOrEmpty(req.getOrderBy()) || !Strings.isNullOrEmpty(req.getScorer())) {
            queryOptionsBuilder.setSortOptions(sortOptionsBuilder.build());
        }
        if (!SearchRpcHandler.isReturnAllFields(req.getReturnFieldsList())) {
            ArrayList<String> fieldsList = new ArrayList<String>();
            for (String field : req.getReturnFieldsList()) {
                if (fieldExpressionMap.containsKey(field)) continue;
                fieldsList.add(field);
            }
            if (!fieldsList.isEmpty()) {
                queryOptionsBuilder.setFieldsToReturn(fieldsList.toArray(new String[fieldsList.size()]));
            }
        }
        for (String field : req.getReturnFieldsList()) {
            if (!fieldExpressionMap.containsKey(field)) continue;
            queryOptionsBuilder.addExpressionToReturn(FieldExpression.newBuilder().setName(field).setExpression((String)fieldExpressionMap.get(field)));
        }
        if (req.getReturnFieldsCount() == 0) {
            queryOptionsBuilder.setReturningIdsOnly(true);
        }
        return Query.newBuilder().setOptions(queryOptionsBuilder).build(MoreObjects.firstNonNull(req.getQuery(), ""));
    }

    private static boolean isReturnAllFields(List<String> field) {
        for (String fieldName : field) {
            if (!fieldName.equals("*")) continue;
            return true;
        }
        return false;
    }

    private static void parseFieldExpression(Map<String, String> fieldExpressionMap, String fieldExpressionEntry) throws RpcException {
        FieldExpression fieldExpression = null;
        try {
            fieldExpression = GSON.fromJson(fieldExpressionEntry, FieldExpression.class);
        }
        catch (JsonParseException e) {
            String string = String.valueOf(e.getMessage());
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, new StringBuilder(44 + String.valueOf(fieldExpressionEntry).length() + String.valueOf(string).length()).append("Parsing fieldExpression ").append(fieldExpressionEntry).append(" failed with error: ").append(string).toString());
        }
        Preconditions.checkArgument(fieldExpression.getName() != null && !fieldExpression.getName().isEmpty(), "Field expression must contain name");
        Preconditions.checkArgument(fieldExpression.getExpression() != null && !fieldExpression.getExpression().isEmpty(), "Field expression must contain expression");
        if (fieldExpressionMap.put(fieldExpression.getName(), fieldExpression.getExpression()) != null) {
            String string = String.valueOf(fieldExpressionEntry);
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, string.length() != 0 ? "Duplicate field expression name: ".concat(string) : new String("Duplicate field expression name: "));
        }
    }

    private static void parseOrderByString(SortExpression.Builder expressionBuilder, String orderByString) {
        if (orderByString.contains(" ")) {
            String[] parts = orderByString.split(" ");
            expressionBuilder.setExpression(parts[0].trim());
            if (parts[1].trim().equals("desc")) {
                expressionBuilder.setDirection(SortExpression.SortDirection.DESCENDING);
            } else {
                expressionBuilder.setDirection(SortExpression.SortDirection.ASCENDING);
            }
        } else {
            expressionBuilder.setExpression(orderByString);
            expressionBuilder.setDirection(SortExpression.SortDirection.ASCENDING);
        }
    }

    private static void parseOrderByFieldExpression(SortExpression.Builder expressionBuilder, Map<String, String> fieldExpressionMap) {
        String expression = expressionBuilder.build().getExpression();
        if (fieldExpressionMap.containsKey(expression)) {
            expressionBuilder.setExpression(fieldExpressionMap.get(expression));
        }
    }

    private static void parseOrderBySpecialFields(SortExpression.Builder expressionBuilder, boolean hasScorer) throws RpcException {
        String expression = expressionBuilder.build().getExpression();
        if (expression.equals(DOCUMENT_ID_FIELD_NAME)) {
            expressionBuilder.setExpression("_doc_id");
        } else if (expression.equals(RANK_FIELD_NAME)) {
            expressionBuilder.setExpression("_rank");
        } else if (expression.equals(SCORE_FIELD_NAME)) {
            if (!hasScorer) {
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Sort by score field requires scoring.");
            }
            expressionBuilder.setExpression("_score");
        }
    }

    private static void addScoredDocument(SearchResult.Builder respDocBuilder, ScoredDocument internDoc, List<String> returnFieldsList) throws RpcException {
        FieldValueList.Builder fieldValueListBuilder;
        respDocBuilder.setDocId(internDoc.getId());
        Cursor cursor = internDoc.getCursor();
        if (cursor != null) {
            respDocBuilder.setNextPageToken(cursor.toWebSafeString());
        }
        boolean returnAllFields = SearchRpcHandler.isReturnAllFields(returnFieldsList);
        Map<String, FieldValueList> responseFieldMap = respDocBuilder.getMutableFields();
        for (String fieldName : internDoc.getFieldNames()) {
            if (!returnFieldsList.contains(fieldName) && !returnAllFields) continue;
            fieldValueListBuilder = FieldValueList.newBuilder();
            for (Field field : internDoc.getFields(fieldName)) {
                InternalSearchApiUtils.addDocumentField(fieldValueListBuilder, field, fieldName);
            }
            responseFieldMap.put(fieldName, fieldValueListBuilder.build());
        }
        for (Field field : internDoc.getExpressions()) {
            fieldValueListBuilder = FieldValueList.newBuilder();
            if (responseFieldMap.containsKey(field.getName())) {
                fieldValueListBuilder.mergeFrom(responseFieldMap.get(field.getName()));
            }
            InternalSearchApiUtils.addDocumentField(fieldValueListBuilder, field, field.getName());
            responseFieldMap.put(field.getName(), fieldValueListBuilder.build());
        }
        for (String fieldName : returnFieldsList) {
            if (fieldName.equals(RANK_FIELD_NAME)) {
                responseFieldMap.put(RANK_FIELD_NAME, FieldValueList.newBuilder().addValues(FieldValue.newBuilder().setNumberValue(internDoc.getRank()).build()).build());
                continue;
            }
            if (!fieldName.equals(SCORE_FIELD_NAME)) continue;
            if (internDoc.getSortScores() == null || internDoc.getSortScores().isEmpty()) {
                throw new RpcException(Codes.Code.INTERNAL, "Document score not set.");
            }
            responseFieldMap.put(SCORE_FIELD_NAME, FieldValueList.newBuilder().addValues(FieldValue.newBuilder().setNumberValue(Iterables.getOnlyElement(internDoc.getSortScores())).build()).build());
        }
    }

    @Override
    public Parser<SearchRequest> getParser() {
        return SearchRequest.PARSER;
    }

    @Override
    public Class<SearchRequest> getRequestClass() {
        return SearchRequest.class;
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(SearchRequest request) {
        return RpcHandler.RequestPermissions.READ;
    }
}

