/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.GetException;
import com.google.appengine.api.search.GetRequest;
import com.google.appengine.api.search.GetResponse;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcHandler;
import com.google.apphosting.client.searchservice.app.InternalSearchApiUtils;
import com.google.apphosting.client.searchservice.proto.CursorInternal;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.cloudsearch.v1.ListDocumentsRequest;
import com.google.cloudsearch.v1.ListDocumentsResponse;
import java.util.Iterator;

class ListDocumentsRpcHandler
extends CloudSearchRpcHandler<ListDocumentsRequest, ListDocumentsResponse> {
    private static final int DEFAULT_LISTDOCUMENTS_PAGE_SIZE = 100;

    ListDocumentsRpcHandler() {
    }

    @Override
    public ListDocumentsResponse call(RpcHandler.CallOptions options, ListDocumentsRequest req) throws RpcException {
        ListDocumentsResponse.Builder respBuilder = ListDocumentsResponse.newBuilder();
        Index index = InternalSearchApiUtils.getIndex(req.getIndexId());
        try {
            GetRequest getRequest = this.createGetRequestFromProto(req);
            GetResponse<Document> getResponse = index.getRange(getRequest);
            if (getResponse == null) {
                String string = String.valueOf(getRequest.toString());
                throw new RpcException(Codes.Code.INTERNAL, string.length() != 0 ? "getResponse returned null with request: ".concat(string) : new String("getResponse returned null with request: "));
            }
            Document lastDoc = null;
            Iterator<Document> iterator = getResponse.getResults().iterator();
            while (iterator.hasNext()) {
                Document doc;
                lastDoc = doc = iterator.next();
                InternalSearchApiUtils.setIndexedDocument(respBuilder.addDocumentsBuilder(), doc);
            }
            if (lastDoc != null) {
                this.setCursor(respBuilder, lastDoc.getId());
            }
        }
        catch (IllegalArgumentException e) {
            String string = String.valueOf(e.getMessage());
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, string.length() != 0 ? "Invalid ListDocuments Request: ".concat(string) : new String("Invalid ListDocuments Request: "));
        }
        catch (GetException e) {
            OperationResult opResult = e.getOperationResult();
            throw new RpcException(ListDocumentsRpcHandler.fromInternalCode(opResult.getCode()), MoreObjects.firstNonNull(opResult.getMessage(), ""));
        }
        return respBuilder.build();
    }

    private GetRequest createGetRequestFromProto(ListDocumentsRequest req) throws RpcException {
        GetRequest.Builder getRequestBuilder = GetRequest.newBuilder();
        getRequestBuilder.setLimit(req.getPageSize() == 0 ? 100 : req.getPageSize());
        getRequestBuilder.setReturningIdsOnly(req.getView() == ListDocumentsRequest.DocumentView.DOCUMENT_VIEW_UNSPECIFIED || req.getView() == ListDocumentsRequest.DocumentView.ID_ONLY);
        if (!Strings.isNullOrEmpty(req.getPageToken())) {
            getRequestBuilder.setIncludeStart(false);
            this.setStartId(getRequestBuilder, req.getPageToken());
        }
        return getRequestBuilder.build();
    }

    private void setCursor(ListDocumentsResponse.Builder respBuilder, String docId) {
        CursorInternal.ListDocumentsCursor.Builder cursorBuilder = CursorInternal.ListDocumentsCursor.newBuilder();
        cursorBuilder.setCursor(docId);
        String encodedCursor = InternalSearchApiUtils.encodeBytes(cursorBuilder.build().toByteArray());
        respBuilder.setNextPageToken(encodedCursor);
    }

    private void setStartId(GetRequest.Builder getRequestBuilder, String encodedCursor) throws RpcException {
        byte[] decodedCursor = InternalSearchApiUtils.decodeBytes(encodedCursor);
        CursorInternal.ListDocumentsCursor.Builder cursorBuilder = CursorInternal.ListDocumentsCursor.newBuilder();
        try {
            cursorBuilder.mergeFrom(decodedCursor);
            CursorInternal.ListDocumentsCursor cursor = cursorBuilder.build();
            getRequestBuilder.setStartId(cursor.getCursor());
        }
        catch (InvalidProtocolBufferException e2) {
            String string = String.valueOf(encodedCursor);
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, string.length() != 0 ? "Invalid ListDocumentsCursor: ".concat(string) : new String("Invalid ListDocumentsCursor: "));
        }
    }

    @Override
    public Parser<ListDocumentsRequest> getParser() {
        return ListDocumentsRequest.PARSER;
    }

    @Override
    public Class<ListDocumentsRequest> getRequestClass() {
        return ListDocumentsRequest.class;
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(ListDocumentsRequest request) {
        return RpcHandler.RequestPermissions.READ;
    }
}

