/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.searchservice.app;

import com.google.appengine.api.search.Document;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.GeoPoint;
import com.google.appengine.api.search.Index;
import com.google.appengine.api.search.OperationResult;
import com.google.appengine.api.search.PutException;
import com.google.appengine.api.search.PutResponse;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.repackaged.com.google.common.base.MoreObjects;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.Parser;
import com.google.apphosting.client.searchservice.app.CloudSearchRpcHandler;
import com.google.apphosting.client.searchservice.app.InternalSearchApiUtils;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import com.google.cloudsearch.v1.CreateDocumentRequest;
import com.google.cloudsearch.v1.Document;
import com.google.cloudsearch.v1.FieldValue;
import com.google.cloudsearch.v1.FieldValueList;
import java.util.Date;
import java.util.Map;

class CreateDocumentRpcHandler
extends CloudSearchRpcHandler<CreateDocumentRequest, Document> {
    private static final ImmutableList<String> HTML_TAGS = ImmutableList.of("<!DOCTYPE html>", "<html>", "<head>", "<body>", "<h1>", "<title>");

    CreateDocumentRpcHandler() {
    }

    @Override
    public Document call(RpcHandler.CallOptions options, CreateDocumentRequest req) throws RpcException {
        Document.Builder respBuilder = Document.newBuilder();
        Document inputDoc = req.getDocument();
        CreateDocumentRpcHandler.validateDocumentInput(inputDoc);
        Index index = InternalSearchApiUtils.getIndex(req.getIndexId());
        try {
            PutResponse putResponse = index.put(this.createDocumentFromProto(inputDoc));
            respBuilder.setDocId(Iterables.getOnlyElement(putResponse.getIds()));
        }
        catch (IllegalArgumentException e) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, e.getMessage());
        }
        catch (PutException e) {
            OperationResult opResult = e.getOperationResult();
            throw new RpcException(CreateDocumentRpcHandler.fromInternalCode(opResult.getCode()), MoreObjects.firstNonNull(opResult.getMessage(), ""));
        }
        return respBuilder.build();
    }

    private com.google.appengine.api.search.Document createDocumentFromProto(Document inputDoc) throws RpcException {
        Document.Builder docBuilder = com.google.appengine.api.search.Document.newBuilder();
        if (!Strings.isNullOrEmpty(inputDoc.getDocId())) {
            docBuilder.setId(inputDoc.getDocId());
        }
        if (inputDoc.getRank() > 0) {
            docBuilder.setRank(inputDoc.getRank());
        }
        for (Map.Entry<String, FieldValueList> field : inputDoc.getFields().entrySet()) {
            for (FieldValue fieldValue : field.getValue().getValuesList()) {
                docBuilder.addField(this.createFieldFromProto(field.getKey(), fieldValue));
            }
        }
        return docBuilder.build();
    }

    private boolean checkForHTML(String stringValue) {
        for (String tag : HTML_TAGS) {
            if (!stringValue.contains(tag)) continue;
            return true;
        }
        return false;
    }

    private Field createFieldFromProto(String fieldName, FieldValue fieldValue) throws RpcException {
        Field.Builder fieldBuilder = Field.newBuilder().setName(fieldName);
        switch (fieldValue.getValueCase()) {
            case STRING_VALUE: {
                switch (fieldValue.getStringFormat()) {
                    case DEFAULT: {
                        if (this.checkForHTML(fieldValue.getStringValue())) {
                            fieldBuilder.setHTML(fieldValue.getStringValue());
                            break;
                        }
                        fieldBuilder.setText(fieldValue.getStringValue());
                        break;
                    }
                    case ATOM: {
                        fieldBuilder.setAtom(fieldValue.getStringValue());
                        break;
                    }
                    case TEXT: {
                        fieldBuilder.setText(fieldValue.getStringValue());
                        break;
                    }
                    case HTML: {
                        fieldBuilder.setHTML(fieldValue.getStringValue());
                        break;
                    }
                    default: {
                        String string = String.valueOf(fieldValue.getStringFormat());
                        throw new RpcException(Codes.Code.INTERNAL, new StringBuilder(37 + String.valueOf(string).length()).append("unrecognized field string tokenizer: ").append(string).toString());
                    }
                }
                if (Strings.isNullOrEmpty(fieldValue.getLang())) break;
                fieldBuilder.setLocale(FieldChecker.parseLocale(fieldValue.getLang()));
                break;
            }
            case TIMESTAMP_VALUE: {
                fieldBuilder.setDate(new Date(InternalSearchApiUtils.toMillisecondsSinceEpoch(fieldValue.getTimestampValue())));
                break;
            }
            case NUMBER_VALUE: {
                fieldBuilder.setNumber(fieldValue.getNumberValue());
                break;
            }
            case GEO_VALUE: {
                fieldBuilder.setGeoPoint(CreateDocumentRpcHandler.getGeoPointFromString(fieldValue.getGeoValue()));
                break;
            }
            default: {
                String string = String.valueOf(fieldValue.getValueCase());
                throw new RpcException(Codes.Code.INVALID_ARGUMENT, new StringBuilder(25 + String.valueOf(string).length()).append("unrecognized field type: ").append(string).toString());
            }
        }
        return fieldBuilder.build();
    }

    private static GeoPoint getGeoPointFromString(String geoValueString) {
        String[] values = geoValueString.split("\\s*,\\s*");
        double latitude = Double.parseDouble(values[0]);
        double longitude = Double.parseDouble(values[1]);
        return new GeoPoint(latitude, longitude);
    }

    private static void validateDocumentInput(Document doc) throws RpcException {
        CreateDocumentRpcHandler.checkUTF8ByteString(doc.getDocIdBytes(), "Invalid UTF8 in document id", new Object[0]);
        String docId = doc.getDocId();
        for (Map.Entry<String, FieldValueList> field : doc.getFields().entrySet()) {
            CreateDocumentRpcHandler.checkUTF8ByteString(ByteString.copyFromUtf8(field.getKey()), "Invalid UTF8 in a field name of document %s", docId);
            for (FieldValue fieldValue : field.getValue().getValuesList()) {
                if (fieldValue.getValueCase() == FieldValue.ValueCase.STRING_VALUE) {
                    CreateDocumentRpcHandler.checkUTF8ByteString(fieldValue.getStringValueBytes(), "Invalid UTF8 in string value of field %s document %s", field.getKey(), docId);
                }
                CreateDocumentRpcHandler.checkUTF8ByteString(fieldValue.getLangBytes(), "Invalid UTF8 in language of field %s document %s", field.getKey(), docId);
            }
        }
    }

    private static void checkUTF8ByteString(ByteString utf8, String message, Object ... messageArgs) throws RpcException {
        if (!utf8.isValidUtf8()) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, String.format(message, messageArgs));
        }
    }

    @Override
    public Parser<CreateDocumentRequest> getParser() {
        return CreateDocumentRequest.PARSER;
    }

    @Override
    public Class<CreateDocumentRequest> getRequestClass() {
        return CreateDocumentRequest.class;
    }

    @Override
    public RpcHandler.RequestPermissions getRequiredPermissions(CreateDocumentRequest request) {
        return RpcHandler.RequestPermissions.READ_WRITE;
    }
}

