/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.apphosting.client.datastoreservice.app.EntityTranslator;
import com.google.apphosting.client.datastoreservice.app.QueryV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.mobile.MobileEntityV4Normalizer;
import com.google.apphosting.client.datastoreservice.app.mobile.RunQueryHandler;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.datastore.DatastoreV4;
import com.google.apphosting.datastore.EntityV4;

class MobileV4NormAuthenticator {
    private final MobileEntityV4Normalizer entityNormalizer;
    private final QueryV4Normalizer queryNormalizer;
    private final EntityTranslator.Format inputFormat;
    private static final String ERROR_MESSAGE_INVALID_QUERY = "Incorrect query format";
    private static final String ERROR_MESSAGE_INVALID_MUTATION = "Incorrect mutation format";

    public MobileV4NormAuthenticator(MobileEntityV4Normalizer entityNormalizer, EntityTranslator.Format inputFormat) {
        this.entityNormalizer = entityNormalizer;
        this.queryNormalizer = new QueryV4Normalizer(entityNormalizer);
        this.inputFormat = inputFormat;
    }

    public DatastoreMobileService.CommitRequest normalizeAndAuthenticateCommitRequest(DatastoreMobileService.CommitRequest commitRequest) throws RpcException {
        DatastoreMobileService.CommitRequest.Builder builder = commitRequest.toBuilder().clearMutation();
        if (builder.hasReceiptEntity()) {
            builder.setReceiptEntity(this.entityNormalizer.normalizeEntity(builder.getReceiptEntity(), this.inputFormat));
            this.authenticateAccess(builder.getReceiptEntityOrBuilder().getKey());
        }
        for (DatastoreMobileService.Mutation mutation : commitRequest.getMutationList()) {
            builder.addMutation(this.normalizeAndAuthenticateMutation(mutation));
        }
        return builder.build();
    }

    private DatastoreMobileService.Mutation normalizeAndAuthenticateMutation(DatastoreMobileService.Mutation mutation) throws RpcException {
        if (mutation.hasKey()) {
            EntityV4.Key key = this.entityNormalizer.normalizeKey(mutation.getKey());
            this.authenticateAccess(key);
            if (key != mutation.getKey()) {
                return mutation.toBuilder().setKey(key).build();
            }
            return mutation;
        }
        if (mutation.hasEntity()) {
            EntityV4.Entity entity = this.entityNormalizer.normalizeEntity(mutation.getEntity(), this.inputFormat);
            this.authenticateAccess(entity.getKey());
            if (entity != mutation.getEntity()) {
                return mutation.toBuilder().setEntity(entity).build();
            }
            return mutation;
        }
        throw new RpcException(Codes.Code.PERMISSION_DENIED, ERROR_MESSAGE_INVALID_MUTATION);
    }

    public DatastoreV4.RunQueryRequest normalizeAndAuthenticateRunQueryRequest(DatastoreMobileService.RunQueryRequest req) throws RpcException {
        DatastoreV4.RunQueryRequest normV4Query = this.queryNormalizer.toV4RunQueryRequest(RunQueryHandler.toDatastoreServiceRunQueryRequest(req));
        this.authenticateAccess(normV4Query.getQuery());
        return normV4Query;
    }

    private void authenticateAccess(DatastoreV4.Query query) throws RpcException {
        DatastoreV4.CompositeFilter compFilter;
        if (!query.hasFilter()) {
            throw new RpcException(Codes.Code.PERMISSION_DENIED, ERROR_MESSAGE_INVALID_QUERY);
        }
        DatastoreV4.Filter filter = query.getFilter();
        if (filter.hasPropertyFilter()) {
            this.authenticateEntityGroupAccess(filter.getPropertyFilter());
            return;
        }
        if (filter.hasCompositeFilter() && (compFilter = filter.getCompositeFilter()).getOperator() == DatastoreV4.CompositeFilter.Operator.AND && compFilter.getFilterCount() != 0 && compFilter.getFilter(0).hasPropertyFilter()) {
            this.authenticateEntityGroupAccess(compFilter.getFilter(0).getPropertyFilter());
            return;
        }
        throw new RpcException(Codes.Code.PERMISSION_DENIED, ERROR_MESSAGE_INVALID_QUERY);
    }

    private void authenticateEntityGroupAccess(DatastoreV4.PropertyFilter propFilter) throws RpcException {
        if (propFilter.getOperator() == DatastoreV4.PropertyFilter.Operator.HAS_ANCESTOR && propFilter.getProperty().getName().equals("__key__") && propFilter.getValue().hasKeyValue()) {
            this.authenticateAccess(propFilter.getValue().getKeyValue());
            return;
        }
        throw new RpcException(Codes.Code.PERMISSION_DENIED, ERROR_MESSAGE_INVALID_QUERY);
    }

    private void authenticateAccess(EntityV4.Key normKey) throws RpcException {
        if (normKey == null || normKey.getPathElementCount() == 0) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Empty key or empty path element in the key");
        }
        EntityV4.Key.PathElement root = normKey.getPathElement(0);
        if (root.getKind().equals("__gcd_user") && root.getName().equals(this.entityNormalizer.getFullUserId())) {
            return;
        }
        String string = String.valueOf(normKey.toString());
        throw new RpcException(Codes.Code.PERMISSION_DENIED, string.length() != 0 ? "Invalid key: ".concat(string) : new String("Invalid key: "));
    }
}

