/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.api.client.extensions.appengine.http.UrlFetchTransport;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.security.GeneralSecurityException;

public class IdTokenAuthenticator {
    private static final String PUBLIC_CERT_URL = "https://www.googleapis.com/service_accounts/v1/metadata/x509/api-signer@system.gserviceaccount.com";
    private static final String ISSUER = "https://www.googleapis.com";
    static final String REQUEST_USER_CREDENTIAL_KEY = "com.google.apphosting.client.datastoreservice.app.mobile.request_user_credential";
    private GoogleIdTokenVerifier apiaryTokenVerifier;
    private GoogleIdTokenVerifier googleTokenVerifier;

    public IdTokenAuthenticator() {
        UrlFetchTransport transport = new UrlFetchTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        GooglePublicKeysManager keyManager = new GooglePublicKeysManager.Builder(transport, jsonFactory).setPublicCertsEncodedUrl(PUBLIC_CERT_URL).build();
        this.apiaryTokenVerifier = new GoogleIdTokenVerifier.Builder(keyManager).setIssuer(ISSUER).build();
        this.googleTokenVerifier = new GoogleIdTokenVerifier.Builder(transport, jsonFactory).build();
    }

    public void authenticate(String peerAuthorizationToken, String authorizationToken) throws GeneralSecurityException, IOException {
        if (peerAuthorizationToken == null || authorizationToken == null) {
            throw new GeneralSecurityException("NULL ID TOKEN PROVIDED");
        }
        GoogleIdToken token = this.googleTokenVerifier.verify(authorizationToken);
        String issuer = token.getPayload().getIssuer();
        String userId = token.getPayload().getSubject();
        if (issuer == null || userId == null) {
            throw new GeneralSecurityException("EITHER USER ID OR ISSUER IN ID TOKEN IS NULL");
        }
        String fullUserId = new StringBuilder(1 + String.valueOf(issuer).length() + String.valueOf(userId).length()).append(issuer).append("|").append(userId).toString();
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            return;
        }
        GoogleIdToken apiaryIdToken = this.apiaryTokenVerifier.verify(peerAuthorizationToken);
        String projectId = (String)apiaryIdToken.getPayload().getAudience();
        if (projectId == null) {
            throw new GeneralSecurityException("NULL PROJECT ID");
        }
        environment.getAttributes().put(REQUEST_USER_CREDENTIAL_KEY, new UserCredential(projectId, fullUserId));
    }

    @VisibleForTesting
    public IdTokenAuthenticator(GoogleIdTokenVerifier apiaryTokenVerifier, GoogleIdTokenVerifier googleTokenVerifier) {
        this.apiaryTokenVerifier = apiaryTokenVerifier;
        this.googleTokenVerifier = googleTokenVerifier;
    }

    public String getProjectId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            return null;
        }
        UserCredential userCredential = (UserCredential)environment.getAttributes().get(REQUEST_USER_CREDENTIAL_KEY);
        if (userCredential == null) {
            return null;
        }
        return userCredential.getProjectId();
    }

    public String getFullUserId() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            return null;
        }
        UserCredential userCredential = (UserCredential)environment.getAttributes().get(REQUEST_USER_CREDENTIAL_KEY);
        if (userCredential == null) {
            return null;
        }
        return userCredential.getFullUserId();
    }

    static class UserCredential {
        private String projectId;
        private String fullUserId;

        UserCredential(String projectId, String fullUserId) {
            this.projectId = projectId;
            this.fullUserId = fullUserId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getFullUserId() {
            return this.fullUserId;
        }
    }
}

