/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.datastore.EntityV4;
import java.util.HashSet;

class DatastoreMobileValidator {
    public static final DatastoreMobileValidator DEFAULT = new DatastoreMobileValidator();

    DatastoreMobileValidator() {
    }

    public void validateCommitRequest(DatastoreMobileService.CommitRequest req) throws RpcException {
        this.validateAssertion(req.getMode() == DatastoreMobileService.CommitRequest.Mode.NON_TRANSACTIONAL, "Commit request mode not set to NON_TRANSACTIONAL");
        if (req.hasReceiptEntity()) {
            this.validateReceiptEntity(req.getReceiptEntity());
        }
        HashSet<EntityV4.Key> keys = Sets.newHashSet();
        for (int i = 0; i < req.getMutationCount(); ++i) {
            EntityV4.Key key;
            DatastoreMobileService.Mutation mutation = req.getMutation(i);
            int n = i;
            String name = new StringBuilder(22).append("mutation[").append(n).append("] ").toString();
            this.validateAssertion(mutation.getResolveConflict(), String.valueOf(name).concat(" does not specify resolveConflict."));
            this.validateAssertion(!mutation.hasKey() || !mutation.getEntity().hasKey(), String.valueOf(name).concat(" specifies key and entity key."));
            this.validateAssertion(!mutation.getRule().getUnknownFields().hasField(1), String.valueOf(name).concat("contains rule with unknown policy."));
            switch (mutation.getOp()) {
                case UPSERT: {
                    this.validateAssertion(mutation.getEntity().hasKey(), String.valueOf(name).concat(" does not have a key."));
                    key = mutation.getEntity().getKey();
                    break;
                }
                case DELETE: {
                    this.validateAssertion(mutation.hasKey(), String.valueOf(name).concat(" does not have a key."));
                    key = mutation.getKey();
                    break;
                }
                case INSERT: 
                case UPDATE: {
                    this.validateAssertion(mutation.getEntity().hasKey(), String.valueOf(name).concat(" does not have a key."));
                }
                default: {
                    String string = String.valueOf(mutation.getOp());
                    throw new RpcException(Codes.Code.INVALID_ARGUMENT, new StringBuilder(34 + String.valueOf(name).length() + String.valueOf(string).length()).append(name).append(" specifies unsupported operation ").append(string).append(".").toString());
                }
            }
            this.validateAssertion(keys.add(key), String.valueOf(name).concat(" key already specified in a previous operation."));
        }
    }

    public void validateSinceQuery(long minVersion, DatastoreMobileService.RunQueryRequest sinceQuery) throws RpcException {
        if (minVersion < 0L) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "Invalid min_version");
        }
        this.validateQueryRequest(sinceQuery);
        if (sinceQuery.hasReadOptions()) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "ReadOptions cannot be specified on SyncRequest.since_query_request");
        }
    }

    public void validateQueryRequest(DatastoreMobileService.RunQueryRequest query) throws RpcException {
        if (!query.hasQuery()) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, "No query specified in the RunQueryRequest.");
        }
    }

    private void validateReceiptEntity(EntityV4.Entity receiptEntity) throws RpcException {
        this.validateAssertion(receiptEntity.hasKey(), "receipt_entity does not have a key.");
        for (EntityV4.Property prop : receiptEntity.getPropertyList()) {
            this.validateAssertion(!prop.getValue().hasBlobKeyValue(), "BlobKey is an unsupported receipt value type.");
            this.validateAssertion(!prop.getValue().hasEntityValue(), "Entity is an unsupported receipt value type.");
        }
    }

    private void validateAssertion(boolean condition, String msg) throws RpcException {
        if (!condition) {
            throw new RpcException(Codes.Code.INVALID_ARGUMENT, msg);
        }
    }
}

