/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.client.datastoreservice.app.mobile;

import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.api.oauth.OAuthServiceFactory;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.net.util.error.Codes;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileRpcHandler;
import com.google.apphosting.client.datastoreservice.app.mobile.DatastoreMobileRpcService;
import com.google.apphosting.client.datastoreservice.app.mobile.IdTokenAuthenticator;
import com.google.apphosting.client.datastoreservice.mobile.DatastoreMobileService;
import com.google.apphosting.client.serviceapp.AuthService;
import com.google.apphosting.client.serviceapp.AuthServiceImpl;
import com.google.apphosting.client.serviceapp.BaseApiServlet;
import com.google.apphosting.client.serviceapp.Clock;
import com.google.apphosting.client.serviceapp.RpcException;
import com.google.apphosting.client.serviceapp.RpcHandler;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class DatastoreMobileApiServlet
extends BaseApiServlet {
    @VisibleForTesting
    static final String API_HEADER = "X-AppEngine-DatastoreMobile-API";
    @VisibleForTesting
    public static final String[] OAUTH2_SCOPE_STRINGS = new String[]{"https://www.googleapis.com/auth/datastoremobile", "https://www.googleapis.com/auth/cloud-platform"};
    @VisibleForTesting
    public static final String[] OAUTH2_SCOPE_CODES = new String[]{"43610", "35600"};
    private static final int MAX_APP_ID_SECTION_LENGTH = 100;
    private static final String APP_ID_PARTITION_STRING = String.format("[a-z\\d\\-]{1,%d}", 100);
    private static final String APP_ID_DOMAIN_STRING = String.format("[a-z\\d][a-z\\d\\-\\.]{0,%d}", 99);
    private static final String APP_ID_DISPLAY_STRING = String.format("[a-z\\d][a-z\\d\\-]{0,%d}", 99);
    private static final String PROJECT_ID_STRING = String.format("(?:(?:%s):)?(?:%s)", APP_ID_DOMAIN_STRING, APP_ID_DISPLAY_STRING);
    private static final String APP_ID_STRING = String.format("(?:(?<cluster>%s)~)?(?<project>%s)", APP_ID_PARTITION_STRING, PROJECT_ID_STRING);
    private static final Pattern APP_ID_REGEX = Pattern.compile(APP_ID_STRING);
    private static final Pattern CLIENT_ID_TOKEN_REGEX = Pattern.compile("Bearer\\s+(?<token>.*)", 8);
    public static final String INVALID_CLIENT_ID_ERROR = "Invalid Client ID.";
    public static final String INVALID_USER_CRED_ERROR = "Unauthorized.";
    private IdTokenAuthenticator idTokenAuth;

    public DatastoreMobileApiServlet() {
        this(new AuthServiceImpl(OAuthServiceFactory.getOAuthService()), new IdTokenAuthenticator());
    }

    @VisibleForTesting
    public DatastoreMobileApiServlet(AuthService authService, IdTokenAuthenticator idTokenAuth) {
        this(new DatastoreMobileRpcService(ApiProxy.getCurrentEnvironment().getAppId(), authService, idTokenAuth), idTokenAuth);
    }

    DatastoreMobileApiServlet(DatastoreMobileRpcService rpcService, IdTokenAuthenticator idTokenAuth) {
        super(rpcService.getAuthService(), Clock.SYSTEM_CLOCK, rpcService);
        this.idTokenAuth = idTokenAuth;
    }

    @Override
    protected String getApiHeader() {
        return API_HEADER;
    }

    @Override
    protected String[] getOAuthScopeStrings() {
        return OAUTH2_SCOPE_STRINGS;
    }

    @Override
    protected String[] getOAuthScopeCodes() {
        return OAUTH2_SCOPE_CODES;
    }

    @Override
    protected void authenticate(RpcHandler.RequestPermissions requiredPermissions, @Nullable MessageLite requestHeader) throws RpcException {
        String peerAuthorizationToken = this.getPeerAuthorization(requestHeader);
        String clientIdTokenWithBearer = this.getAuthorization(requestHeader);
        String errMsg = null;
        if (!peerAuthorizationToken.isEmpty()) {
            try {
                Matcher clientIdTokenMatcher = CLIENT_ID_TOKEN_REGEX.matcher(clientIdTokenWithBearer);
                if (!clientIdTokenMatcher.matches()) {
                    String string = String.valueOf("Invalid Client ID.: invalid client id token=");
                    String string2 = String.valueOf(clientIdTokenWithBearer);
                    throw new GeneralSecurityException(string2.length() != 0 ? string.concat(string2) : new String(string));
                }
                String authorizationToken = clientIdTokenMatcher.group("token");
                this.idTokenAuth.authenticate(peerAuthorizationToken, authorizationToken);
                String clientTokenProjectId = this.idTokenAuth.getProjectId();
                String appId = ApiProxy.getCurrentEnvironment().getAppId();
                errMsg = DatastoreMobileApiServlet.matchProjectId(appId, clientTokenProjectId);
            }
            catch (IOException | GeneralSecurityException ex) {
                String string = String.valueOf("Unauthorized.: ");
                String string3 = String.valueOf(ex.getMessage());
                errMsg = string3.length() != 0 ? string.concat(string3) : new String(string);
            }
        } else {
            try {
                this.authService.getUserPermissions(OAUTH2_SCOPE_CODES, false);
                String appId = ApiProxy.getCurrentEnvironment().getAppId();
                String clientTokenProjectId = this.getClientTokenProjectId(requestHeader);
                errMsg = DatastoreMobileApiServlet.matchProjectId(appId, clientTokenProjectId);
            }
            catch (OAuthRequestException ex) {
                String string = String.valueOf("Unauthorized.: ");
                String string4 = String.valueOf(ex.getMessage());
                String string5 = errMsg = string4.length() != 0 ? string.concat(string4) : new String(string);
            }
        }
        if (errMsg != null) {
            throw new RpcException(Codes.Code.PERMISSION_DENIED, errMsg);
        }
    }

    @VisibleForTesting
    static String matchProjectId(String appId, String clientTokenProjectId) {
        Matcher projectIdMatcher = APP_ID_REGEX.matcher(appId);
        if (!projectIdMatcher.matches()) {
            String string = String.valueOf("Invalid Client ID.: invalid project id=");
            String string2 = String.valueOf(appId);
            return string2.length() != 0 ? string.concat(string2) : new String(string);
        }
        if (!projectIdMatcher.group("project").equals(clientTokenProjectId)) {
            String string = String.valueOf("Invalid Client ID.: expected=");
            String string3 = String.valueOf(projectIdMatcher.group("project"));
            return new StringBuilder(6 + String.valueOf(string).length() + String.valueOf(string3).length() + String.valueOf(clientTokenProjectId).length()).append(string).append(string3).append(", got=").append(clientTokenProjectId).toString();
        }
        return null;
    }

    @VisibleForTesting
    public String getPeerAuthorization(MessageLite requestHeader) {
        return requestHeader == null ? "" : ((DatastoreMobileService.RequestHeader)requestHeader).getApiaryIdToken();
    }

    @VisibleForTesting
    public String getAuthorization(MessageLite requestHeader) {
        return requestHeader == null ? "" : ((DatastoreMobileService.RequestHeader)requestHeader).getClientIdToken();
    }

    private String getClientTokenProjectId(MessageLite requestHeader) {
        return requestHeader == null ? "" : ((DatastoreMobileService.RequestHeader)requestHeader).getClientTokenProjectId();
    }

    @VisibleForTesting(productionVisibility=VisibleForTesting.Visibility.NONE)
    public byte[] injectRequestHeaderForTest(String uri, byte[] body, DatastoreMobileService.RequestHeader hdr) throws IOException {
        DatastoreMobileRpcHandler handler = (DatastoreMobileRpcHandler)this.getHandler(uri);
        return handler.deserializeWithHeader(body, hdr).toByteArray();
    }
}

